/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.Doc;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionUtils;
import org.netbeans.modules.java.editor.javadoc.TagRegistery;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavadocCompletionItem
implements CompletionItem {
    private static final String JAVADOC_TAG_ICON = "org/netbeans/modules/java/editor/resources/javadoctag.gif";
    private static final String JAVADOC_PARAM_ICON = "org/netbeans/modules/editor/resources/completion/localVariable.gif";
    private static final String PARAMETER_COLOR = "<font color=#00007c>";
    private static final String COLOR_END = "</font>";
    private static final String BOLD = "<b>";
    private static final String BOLD_END = "</b>";
    private int substitutionOffset;
    private String txt;
    private String leftHtmlText;
    private String rightHtmlText;
    private final String iconPath;
    private final int sortPriority;
    private ImageIcon icon = null;

    public JavadocCompletionItem(String string, int n, String string2, String string3, String string4, int n2) {
        this.substitutionOffset = n;
        this.txt = string;
        this.leftHtmlText = string2;
        this.rightHtmlText = string3;
        this.iconPath = string4;
        this.sortPriority = n2;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion.get().hideAll();
        JavadocCompletionItem.complete(jTextComponent, this.txt + ' ', this.substitutionOffset);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public final int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public final void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        CompletionUtilities.renderHtml((ImageIcon)this.icon, (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    protected ImageIcon createIcon() {
        return new ImageIcon(Utilities.loadImage((String)this.iconPath));
    }

    protected String getLeftHtmlText() {
        if (this.leftHtmlText == null) {
            this.leftHtmlText = this.txt;
        }
        return this.leftHtmlText;
    }

    protected String getRightHtmlText() {
        return this.rightHtmlText;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public int getSortPriority() {
        return this.sortPriority;
    }

    public CharSequence getSortText() {
        return this.txt;
    }

    public CharSequence getInsertPrefix() {
        return this.txt;
    }

    public String toString() {
        return super.toString() + String.format("[txt:%1$s, substitutionOffset:%2$d]", this.txt, this.substitutionOffset);
    }

    public static List<CompletionItem> addBlockTagItems(Doc doc, ElementKind elementKind, String string, int n) {
        List<TagRegistery.TagEntry> list = TagRegistery.getDefault().getTags(elementKind, false);
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        for (TagRegistery.TagEntry tagEntry : list) {
            if (!tagEntry.name.startsWith(string)) continue;
            arrayList.add(new JavadocCompletionItem(tagEntry.name, n, null, null, JAVADOC_TAG_ICON, 500));
        }
        return arrayList;
    }

    public static List<CompletionItem> addInlineTagItems(Doc doc, ElementKind elementKind, String string, int n) {
        List<TagRegistery.TagEntry> list = TagRegistery.getDefault().getTags(elementKind, true);
        ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>(list.size());
        for (TagRegistery.TagEntry tagEntry : list) {
            if (!tagEntry.name.startsWith(string)) continue;
            arrayList.add(new JavadocCompletionItem(tagEntry.name, n, null, null, JAVADOC_TAG_ICON, 500));
        }
        return arrayList;
    }

    public static CompletionItem createNameItem(String string, int n) {
        String string2 = string.charAt(0) == '<' ? "&lt;" + string.substring(1, string.length() - 1) + "&gt;" : string;
        return new JavadocCompletionItem(string, n, "<font color=#00007c><b>" + string2 + BOLD_END + COLOR_END, null, JAVADOC_PARAM_ICON, 100);
    }

    public static CompletionItem createExecutableItem(ExecutableElement executableElement, ExecutableType executableType, int n, boolean bl, boolean bl2) {
        JavaCompletionItem javaCompletionItem = JavaCompletionItem.createExecutableItem(executableElement, executableType, n, bl, bl2, false, false);
        return new JavadocExecutableItem(javaCompletionItem, executableElement, n);
    }

    public static CompletionItem createTypeItem(TypeElement typeElement, int n, boolean bl, boolean bl2) {
        JavaCompletionItem javaCompletionItem = JavaCompletionItem.createTypeItem(typeElement, (DeclaredType)typeElement.asType(), n, bl, bl2, false, false);
        return new JavadocTypeItem(javaCompletionItem, n);
    }

    private static void complete(final JTextComponent jTextComponent, final String string, final int n) {
        try {
            Document document = jTextComponent.getDocument();
            NbDocument.runAtomicAsUser((StyledDocument)((StyledDocument)document), (Runnable)new Runnable(){

                public void run() {
                    JavadocCompletionItem.completeAsUser(jTextComponent, string, n);
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static void completeAsUser(JTextComponent jTextComponent, String string, int n) {
        Document document = jTextComponent.getDocument();
        try {
            int n2;
            CharSequence charSequence = JavadocCompletionUtils.getCharSequence(document);
            for (n2 = 0; n2 < string.length() && n + n2 < charSequence.length() && charSequence.charAt(n + n2) == string.charAt(n2); ++n2) {
            }
            if (n2 == string.length()) {
                jTextComponent.setCaretPosition(n + n2);
                return;
            }
            if (n2 > 0) {
                string = string.substring(n2);
            }
            document.insertString(n + n2, string, null);
            jTextComponent.setCaretPosition(n + n2 + string.length());
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static class JavadocTypeItem
    implements CompletionItem {
        private final CompletionItem delegate;
        private final int substitutionOffset;

        public JavadocTypeItem(CompletionItem completionItem, int n) {
            this.delegate = completionItem;
            this.substitutionOffset = n;
        }

        public void defaultAction(JTextComponent jTextComponent) {
            this.delegate.defaultAction(jTextComponent);
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 400) {
                switch (keyEvent.getKeyChar()) {
                    case '#': 
                    case '.': {
                        JTextComponent jTextComponent = (JTextComponent)keyEvent.getSource();
                        this.delegate.defaultAction(jTextComponent);
                        JavadocCompletionItem.complete(jTextComponent, String.valueOf(keyEvent.getKeyChar()), jTextComponent.getCaretPosition());
                        keyEvent.consume();
                    }
                }
            }
        }

        public int getPreferredWidth(Graphics graphics, Font font) {
            return this.delegate.getPreferredWidth(graphics, font);
        }

        public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
            this.delegate.render(graphics, font, color, color2, n, n2, bl);
        }

        public CompletionTask createDocumentationTask() {
            return this.delegate.createDocumentationTask();
        }

        public CompletionTask createToolTipTask() {
            return this.delegate.createToolTipTask();
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return this.delegate.instantSubstitution(jTextComponent);
        }

        public int getSortPriority() {
            return this.delegate.getSortPriority();
        }

        public CharSequence getSortText() {
            return this.delegate.getSortText();
        }

        public CharSequence getInsertPrefix() {
            return this.delegate.getInsertPrefix();
        }
    }

    private static class JavadocExecutableItem
    implements CompletionItem {
        private final CompletionItem delegate;
        private final String[] paramTypes;
        private final CharSequence name;
        private final int substitutionOffset;

        public JavadocExecutableItem(CompletionItem completionItem, ExecutableElement executableElement, int n) {
            this.delegate = completionItem;
            this.substitutionOffset = n;
            this.name = executableElement.getKind() == ElementKind.METHOD ? executableElement.getSimpleName() : executableElement.getEnclosingElement().getSimpleName();
            List<? extends VariableElement> list = executableElement.getParameters();
            this.paramTypes = new String[list.size()];
            int n2 = 0;
            for (VariableElement variableElement : list) {
                TypeMirror typeMirror = variableElement.asType();
                this.paramTypes[n2++] = ((Object)this.resolveTypeName(typeMirror)).toString();
            }
        }

        private CharSequence resolveTypeName(TypeMirror typeMirror) {
            CharSequence charSequence;
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                Element element = ((DeclaredType)typeMirror).asElement();
                charSequence = element.getKind().isClass() || element.getKind().isInterface() ? ((TypeElement)element).getQualifiedName() : element.getSimpleName();
            } else if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                while ((typeMirror = ((TypeVariable)typeMirror).getUpperBound()).getKind() == TypeKind.TYPEVAR) {
                }
                charSequence = this.resolveTypeName(typeMirror);
            } else {
                charSequence = ((Object)typeMirror).toString();
            }
            return charSequence;
        }

        public void defaultAction(JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
                int n = jTextComponent.getSelectionEnd();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.name);
                if (this.paramTypes.length == 0) {
                    stringBuilder.append("() ");
                } else {
                    stringBuilder.append('(');
                    for (String string : this.paramTypes) {
                        stringBuilder.append(string).append(", ");
                    }
                    stringBuilder.setCharAt(stringBuilder.length() - 2, ')');
                }
                JavadocCompletionItem.complete(jTextComponent, stringBuilder.toString(), this.substitutionOffset);
            }
        }

        public void processKeyEvent(KeyEvent keyEvent) {
        }

        public int getPreferredWidth(Graphics graphics, Font font) {
            return this.delegate.getPreferredWidth(graphics, font);
        }

        public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
            this.delegate.render(graphics, font, color, color2, n, n2, bl);
        }

        public CompletionTask createDocumentationTask() {
            return this.delegate.createDocumentationTask();
        }

        public CompletionTask createToolTipTask() {
            return this.delegate.createToolTipTask();
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return this.delegate.instantSubstitution(jTextComponent);
        }

        public int getSortPriority() {
            return this.delegate.getSortPriority();
        }

        public CharSequence getSortText() {
            return this.delegate.getSortText();
        }

        public CharSequence getInsertPrefix() {
            return this.delegate.getInsertPrefix();
        }
    }
}

