/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import java.util.Properties;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.palette.PaletteItemDataLoader;
import org.netbeans.modules.vmd.palette.PaletteItemDataNode;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class PaletteItemDataObject
extends MultiDataObject
implements FileChangeListener {
    private String producerID;
    private String displayName;
    private String toolTip;
    private String icon;
    private String bigIcon;

    public PaletteItemDataObject(FileObject fileObject, PaletteItemDataLoader paletteItemDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)paletteItemDataLoader);
        FileChangeListener fileChangeListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)fileObject);
        fileObject.addFileChangeListener(fileChangeListener);
        this.readProperties(fileObject);
    }

    protected Node createNodeDelegate() {
        return new PaletteItemDataNode(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readProperties(FileObject fileObject) throws IOException {
        Properties properties;
        block7: {
            properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = fileObject.getInputStream();
                properties.load(inputStream);
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{iOException.toString()});
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Debug.warning((Object[])new Object[]{iOException.toString()});
            }
        }
        this.producerID = properties.getProperty("producerID");
        this.displayName = properties.getProperty("displayName");
        this.toolTip = properties.getProperty("toolTip");
        this.icon = properties.getProperty("icon");
        if (this.icon != null && this.icon.length() == 0) {
            this.icon = null;
        }
        this.bigIcon = properties.getProperty("bigIcon");
        if (this.bigIcon == null) return;
        if (this.bigIcon.length() != 0) return;
        this.bigIcon = null;
    }

    String getProducerID() {
        return this.producerID;
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getToolTip() {
        return this.toolTip;
    }

    String getIcon() {
        return this.icon;
    }

    String getBigIcon() {
        return this.bigIcon;
    }

    String getProjectType() {
        String string = this.getPrimaryFile().getPath();
        return string.substring(0, string.indexOf(47));
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        try {
            this.readProperties(fileEvent.getFile());
        }
        catch (IOException iOException) {
            Debug.warning((Object[])new Object[]{iOException});
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }
}

