/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SClassNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.util.ByteList;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.SourceModel;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.DefaultParseListener;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstUtilities {
    private static final boolean INCLUDE_DEFS_PREFIX = false;

    public static int getAstOffset(CompilationInfo compilationInfo, int n) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-ruby", 0);
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            return translatedSource.getAstOffset(n);
        }
        return n;
    }

    public static OffsetRange getAstOffsets(CompilationInfo compilationInfo, OffsetRange offsetRange) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-ruby", 0);
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            int n = offsetRange.getStart();
            int n2 = translatedSource.getAstOffset(n);
            if (n2 == n) {
                return offsetRange;
            }
            if (n2 == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(n2, n2 + offsetRange.getLength());
        }
        return offsetRange;
    }

    private AstUtilities() {
    }

    public static List<String> gatherDocumentation(CompilationInfo compilationInfo, BaseDocument baseDocument, Node node) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = node.getPosition().getStartOffset();
        if (compilationInfo != null) {
            n = LexUtilities.getLexerOffset(compilationInfo, n);
        }
        try {
            if (n >= baseDocument.getLength()) {
                return null;
            }
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            --n2;
            while (n2 >= 0 && (Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2))) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n2))) {
                --n2;
            }
            if (n2 < 0) {
                return null;
            }
            while (n2 >= 0 && !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2))) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n2)) {
                int n3;
                int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                String string = baseDocument.getText(n4, (n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + 1) - n4);
                if (string.startsWith("#")) {
                    linkedList.addFirst(string);
                } else {
                    if (linkedList.size() == 0 && string.startsWith("=end") && n4 == Utilities.getRowStart((BaseDocument)baseDocument, (int)n2)) {
                        AstUtilities.gatherInlineDocumentation(linkedList, baseDocument, n2);
                        return linkedList;
                    }
                    if (!string.equals("public") && !string.equals("private") && !string.equals("protected")) break;
                    --n2;
                    while (n2 >= 0 && (Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2))) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n2))) {
                        --n2;
                    }
                    continue;
                }
                --n2;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return linkedList;
    }

    private static void gatherInlineDocumentation(LinkedList<String> linkedList, BaseDocument baseDocument, int n) throws BadLocationException {
        n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        --n;
        while (n >= 0) {
            int n2;
            int n3 = n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            String string = baseDocument.getText(n3, (n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n)) - n3);
            if (string.startsWith("=begin")) {
                return;
            }
            linkedList.addFirst(string);
            --n;
        }
    }

    public static Node getForeignNode(final IndexedElement indexedElement, Node[] nodeArray) {
        String string;
        ParserFile parserFile = indexedElement.getFile();
        if (parserFile == null) {
            return null;
        }
        List<ParserFile> list = Collections.singletonList(parserFile);
        SourceFileReader sourceFileReader = new SourceFileReader(){

            public CharSequence read(ParserFile parserFile) throws IOException {
                Document document = indexedElement.getDocument();
                if (document == null) {
                    return "";
                }
                try {
                    return document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    IOException iOException = new IOException();
                    iOException.initCause(badLocationException);
                    throw iOException;
                }
            }

            public int getCaretOffset(ParserFile parserFile) {
                return -1;
            }
        };
        DefaultParseListener defaultParseListener = new DefaultParseListener();
        TranslatedSource translatedSource = null;
        Parser.Job job = new Parser.Job(list, (ParseListener)defaultParseListener, sourceFileReader, translatedSource);
        new RubyParser().parseFiles(job);
        ParserResult parserResult = defaultParseListener.getParserResult();
        if (parserResult == null) {
            return null;
        }
        Node node = AstUtilities.getRoot(parserResult);
        if (node == null) {
            return null;
        }
        if (nodeArray != null) {
            nodeArray[0] = node;
        }
        if ((string = indexedElement.getSignature()) == null) {
            return null;
        }
        Node node2 = AstUtilities.findBySignature(node, string);
        if (node2 == null && "new".equals(indexedElement.getName())) {
            string = string.replaceFirst("new", "initialize");
            node2 = AstUtilities.findBySignature(node, string);
        }
        return node2;
    }

    public static int boundCaretOffset(CompilationInfo compilationInfo, int n) {
        int n2;
        Document document = compilationInfo.getDocument();
        if (document != null && n > (n2 = document.getLength())) {
            n = n2;
        }
        return n;
    }

    public static Set<String> getRequires(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        AstUtilities.addRequires(node, hashSet);
        return hashSet;
    }

    private static void addRequires(Node node, Set<String> set) {
        ListNode listNode;
        Object object;
        Object object2;
        if (node.nodeId == NodeType.FCALLNODE) {
            ByteList byteList;
            Node node2;
            object2 = ((INameNode)node).getName();
            if (((String)object2).equals("require") && (object = ((FCallNode)node).getArgsNode()) instanceof ListNode && (listNode = (ListNode)object).size() > 0 && (node2 = listNode.get(0)) instanceof StrNode && (byteList = ((StrNode)node2).getValue()) != null && byteList.length() > 0) {
                set.add(byteList.toString());
            }
        } else if (node.nodeId == NodeType.MODULENODE || node.nodeId == NodeType.CLASSNODE || node.nodeId == NodeType.DEFNNODE || node.nodeId == NodeType.DEFSNODE) {
            return;
        }
        object2 = node.childNodes();
        object = object2.iterator();
        while (object.hasNext()) {
            listNode = (Node)object.next();
            if (listNode.isInvisible()) continue;
            AstUtilities.addRequires((Node)listNode, set);
        }
    }

    public static MethodDefNode findMethod(Node node, String string, Arity arity) {
        Object object;
        if ((node.nodeId == NodeType.DEFNNODE || node.nodeId == NodeType.DEFSNODE) && ((MethodDefNode)node).getName().equals(string) && Arity.matches(arity, (Arity)(object = Arity.getDefArity(node)))) {
            return (MethodDefNode)node;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MethodDefNode methodDefNode;
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible() || (methodDefNode = AstUtilities.findMethod(node2, string, arity)) == null) continue;
            return methodDefNode;
        }
        return null;
    }

    public static MethodDefNode findMethodAtOffset(Node node, int n) {
        AstPath astPath = new AstPath(node, n);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.nodeId != NodeType.DEFNNODE && node2.nodeId != NodeType.DEFSNODE) continue;
            return (MethodDefNode)node2;
        }
        return null;
    }

    public static ClassNode findClassAtOffset(Node node, int n) {
        AstPath astPath = new AstPath(node, n);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (!(node2 instanceof ClassNode)) continue;
            return (ClassNode)node2;
        }
        return null;
    }

    public static Node findLocalScope(Node node, AstPath astPath) {
        MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
        if (methodDefNode == null) {
            ListIterator<Node> listIterator = astPath.leafToRoot();
            while (listIterator.hasNext()) {
                Node node2 = (Node)listIterator.next();
                switch (node2.nodeId) {
                    case DEFNNODE: 
                    case DEFSNODE: 
                    case CLASSNODE: 
                    case SCLASSNODE: 
                    case MODULENODE: {
                        return node2;
                    }
                }
            }
            if (astPath.root() != null) {
                return astPath.root();
            }
            methodDefNode = AstUtilities.findBlock(astPath);
        }
        if (methodDefNode == null) {
            methodDefNode = astPath.leafParent();
            if (methodDefNode.nodeId == NodeType.NEWLINENODE) {
                methodDefNode = astPath.leafGrandParent();
            }
            if (methodDefNode == null) {
                methodDefNode = node;
            }
        }
        return methodDefNode;
    }

    public static Node findDynamicScope(Node node, AstPath astPath) {
        Node node2 = AstUtilities.findBlock(astPath);
        if (node2 == null && (node2 = astPath.leafParent()) == null) {
            node2 = node;
        }
        return node2;
    }

    public static Node findBlock(AstPath astPath) {
        Node node = null;
        for (Node node2 : astPath) {
            switch (node2.nodeId) {
                case ITERNODE: {
                    node = node2;
                    break;
                }
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    return node;
                }
            }
        }
        return node;
    }

    public static MethodDefNode findMethod(AstPath astPath) {
        for (Node node : astPath) {
            if (node.nodeId == NodeType.DEFNNODE || node.nodeId == NodeType.DEFSNODE) {
                return (MethodDefNode)node;
            }
            if (node.nodeId != NodeType.CLASSNODE && node.nodeId != NodeType.SCLASSNODE && node.nodeId != NodeType.MODULENODE) continue;
            break;
        }
        return null;
    }

    public static ClassNode findClass(AstPath astPath) {
        for (Node node : astPath) {
            if (!(node instanceof ClassNode)) continue;
            return (ClassNode)node;
        }
        return null;
    }

    public static IScopingNode findClassOrModule(AstPath astPath) {
        for (Node node : astPath) {
            if (node.nodeId != NodeType.CLASSNODE && node.nodeId != NodeType.MODULENODE) continue;
            return (IScopingNode)node;
        }
        return null;
    }

    public static boolean isCall(Node node) {
        return node.nodeId == NodeType.FCALLNODE || node.nodeId == NodeType.VCALLNODE || node.nodeId == NodeType.CALLNODE;
    }

    public static String getCallName(Node node) {
        assert (AstUtilities.isCall(node));
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        assert (false) : node;
        return null;
    }

    public static String getDefName(Node node) {
        if (node instanceof MethodDefNode) {
            return ((MethodDefNode)node).getName();
        }
        assert (false) : node;
        return null;
    }

    public static ArgumentNode getDefNameNode(MethodDefNode methodDefNode) {
        return methodDefNode.getNameNode();
    }

    public static boolean isConstructorMethod(MethodDefNode methodDefNode) {
        String string = methodDefNode.getName();
        return string.equals("new") || string.equals("initialize");
    }

    public static List<String> getDefArgs(MethodDefNode methodDefNode, boolean bl) {
        List list = methodDefNode.childNodes();
        for (Node node : list) {
            Object object;
            if (!(node instanceof ArgsNode)) continue;
            ArgsNode argsNode = (ArgsNode)node;
            List list2 = argsNode.childNodes();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Node node2 : list2) {
                if (!(node2 instanceof ListNode)) continue;
                List list3 = node2.childNodes();
                for (Node node3 : list3) {
                    String string;
                    if (node3 instanceof ArgumentNode) {
                        string = ((ArgumentNode)node3).getName();
                        arrayList.add(string);
                        continue;
                    }
                    if (!(node3 instanceof LocalAsgnNode)) continue;
                    string = ((LocalAsgnNode)node3).getName();
                    arrayList.add(string);
                }
            }
            if (argsNode.getRestArgNode() != null) {
                object = argsNode.getRestArgNode().getName();
                if (!bl) {
                    object = "*" + (String)object;
                }
                arrayList.add((String)object);
            }
            if (argsNode.getBlockArgNode() != null) {
                object = argsNode.getBlockArgNode().getName();
                if (!bl) {
                    object = "&" + (String)object;
                }
                arrayList.add((String)object);
            }
            return arrayList;
        }
        return null;
    }

    public static String getDefSignature(MethodDefNode methodDefNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(AstUtilities.getDefName((Node)methodDefNode));
        List<String> list = AstUtilities.getDefArgs(methodDefNode, false);
        if (list != null && list.size() > 0) {
            stringBuilder.append('(');
            Iterator<String> iterator = list.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                stringBuilder.append(iterator.next());
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static int findArgumentIndex(Node node, int n) {
        switch (node.nodeId) {
            case FCALLNODE: {
                Node node2 = ((FCallNode)node).getArgsNode();
                return AstUtilities.findArgumentIndex(node2, n);
            }
            case CALLNODE: {
                Node node3 = ((CallNode)node).getArgsNode();
                return AstUtilities.findArgumentIndex(node3, n);
            }
            case ARGSCATNODE: {
                ArgsCatNode argsCatNode = (ArgsCatNode)node;
                int n2 = AstUtilities.findArgumentIndex(argsCatNode.getFirstNode(), n);
                if (n2 != -1) {
                    return n2;
                }
                n2 = AstUtilities.findArgumentIndex(argsCatNode.getSecondNode(), n);
                if (n2 != -1) {
                    return AstUtilities.getConstantArgs(argsCatNode) + n2;
                }
                ISourcePosition iSourcePosition = node.getPosition();
                if (n >= iSourcePosition.getStartOffset() && n <= iSourcePosition.getEndOffset()) {
                    return AstUtilities.getConstantArgs(argsCatNode);
                }
            }
            case HASHNODE: {
                return n;
            }
        }
        if (node instanceof ListNode) {
            List list = node.childNodes();
            int n3 = Integer.MAX_VALUE;
            for (int i = 0; i < list.size(); ++i) {
                OffsetRange offsetRange;
                Node node4 = (Node)list.get(i);
                if (node4.isInvisible()) continue;
                if (node4.nodeId == NodeType.HASHNODE) {
                    offsetRange = AstUtilities.getRange(node4);
                    if (n <= offsetRange.getEnd() && (n >= n3 || n >= offsetRange.getStart())) {
                        return i;
                    }
                    n3 = offsetRange.getEnd();
                    continue;
                }
                offsetRange = node4.getPosition();
                if (n <= offsetRange.getEndOffset() && (n >= n3 || n >= offsetRange.getStartOffset())) {
                    return i;
                }
                n3 = offsetRange.getEndOffset();
            }
            ISourcePosition iSourcePosition = node.getPosition();
            if (n > iSourcePosition.getStartOffset() && n < iSourcePosition.getEndOffset()) {
                return 0;
            }
        } else {
            ISourcePosition iSourcePosition = node.getPosition();
            if (n >= iSourcePosition.getStartOffset() && n <= iSourcePosition.getEndOffset()) {
                return 0;
            }
        }
        return -1;
    }

    private static int getConstantArgs(ArgsCatNode argsCatNode) {
        Node node = argsCatNode.getFirstNode();
        if (node instanceof ListNode) {
            List list = node.childNodes();
            return list.size();
        }
        return 1;
    }

    public static boolean isCallFor(Node node, Arity arity, Node node2) {
        assert (AstUtilities.isCall(node));
        assert (node2 instanceof MethodDefNode);
        return AstUtilities.getDefName(node2).equals(AstUtilities.getCallName(node)) && Arity.matches(arity, Arity.getDefArity(node2));
    }

    public static Node findBySignature(Node node, String string) {
        String string2 = string;
        String string3 = AstUtilities.getNextSigComponent(string);
        Node node2 = AstUtilities.findBySignature(node, string = string.substring(string3.length()), string3);
        if (node2 == null && string2.startsWith("Object#")) {
            string2 = string2.substring(string2.indexOf(35) + 1);
            string3 = AstUtilities.getNextSigComponent(string);
            string = string2.substring(string3.length());
            node2 = AstUtilities.findBySignature(node, string, string3);
        }
        return node2;
    }

    private static String getNextSigComponent(String string) {
        char c;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (n = 0; n < n2 && ((c = string.charAt(n)) == '#' || c == ':' || c == '('); ++n) {
        }
        while (n < n2 && (c = string.charAt(n)) != '#' && c != ':' && c != '(') {
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static Node findBySignature(Node node, String string, String string2) {
        String[] stringArray;
        switch (node.nodeId) {
            case INSTASGNNODE: {
                String string3;
                if (string2.charAt(0) != '@' || !string2.equals(string3 = ((INameNode)node).getName())) break;
                return node;
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                String string4;
                if (!string2.startsWith("@@") || !string2.equals(string4 = ((INameNode)node).getName())) break;
                return node;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                Object object;
                boolean bl = Character.isLowerCase(string2.charAt(0));
                if (bl && string2.equals(AstUtilities.getDefName(node))) {
                    object = AstUtilities.getDefArgs((MethodDefNode)node, false);
                    if (string.length() == 0 && (object == null || object.size() == 0)) {
                        return node;
                    }
                    if (string.length() == 0) break;
                    assert (string.charAt(0) == '(');
                    String string5 = string.substring(1, string.length() - 1);
                    stringArray = string5.split(",");
                    if (stringArray.length != object.size()) break;
                    int n = 1;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals(object.get(i))) continue;
                        n = 0;
                        break;
                    }
                    if (n == 0) break;
                    return node;
                }
                if (!AstUtilities.isAttr(node)) break;
                for (Object object2 : object = AstUtilities.getAttrSymbols(node)) {
                    if (!string2.equals(object2.getName())) continue;
                    return node;
                }
                break;
            }
            case CLASSNODE: 
            case MODULENODE: {
                Object object = ((IScopingNode)node).getCPath();
                if (object instanceof Colon2Node) {
                    String string6 = AstUtilities.getFqn((Colon2Node)object);
                    if (!string6.startsWith(string2) || !string.startsWith(string6.substring(string2.length()))) break;
                    if ((string2 = AstUtilities.getNextSigComponent(string = string.substring(string6.substring(string2.length()).length()))).length() == 0) {
                        return node;
                    }
                    int n = string.indexOf(string2);
                    assert (n != -1);
                    string = string.substring(n + string2.length());
                    break;
                }
                if (!string2.equals(AstUtilities.getClassOrModuleName((IScopingNode)node))) break;
                string2 = AstUtilities.getNextSigComponent(string);
                if (string2.length() == 0) {
                    return node;
                }
                int n = string.indexOf(string2);
                assert (n != -1);
                string = string.substring(n + string2.length());
                break;
            }
            case SCLASSNODE: {
                Object object = ((SClassNode)node).getReceiverNode();
                String string7 = null;
                if (object instanceof Colon2Node) {
                    string7 = ((Colon2Node)object).getName();
                } else if (object instanceof ConstNode) {
                    string7 = ((ConstNode)object).getName();
                }
                if (string7 == null || !string2.equals(string7)) break;
                string2 = AstUtilities.getNextSigComponent(string);
                if (string2.length() == 0) {
                    return node;
                }
                int n = string.indexOf(string2);
                assert (n != -1);
                string = string.substring(n + string2.length());
            }
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            if (node2.isInvisible() || (stringArray = AstUtilities.findBySignature(node2, string, string2)) == null) continue;
            return stringArray;
        }
        return null;
    }

    public static boolean containsOffset(Node node, int n) {
        ISourcePosition iSourcePosition = node.getPosition();
        return n >= iSourcePosition.getStartOffset() && n <= iSourcePosition.getEndOffset();
    }

    public static OffsetRange getRange(Node node) {
        if (node.isInvisible()) {
            return OffsetRange.NONE;
        }
        if (node.nodeId == NodeType.NOTNODE) {
            ISourcePosition iSourcePosition = node.getPosition();
            List list = node.childNodes();
            if (list != null && list.size() > 0) {
                Node node2 = (Node)list.get(0);
                if (node2.nodeId == NodeType.NEWLINENODE) {
                    OffsetRange offsetRange = AstUtilities.getRange(node2);
                    return new OffsetRange(iSourcePosition.getStartOffset(), offsetRange.getEnd());
                }
            }
            return new OffsetRange(iSourcePosition.getStartOffset(), iSourcePosition.getEndOffset());
        }
        if (node.nodeId == NodeType.HASHNODE) {
            List list = node.childNodes();
            if (list != null && list.size() > 0) {
                int n = ((Node)list.get(0)).getPosition().getStartOffset();
                int n2 = ((Node)list.get(list.size() - 1)).getPosition().getEndOffset();
                return new OffsetRange(n, n2);
            }
            ISourcePosition iSourcePosition = node.getPosition();
            return new OffsetRange(iSourcePosition.getStartOffset(), iSourcePosition.getEndOffset());
        }
        if (node.nodeId == NodeType.NILNODE) {
            return OffsetRange.NONE;
        }
        ISourcePosition iSourcePosition = node.getPosition();
        try {
            return new OffsetRange(iSourcePosition.getStartOffset(), iSourcePosition.getEndOffset());
        }
        catch (Throwable throwable) {
            Exceptions.printStackTrace((Throwable)throwable);
            return OffsetRange.NONE;
        }
    }

    public static OffsetRange getLValueRange(AssignableNode assignableNode) {
        if (assignableNode instanceof MultipleAsgnNode) {
            MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)assignableNode;
            if (multipleAsgnNode.getHeadNode() != null) {
                return AstUtilities.getNameRange((Node)multipleAsgnNode.getHeadNode());
            }
            return AstUtilities.getRange((Node)assignableNode);
        }
        assert (assignableNode instanceof INameNode) : assignableNode;
        ISourcePosition iSourcePosition = assignableNode.getPosition();
        OffsetRange offsetRange = new OffsetRange(iSourcePosition.getStartOffset(), iSourcePosition.getStartOffset() + ((INameNode)assignableNode).getName().length());
        return offsetRange;
    }

    public static OffsetRange getNameRange(Node node) {
        if (node instanceof AssignableNode) {
            return AstUtilities.getLValueRange((AssignableNode)node);
        }
        if (node instanceof MethodDefNode) {
            return AstUtilities.getFunctionNameRange(node);
        }
        if (AstUtilities.isCall(node)) {
            return AstUtilities.getCallRange(node);
        }
        if (node instanceof ClassNode) {
            Colon3Node colon3Node = ((ClassNode)node).getCPath();
            if (colon3Node != null) {
                return AstUtilities.getRange((Node)colon3Node);
            }
            return AstUtilities.getRange(node);
        }
        if (node instanceof ModuleNode) {
            Colon3Node colon3Node = ((ModuleNode)node).getCPath();
            if (colon3Node != null) {
                return AstUtilities.getRange((Node)colon3Node);
            }
            return AstUtilities.getRange(node);
        }
        return AstUtilities.getRange(node);
    }

    public static OffsetRange getCallRange(Node node) {
        Node node2;
        ISourcePosition iSourcePosition = node.getPosition();
        int n = iSourcePosition.getStartOffset();
        int n2 = iSourcePosition.getEndOffset();
        assert (AstUtilities.isCall(node));
        assert (node instanceof INameNode);
        if (node instanceof CallNode && (node2 = ((CallNode)node).getReceiverNode()) != null) {
            n = node2.getPosition().getEndOffset() + 1;
        }
        if (node instanceof INameNode) {
            n2 = n + ((INameNode)node).getName().length();
        }
        return new OffsetRange(n, n2);
    }

    public static OffsetRange getFunctionNameRange(Node node) {
        for (Node node2 : node.childNodes()) {
            if (!(node2 instanceof ArgumentNode)) continue;
            OffsetRange offsetRange = AstUtilities.getRange(node2);
            return offsetRange;
        }
        if (node instanceof MethodDefNode) {
            for (Node node2 : node.childNodes()) {
                if (!(node2 instanceof ConstNode)) continue;
                ISourcePosition iSourcePosition = node2.getPosition();
                int n = iSourcePosition.getEndOffset();
                int n2 = n + 1;
                n = n + 1 + AstUtilities.getDefName(node).length();
                OffsetRange offsetRange = new OffsetRange(n2, n);
                return offsetRange;
            }
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange getAliasNewRange(AliasNode aliasNode) {
        ISourcePosition iSourcePosition = aliasNode.getPosition();
        int n = iSourcePosition.getStartOffset() + 6;
        return new OffsetRange(n, n + aliasNode.getNewName().length());
    }

    public static OffsetRange getAliasOldRange(AliasNode aliasNode) {
        ISourcePosition iSourcePosition = aliasNode.getPosition();
        int n = iSourcePosition.getStartOffset() + 6 + aliasNode.getNewName().length() + 1;
        return new OffsetRange(n, n + aliasNode.getOldName().length());
    }

    public static String getClassOrModuleName(IScopingNode iScopingNode) {
        return iScopingNode.getCPath().getName();
    }

    public static List<ClassNode> getClasses(Node node) {
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        AstUtilities.addClasses(node, arrayList);
        return arrayList;
    }

    private static void addClasses(Node node, List<ClassNode> list) {
        if (node instanceof ClassNode) {
            list.add((ClassNode)node);
        }
        List list2 = node.childNodes();
        for (Node node2 : list2) {
            if (node2.isInvisible()) continue;
            AstUtilities.addClasses(node2, list);
        }
    }

    private static void addAncestorParents(Node node, StringBuilder stringBuilder) {
        if (node instanceof Colon2Node) {
            Colon2Node colon2Node = (Colon2Node)node;
            AstUtilities.addAncestorParents(colon2Node.getLeftNode(), stringBuilder);
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != ':') {
                stringBuilder.append("::");
            }
            stringBuilder.append(colon2Node.getName());
        } else if (node instanceof INameNode) {
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != ':') {
                stringBuilder.append("::");
            }
            stringBuilder.append(((INameNode)node).getName());
        }
    }

    public static String getFqn(Colon2Node colon2Node) {
        StringBuilder stringBuilder = new StringBuilder();
        AstUtilities.addAncestorParents((Node)colon2Node, stringBuilder);
        return stringBuilder.toString();
    }

    public static String getSuperclass(ClassNode classNode) {
        StringBuilder stringBuilder = new StringBuilder();
        if (classNode.getSuperNode() != null) {
            AstUtilities.addAncestorParents(classNode.getSuperNode(), stringBuilder);
            return stringBuilder.toString();
        }
        return null;
    }

    public static String getFqnName(AstPath astPath) {
        StringBuilder stringBuilder = new StringBuilder();
        ListIterator<Node> listIterator = astPath.rootToLeaf();
        while (listIterator.hasNext()) {
            Colon3Node colon3Node;
            Node node = (Node)listIterator.next();
            if (!(node instanceof ModuleNode) && !(node instanceof ClassNode) || (colon3Node = ((IScopingNode)node).getCPath()) == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("::");
            }
            if (colon3Node instanceof Colon2Node) {
                stringBuilder.append(AstUtilities.getFqn((Colon2Node)colon3Node));
                continue;
            }
            stringBuilder.append(colon3Node.getName());
        }
        return stringBuilder.toString();
    }

    public static boolean isAttr(Node node) {
        if (!(node instanceof FCallNode)) {
            return false;
        }
        String string = ((INameNode)node).getName();
        return string.startsWith("attr") && ("attr".equals(string) || "attr_reader".equals(string) || "attr_accessor".equals(string) || "attr_writer".equals(string) || "attr_internal".equals(string) || "attr_internal_reader".equals(string) || "attr_internal_writer".equals(string) || "attr_internal_accessor".equals(string));
    }

    public static SymbolNode[] getAttrSymbols(Node node) {
        assert (AstUtilities.isAttr(node));
        List list = node.childNodes();
        for (Node node2 : list) {
            if (!(node2 instanceof ListNode)) continue;
            List list2 = node2.childNodes();
            ArrayList<SymbolNode> arrayList = new ArrayList<SymbolNode>(list2.size());
            for (Node node3 : list2) {
                if (!(node3 instanceof SymbolNode)) continue;
                arrayList.add((SymbolNode)node3);
            }
            return arrayList.toArray(new SymbolNode[arrayList.size()]);
        }
        return new SymbolNode[0];
    }

    public static RubyParseResult getParseResult(CompilationInfo compilationInfo) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-ruby", 0);
        if (parserResult == null) {
            return null;
        }
        return (RubyParseResult)parserResult;
    }

    public static Node getRoot(CompilationInfo compilationInfo) {
        return AstUtilities.getRoot(compilationInfo, "text/x-ruby");
    }

    public static Node getRoot(CompilationInfo compilationInfo, String string) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult(string, 0);
        if (parserResult == null) {
            return null;
        }
        return AstUtilities.getRoot(parserResult);
    }

    public static Node getRoot(ParserResult parserResult) {
        assert (parserResult instanceof RubyParseResult);
        RubyParseResult rubyParseResult = (RubyParseResult)parserResult;
        return rubyParseResult.getRootNode();
    }

    public static void findPrivateMethods(Node node, Set<Node> set, Set<Node> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<Node> hashSet4 = new HashSet<Node>();
        List list = node.childNodes();
        Modifier modifier = Modifier.PUBLIC;
        for (Node object : list) {
            if (object.isInvisible()) continue;
            modifier = AstUtilities.getMethodAccess(object, modifier, hashSet, hashSet2, hashSet3, hashSet4, set, set2);
        }
        hashSet3.removeAll(hashSet);
        hashSet2.removeAll(hashSet);
        for (String string : hashSet3) {
            for (Node node2 : hashSet4) {
                if (!string.equals(AstUtilities.getDefName(node2))) continue;
                set2.add(node2);
            }
        }
        for (String string : hashSet2) {
            for (Node node2 : hashSet4) {
                if (!string.equals(AstUtilities.getDefName(node2))) continue;
                set.add(node2);
            }
        }
    }

    private static Modifier getMethodAccess(Node node, Modifier modifier, Set<String> set, Set<String> set2, Set<String> set3, Set<Node> set4, Set<Node> set5, Set<Node> set6) {
        if (node instanceof MethodDefNode) {
            if (modifier == Modifier.PRIVATE) {
                set6.add(node);
            } else if (modifier == Modifier.PUBLIC) {
                set4.add(node);
            } else if (modifier == Modifier.PROTECTED) {
                set5.add(node);
            }
            return modifier;
        }
        if (node instanceof VCallNode || node instanceof FCallNode) {
            String string = ((INameNode)node).getName();
            if ("private".equals(string)) {
                if (Arity.callHasArguments(node)) {
                    List list = node.childNodes();
                    for (Node node2 : list) {
                        if (!(node2 instanceof ListNode)) continue;
                        List list2 = node2.childNodes();
                        for (Node node3 : list2) {
                            if (!(node3 instanceof SymbolNode)) continue;
                            String string2 = ((SymbolNode)node3).getName();
                            set3.add(string2);
                        }
                    }
                } else {
                    modifier = Modifier.PRIVATE;
                }
                return modifier;
            }
            if ("protected".equals(string)) {
                if (Arity.callHasArguments(node)) {
                    List list = node.childNodes();
                    for (Node node4 : list) {
                        if (!(node4 instanceof ListNode)) continue;
                        List list3 = node4.childNodes();
                        for (Node node5 : list3) {
                            if (!(node5 instanceof SymbolNode)) continue;
                            String string3 = ((SymbolNode)node5).getName();
                            set2.add(string3);
                        }
                    }
                } else {
                    modifier = Modifier.PROTECTED;
                }
                return modifier;
            }
            if ("public".equals(string)) {
                if (!Arity.callHasArguments(node)) {
                    modifier = Modifier.PUBLIC;
                    return modifier;
                }
                List list = node.childNodes();
                for (Node node6 : list) {
                    if (!(node6 instanceof ListNode)) continue;
                    List list4 = node6.childNodes();
                    for (Node node7 : list4) {
                        if (!(node7 instanceof SymbolNode)) continue;
                        String string4 = ((SymbolNode)node7).getName();
                        set.add(string4);
                    }
                }
            }
            return modifier;
        }
        if (node instanceof ClassNode || node instanceof ModuleNode) {
            return modifier;
        }
        List list = node.childNodes();
        for (Node node8 : list) {
            if (node8.isInvisible()) continue;
            modifier = AstUtilities.getMethodAccess(node8, modifier, set, set2, set3, set4, set5, set6);
        }
        return modifier;
    }

    public static String getMethodName(FileObject fileObject, final int n) {
        SourceModel sourceModel = SourceModelFactory.getInstance().getModel(fileObject);
        if (sourceModel == null) {
            return null;
        }
        if (sourceModel.isScanInProgress()) {
            return null;
        }
        final String[] stringArray = new String[1];
        try {
            sourceModel.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                public void cancel() {
                }

                public void run(CompilationInfo compilationInfo) {
                    BaseDocument baseDocument;
                    Node node = AstUtilities.getRoot(compilationInfo);
                    if (node == null) {
                        return;
                    }
                    int n3 = AstUtilities.getAstOffset(compilationInfo, n);
                    if (n3 == -1) {
                        return;
                    }
                    MethodDefNode methodDefNode = AstUtilities.findMethodAtOffset(node, n3);
                    if (methodDefNode == null && (baseDocument = (BaseDocument)compilationInfo.getDocument()) != null) {
                        try {
                            int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                            if (n2 != n) {
                                n3 = AstUtilities.getAstOffset(compilationInfo, n2);
                                if (n3 == -1) {
                                    return;
                                }
                                methodDefNode = AstUtilities.findMethodAtOffset(node, n3);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                    if (methodDefNode != null) {
                        stringArray[0] = methodDefNode.getName();
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }

    public static String getTestName(FileObject fileObject, final int n) {
        SourceModel sourceModel = SourceModelFactory.getInstance().getModel(fileObject);
        if (sourceModel == null) {
            return null;
        }
        if (sourceModel.isScanInProgress()) {
            return null;
        }
        final String[] stringArray = new String[1];
        try {
            sourceModel.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                public void cancel() {
                }

                public void run(CompilationInfo compilationInfo) {
                    try {
                        int n5;
                        int n2;
                        Node node = AstUtilities.getRoot(compilationInfo);
                        if (node == null) {
                            return;
                        }
                        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
                        int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)(n2 = n));
                        if (n3 != -1 && n2 <= n3) {
                            n2 = n3 + 1;
                        }
                        if ((n5 = AstUtilities.getAstOffset(compilationInfo, n2)) == -1) {
                            return;
                        }
                        AstPath astPath = new AstPath(node, n5);
                        ListIterator<Node> listIterator = astPath.leafToRoot();
                        while (listIterator.hasNext()) {
                            Node node2 = (Node)listIterator.next();
                            if (node2.nodeId == NodeType.FCALLNODE) {
                                Node node3;
                                FCallNode fCallNode = (FCallNode)node2;
                                if (!"test".equals(fCallNode.getName()) || fCallNode.getIterNode() == null || !((node3 = fCallNode.getArgsNode()) instanceof ListNode)) continue;
                                ListNode listNode = (ListNode)node3;
                                String string = null;
                                int n4 = listNode.size();
                                for (int i = 0; i < n4; ++i) {
                                    Node node4 = listNode.get(i);
                                    if (!(node4 instanceof StrNode)) continue;
                                    ByteList byteList = ((StrNode)node4).getValue();
                                    if (byteList == null || byteList.length() <= 0) break;
                                    string = byteList.toString();
                                    break;
                                }
                                stringArray[0] = "test_" + string.replace(' ', '_');
                                return;
                            }
                            if (node2.nodeId != NodeType.DEFNNODE && node2.nodeId != NodeType.DEFSNODE) continue;
                            stringArray[0] = ((MethodDefNode)node2).getName();
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }

    public static int findOffset(FileObject fileObject, final String string) {
        SourceModel sourceModel = SourceModelFactory.getInstance().getModel(fileObject);
        if (sourceModel == null) {
            return -1;
        }
        if (sourceModel.isScanInProgress()) {
            return -1;
        }
        final int[] nArray = new int[]{-1};
        try {
            sourceModel.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                public void cancel() {
                }

                public void run(CompilationInfo compilationInfo) {
                    Node node = AstUtilities.getRoot(compilationInfo);
                    if (node == null) {
                        return;
                    }
                    MethodDefNode methodDefNode = AstUtilities.findMethod(node, string, Arity.UNKNOWN);
                    if (methodDefNode != null) {
                        int n;
                        nArray[0] = n = methodDefNode.getPosition().getStartOffset();
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return nArray[0];
    }

    public static void addNodesByType(Node node, NodeType[] nodeTypeArray, List<Node> list) {
        for (int i = 0; i < nodeTypeArray.length; ++i) {
            if (node.nodeId != nodeTypeArray[i]) continue;
            list.add(node);
            break;
        }
        List list2 = node.childNodes();
        for (Node node2 : list2) {
            if (node2.isInvisible()) continue;
            AstUtilities.addNodesByType(node2, nodeTypeArray, list);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Node> getApplicableBlocks(AstPath astPath, boolean bl) {
        Node node = AstUtilities.findBlock(astPath);
        if (node == null && (node = astPath.leafParent()) == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ListIterator<Node> listIterator = astPath.leafToRoot();
        if (bl && listIterator.hasNext()) {
            listIterator.next();
        }
        Node node2 = astPath.root();
        block4: while (listIterator.hasNext()) {
            Node node3 = (Node)listIterator.next();
            switch (node3.nodeId) {
                case ITERNODE: {
                    node2 = node3;
                    arrayList.add(node3);
                    break;
                }
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    node2 = node3;
                    break block4;
                }
            }
        }
        if (bl) {
            AstUtilities.addNodesByType(node2, new NodeType[]{NodeType.ITERNODE}, arrayList);
        }
        return arrayList;
    }

    public static String guessName(CompilationInfo compilationInfo, OffsetRange offsetRange, OffsetRange offsetRange2) {
        String string = "";
        IndexedMethod[] indexedMethodArray = new IndexedMethod[1];
        Set[] setArray = new Set[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!RubyCodeCompleter.computeMethodCall(compilationInfo, offsetRange.getStart(), offsetRange2.getStart(), indexedMethodArray, nArray, nArray2, setArray)) {
            return string;
        }
        IndexedMethod indexedMethod = indexedMethodArray[0];
        int n = nArray[0];
        List<String> list = indexedMethod.getParameters();
        if (list == null || list.size() <= n) {
            return string;
        }
        return list.get(n);
    }

    public static Set<String> getUsedFields(RubyIndex rubyIndex, AstPath astPath) {
        String string = AstUtilities.getFqnName(astPath);
        if (string == null || string.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedField> set = rubyIndex.getInheritedFields(string, "", NameKind.PREFIX, false);
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexedField indexedField : set) {
            hashSet.add(indexedField.getName());
        }
        return hashSet;
    }

    public static Set<String> getUsedMethods(RubyIndex rubyIndex, AstPath astPath) {
        String string = AstUtilities.getFqnName(astPath);
        if (string == null || string.length() == 0) {
            return Collections.emptySet();
        }
        Set<IndexedMethod> set = rubyIndex.getInheritedMethods(string, "", NameKind.PREFIX);
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexedMethod indexedMethod : set) {
            hashSet.add(indexedMethod.getName());
        }
        return hashSet;
    }

    public static Set<String> getUsedConstants(RubyIndex rubyIndex, AstPath astPath) {
        return Collections.emptySet();
    }

    public static Set<String> getUsedLocalNames(AstPath astPath, Node node) {
        Node node2 = AstUtilities.findLocalScope(node, astPath);
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        RubyCodeCompleter.addLocals(node2, hashMap);
        List<Node> list = AstUtilities.getApplicableBlocks(astPath, false);
        for (Node node3 : list) {
            RubyCodeCompleter.addDynamic(node3, hashMap);
        }
        return hashMap.keySet();
    }
}

