/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class NbUtilities {
    private NbUtilities() {
    }

    public static JTextComponent getOpenPane() {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        return jTextComponent;
    }

    public static JTextComponent getPaneFor(FileObject fileObject) {
        JTextComponent jTextComponent = NbUtilities.getOpenPane();
        if (jTextComponent != null && NbUtilities.findFileObject(jTextComponent) == fileObject) {
            return jTextComponent;
        }
        for (JTextComponent jTextComponent2 : EditorRegistry.componentList()) {
            if (NbUtilities.findFileObject(jTextComponent2) != fileObject) continue;
            return jTextComponent2;
        }
        return null;
    }

    public static BaseDocument getDocument(FileObject fileObject, boolean bl) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie != null) {
                return (BaseDocument)(bl ? editorCookie.openDocument() : editorCookie.getDocument());
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public static FileObject findFileObject(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    public static FileObject findFileObject(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        return NbUtilities.findFileObject(document);
    }

    public static boolean open(final FileObject fileObject, final int n, final String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NbUtilities.doOpen(fileObject, n, string);
                }
            });
            return true;
        }
        return NbUtilities.doOpen(fileObject, n, string);
    }

    private static boolean doOpen(FileObject fileObject, int n, String string) {
        try {
            int n2;
            Object object;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (n == -1 && editorCookie.getDocument() != null && string == null) {
                editorCookie.open();
                return true;
            }
            if (editorCookie != null && string != null && n == -1) {
                object = editorCookie.openDocument();
                try {
                    String string2 = object.getText(0, object.getLength());
                    n2 = string.indexOf(94);
                    if (n2 != -1) {
                        string = string.substring(0, n2) + string.substring(n2 + 1);
                    } else {
                        n2 = 0;
                    }
                    n = string2.indexOf(string);
                    if (n != -1) {
                        n += n2;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null) {
                Line line;
                int n3 = NbDocument.findLineNumber((StyledDocument)object, (int)n);
                n2 = NbDocument.findLineOffset((StyledDocument)object, (int)n3);
                int n4 = n - n2;
                if (n3 != -1 && (line = lineCookie.getLineSet().getCurrent(n3)) != null) {
                    line.show(2, n4);
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return false;
    }

    public static void extractZip(FileObject fileObject, FileObject fileObject2) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        NbUtilities.extractZip(fileObject2, new BufferedInputStream(new FileInputStream(file)));
    }

    private static void extractZip(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                NbUtilities.extractZipImpl(fileObject, inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (string.toLowerCase().startsWith("meta-inf/")) continue;
            if (zipEntry.isDirectory()) {
                FileUtil.createFolder((FileObject)fileObject, (String)string);
                continue;
            }
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
            FileLock fileLock = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                try {
                    FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    public static boolean isCodeTemplateEditing(Document document) {
        String string = "processing-code-template";
        String string2 = "code-template-insert-handler";
        return document.getProperty(string) == Boolean.TRUE || document.getProperty(string2) != null;
    }

    public static BaseDocument getBaseDocument(FileObject fileObject, boolean bl) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                throw new IOException("Can't open " + fileObject.getNameExt());
            }
            StyledDocument styledDocument = bl ? editorCookie.openDocument() : editorCookie.getDocument();
            if (styledDocument instanceof BaseDocument) {
                return (BaseDocument)styledDocument;
            }
            try {
                Class<?> clazz = Class.forName("org.netbeans.modules.ruby.RubyTestBase");
                if (clazz != null) {
                    Method method = clazz.getMethod("getDocumentFor", FileObject.class);
                    return (BaseDocument)method.invoke(null, (Object[])new FileObject[]{fileObject});
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

