/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.ruby.RubyIndexer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyIndex {
    private static final Logger LOGGER = Logger.getLogger(RubyIndex.class.getName());
    public static final String UNKNOWN_CLASS = "<Unknown>";
    public static final String OBJECT = "Object";
    private static final String CLASS = "Class";
    private static final String MODULE = "Module";
    static final Set<Index.SearchScope> ALL_SCOPE = EnumSet.allOf(Index.SearchScope.class);
    static final Set<Index.SearchScope> SOURCE_SCOPE = EnumSet.of(Index.SearchScope.SOURCE);
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";
    private static final String RUBYHOME_URL = "ruby:";
    private static final String GEM_URL = "gem:";
    private final Index index;

    public RubyIndex(Index index) {
        this.index = index;
    }

    public static RubyIndex get(Index index) {
        return new RubyIndex(index);
    }

    private boolean search(String string, String string2, NameKind nameKind, Set<Index.SearchResult> set) {
        try {
            this.index.search(string, string2, nameKind, ALL_SCOPE, set, null);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private boolean search(String string, String string2, NameKind nameKind, Set<Index.SearchResult> set, Set<Index.SearchScope> set2) {
        try {
            this.index.search(string, string2, nameKind, set2, set, null);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    Set<IndexedClass> getClasses(String string, NameKind nameKind, boolean bl, boolean bl2, boolean bl3) {
        return this.getClasses(string, nameKind, bl, bl2, bl3, ALL_SCOPE, null);
    }

    public Set<IndexedClass> getClasses(String string, NameKind nameKind, boolean bl, boolean bl2, boolean bl3, Set<Index.SearchScope> set, Set<String> set2) {
        String string2;
        String string3 = null;
        if (string != null) {
            if (string.indexOf("::") != -1) {
                int n = string.lastIndexOf("::");
                string3 = string.substring(0, n);
                string = string.substring(n + 2);
            } else if (string.endsWith(":")) {
                string3 = string.substring(0, string.length() - 1);
                string = "";
            }
        }
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        switch (nameKind) {
            case EXACT_NAME: 
            case PREFIX: 
            case CAMEL_CASE: 
            case REGEXP: {
                string2 = "class";
                break;
            }
            case CASE_INSENSITIVE_PREFIX: 
            case CASE_INSENSITIVE_REGEXP: {
                string2 = "class-ig";
                break;
            }
            default: {
                throw new UnsupportedOperationException(nameKind.toString());
            }
        }
        this.search(string2, string, nameKind, hashSet, set);
        if (bl) {
            set2 = null;
        } else if (set2 == null) {
            set2 = new HashSet<String>();
        }
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (Index.SearchResult searchResult : hashSet) {
            int n;
            int n2;
            String string4;
            String string5 = searchResult.getValue("class");
            if (string5 == null || nameKind == NameKind.PREFIX && !string5.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string5.regionMatches(true, 0, string, 0, string.length())) continue;
            if (string3 != null) {
                if (nameKind == NameKind.CASE_INSENSITIVE_PREFIX || nameKind == NameKind.CASE_INSENSITIVE_REGEXP) {
                    if (!string3.equalsIgnoreCase(searchResult.getValue("in"))) {
                        continue;
                    }
                } else if (nameKind == NameKind.CAMEL_CASE) {
                    string4 = searchResult.getValue("in");
                    if (string4 == null) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    n2 = 0;
                    do {
                        int n3 = -1;
                        for (int i = n2 + 1; i < string3.length(); ++i) {
                            if (!Character.isUpperCase(string3.charAt(i))) continue;
                            n3 = i;
                            break;
                        }
                        String string6 = string3.substring(n2, (n = n3) == -1 ? string3.length() : n);
                        stringBuilder.append(string6);
                        stringBuilder.append(n != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                        n2 = n;
                    } while (n != -1);
                    Pattern pattern = Pattern.compile(stringBuilder.toString());
                    if (!pattern.matcher(string4).matches()) {
                        continue;
                    }
                } else if (!string3.equals(searchResult.getValue("in"))) continue;
            }
            string4 = searchResult.getValue("attrs");
            boolean bl4 = true;
            if (string4 != null) {
                n2 = IndexedElement.stringToFlag(string4, 0);
                boolean bl5 = bl4 = (n2 & 0x40) == 0;
            }
            if (bl2 && bl4 || bl3 && !bl4) continue;
            String string7 = searchResult.getValue("fqn");
            if (!bl) {
                if (set2.contains(string7)) {
                    boolean bl6;
                    n = 0;
                    int n4 = 0;
                    if (string4 != null) {
                        n4 = IndexedElement.stringToFlag(string4, 0);
                    }
                    boolean bl7 = bl6 = n4 & true;
                    if (bl6) {
                        int n5 = 0;
                        int n6 = string4.indexOf(59);
                        if (n6 != -1) {
                            int n7 = string4.indexOf(59, n6 + 1);
                            if (n7 == -1) {
                                n7 = string4.length();
                            }
                            n5 = Integer.parseInt(string4.substring(n6 + 1, n7));
                        }
                        for (IndexedClass indexedClass : hashSet2) {
                            if (!indexedClass.getSignature().equals(string7) || n5 <= indexedClass.getDocumentationLength()) continue;
                            hashSet2.remove(indexedClass);
                            n = 1;
                            break;
                        }
                    }
                    if (n == 0) {
                        continue;
                    }
                } else {
                    set2.add(string7);
                }
            }
            hashSet2.add(this.createClass(string7, string5, searchResult));
        }
        return hashSet2;
    }

    public Set<IndexedClass> getSubClasses(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string3 = "extends";
        this.search(string3, string2, NameKind.EXACT_NAME, hashSet, set);
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (Index.SearchResult searchResult : hashSet) {
            String string4 = searchResult.getValue("class");
            if (string4 == null || nameKind == NameKind.PREFIX && !string4.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string4.regionMatches(true, 0, string, 0, string.length())) continue;
            String string5 = searchResult.getValue("fqn");
            hashSet2.add(this.createClass(string5, string4, searchResult));
        }
        return hashSet2;
    }

    Set<IndexedMethod> getMethods(String string, String string2, NameKind nameKind) {
        return this.getMethods(string, string2, nameKind, ALL_SCOPE);
    }

    public Set<IndexedMethod> getMethods(String string, String string2, NameKind nameKind, Set<Index.SearchScope> set) {
        boolean bl = string2 == null;
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string3 = "method";
        NameKind nameKind2 = nameKind;
        if (nameKind == NameKind.EXACT_NAME) {
            nameKind = NameKind.PREFIX;
        }
        this.search(string3, string, nameKind, hashSet, set);
        HashSet<IndexedMethod> hashSet2 = new HashSet<IndexedMethod>();
        for (Index.SearchResult searchResult : hashSet) {
            int n;
            String[] stringArray;
            String[] stringArray2;
            if (string2 != null && !string2.equals(stringArray2 = searchResult.getValue("fqn"))) continue;
            stringArray2 = searchResult.getValues("method");
            if (stringArray2 != null) {
                stringArray = stringArray2;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String string4;
                    block12: {
                        string4 = stringArray[n];
                        if ((string == null || string.length() == 0) && !Character.isLowerCase(string4.charAt(0)) || nameKind == NameKind.PREFIX && !string4.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string4.regionMatches(true, 0, string, 0, string.length())) continue;
                        if (nameKind == NameKind.CASE_INSENSITIVE_REGEXP) {
                            int n3 = string4.length();
                            int n4 = string4.indexOf(40);
                            if (n4 == -1 && (n4 = string4.indexOf(59)) == -1) {
                                n4 = n3;
                            }
                            String string5 = n4 != n3 ? string4.substring(0, n4) : string4;
                            try {
                                if (!string5.matches(string)) {
                                    continue;
                                }
                                break block12;
                            }
                            catch (Exception exception) {
                                break block12;
                            }
                        }
                        if (nameKind2 == NameKind.EXACT_NAME && string4.length() > string.length() && string4.charAt(string.length()) != '(' && string4.charAt(string.length()) != ';') continue;
                    }
                    assert (searchResult != null);
                    hashSet2.add(this.createMethod(string4, searchResult, bl));
                }
            }
            if ((stringArray = searchResult.getValues("attribute")) == null) continue;
            String[] stringArray3 = stringArray;
            n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string6 = stringArray3[i];
                if ((string == null || string.length() == 0) && !Character.isLowerCase(string6.charAt(0)) || nameKind == NameKind.PREFIX && !string6.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string6.regionMatches(true, 0, string, 0, string.length()) || nameKind == NameKind.CASE_INSENSITIVE_REGEXP && !string6.matches(string) || nameKind2 == NameKind.EXACT_NAME && string6.length() > string.length() && string6.charAt(string.length()) != ';') continue;
                assert (searchResult != null);
                hashSet2.add(this.createMethod(string6, searchResult, bl));
            }
        }
        return hashSet2;
    }

    private IndexedMethod createMethod(String string, Index.SearchResult searchResult, boolean bl) {
        String string2 = searchResult.getValue("class");
        String string3 = searchResult.getValue("in");
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3 + "::" + string2;
        }
        String string4 = searchResult.getPersistentUrl();
        String string5 = searchResult.getValue("fqn");
        String string6 = searchResult.getValue("require");
        int n = string.indexOf(59);
        String string7 = null;
        int n2 = 0;
        if (n != -1) {
            n2 = IndexedElement.stringToFlag(string, n + 1);
            if (string.length() > n + 1) {
                string7 = string.substring(n + 1, string.length());
            }
            string = string.substring(0, n);
        }
        IndexedMethod indexedMethod = IndexedMethod.create(this, string, string5, string2, string4, string6, string7, n2);
        indexedMethod.setInherited(bl);
        return indexedMethod;
    }

    private IndexedField createField(String string, Index.SearchResult searchResult, boolean bl, boolean bl2) {
        String string2 = searchResult.getValue("class");
        String string3 = searchResult.getValue("in");
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3 + "::" + string2;
        }
        String string4 = searchResult.getPersistentUrl();
        String string5 = searchResult.getValue("fqn");
        String string6 = searchResult.getValue("require");
        int n = string.indexOf(59);
        String string7 = null;
        int n2 = 0;
        if (n != -1) {
            n2 = IndexedElement.stringToFlag(string, n + 1);
            if (string.length() > n + 1) {
                string7 = string.substring(n + 1, string.length());
            }
            string = string.substring(0, n);
        }
        IndexedField indexedField = IndexedField.create(this, string, string5, string2, string4, string6, string7, n2);
        indexedField.setInherited(bl2);
        return indexedField;
    }

    private IndexedClass createClass(String string, String string2, Index.SearchResult searchResult) {
        String string3 = searchResult.getValue("require");
        String string4 = searchResult.getPersistentUrl();
        if (string2 == null) {
            string2 = searchResult.getValue("class");
        }
        String string5 = searchResult.getValue("attrs");
        int n = 0;
        if (string5 != null) {
            n = IndexedElement.stringToFlag(string5, 0);
        }
        IndexedClass indexedClass = IndexedClass.create(this, string2, string, string4, string3, string5, n);
        return indexedClass;
    }

    public Set<String[]> getRequires(String string, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string2 = "require";
        this.search(string2, string, nameKind, hashSet);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Index.SearchResult object : hashSet) {
            Object object2 = object.getValues(string2);
            if (object2 == null) continue;
            for (String string3 : object2) {
                if (nameKind == NameKind.PREFIX && !string3.startsWith(string) || nameKind == NameKind.CASE_INSENSITIVE_PREFIX && !string3.regionMatches(true, 0, string, 0, string.length())) continue;
                assert (object != null);
                String string4 = object.getValue("fqn");
                String string5 = (String)hashMap.get(string3);
                if (string4 == null || string5 != null && (string5 == null || string5.length() >= string4.length())) continue;
                hashMap.put(string3, string4);
            }
        }
        HashSet hashSet2 = new HashSet();
        for (Object object2 : hashMap.keySet()) {
            String string6 = (String)hashMap.get(object2);
            String[] stringArray = new String[]{object2, string6};
            hashSet2.add(stringArray);
        }
        return hashSet2;
    }

    public Set<String> getRequiresTransitively(Set<String> set) {
        return set;
    }

    public Set<String> getClassesIn(String string) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string2 = "require";
        this.search(string2, string, NameKind.EXACT_NAME, hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Index.SearchResult searchResult : hashSet) {
            String string3 = searchResult.getValue("fqn");
            if (string3 == null) continue;
            hashSet2.add(string3);
        }
        return hashSet2;
    }

    public IndexedClass getSuperclass(String string) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        NameKind nameKind = NameKind.EXACT_NAME;
        String string2 = "fqn";
        this.search(string2, string, nameKind, hashSet);
        for (Index.SearchResult searchResult : hashSet) {
            assert (string.equals(searchResult.getValue("fqn")));
            String string3 = searchResult.getValue("extends");
            if (string3 == null) continue;
            hashSet.clear();
            if (!this.search(string2, string3, nameKind, hashSet)) {
                return null;
            }
            if (hashSet.size() > 0) {
                Index.SearchResult searchResult2 = (Index.SearchResult)hashSet.iterator().next();
                String string4 = searchResult2.getValue("fqn");
                return this.createClass(string4, string3, searchResult2);
            }
            return null;
        }
        return null;
    }

    private boolean addSubclasses(String string, Set<IndexedClass> set, Set<String> set2, Set<String> set3, boolean bl) {
        boolean bl2;
        if (set3.contains(string)) {
            return false;
        }
        set3.add(string);
        String string2 = "extends";
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search(string2, string, NameKind.EXACT_NAME, hashSet);
        boolean bl3 = bl2 = hashSet.size() > 0;
        if (!bl2) {
            return bl2;
        }
        for (Index.SearchResult searchResult : hashSet) {
            String string3 = searchResult.getValue("fqn");
            if (set2.contains(string3)) continue;
            IndexedClass indexedClass = this.createClass(string3, null, searchResult);
            set.add(indexedClass);
            set2.add(string3);
            if (bl) continue;
            this.addSubclasses(string3, set, set2, set3, bl);
        }
        return bl2;
    }

    public Set<IndexedClass> getSubClasses(String string, String string2, String string3, boolean bl) {
        HashSet<IndexedClass> hashSet = new HashSet<IndexedClass>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        if (string != null) {
            this.addSubclasses(string, hashSet, hashSet3, hashSet2, bl);
        } else {
            string = string2;
            while (hashSet.size() == 0 && string.length() > 0) {
                boolean bl2 = this.addSubclasses(string + "::" + string3, hashSet, hashSet3, hashSet2, bl);
                if (bl2) {
                    return hashSet;
                }
                int n = string.lastIndexOf("::");
                if (n == -1) break;
                string = string.substring(0, n);
            }
            if (hashSet.size() == 0) {
                this.addSubclasses(string3, hashSet, hashSet3, hashSet2, bl);
            }
        }
        return hashSet;
    }

    public IndexedMethod getOverridingMethod(String string, String string2) {
        Set<IndexedMethod> set = this.getInheritedMethods(string, string2, NameKind.EXACT_NAME);
        for (IndexedMethod indexedMethod : set) {
            if (indexedMethod.getIn().equals(string)) continue;
            return indexedMethod;
        }
        return null;
    }

    public Set<IndexedMethod> getInheritedMethods(String string, String string2, NameKind nameKind) {
        boolean bl = false;
        if (string == null || string.equals(OBJECT)) {
            string = CLASS;
            bl = true;
        } else if (MODULE.equals(string) || CLASS.equals(string)) {
            bl = true;
        }
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        if (string2 == null) {
            string2 = "";
        }
        this.addMethodsFromClass(string2, nameKind, string, hashSet, hashSet3, hashSet2, bl, false);
        return hashSet;
    }

    private boolean addMethodsFromClass(String string, NameKind nameKind, String string2, Set<IndexedMethod> set, Set<String> set2, Set<String> set3, boolean bl, boolean bl2) {
        boolean bl3;
        if (set3.contains(string2)) {
            return false;
        }
        set3.add(string2);
        String string3 = "fqn";
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search(string3, string2, NameKind.EXACT_NAME, hashSet);
        boolean bl4 = bl3 = hashSet.size() > 0;
        if (!bl3) {
            return bl3;
        }
        String string4 = null;
        String string5 = null;
        int n = string2.lastIndexOf("::");
        if (n != -1) {
            string5 = string2.substring(0, n);
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            String[] stringArray;
            int n2;
            Object object2;
            Object object3;
            String string6;
            Index.SearchResult searchResult = (Index.SearchResult)object.next();
            assert (searchResult != null);
            if (string4 == null) {
                string4 = searchResult.getValue("extends");
            }
            if ((string6 = searchResult.getValue("includes")) != null) {
                object2 = object3 = string6.split(",");
                int n3 = ((String[])object2).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    String string7 = object2[n2];
                    boolean bl5 = false;
                    if (string5 != null) {
                        bl5 = this.addMethodsFromClass(string, nameKind, string5 + "::" + string7, set, set2, set3, bl, true);
                    }
                    if (bl5) continue;
                    this.addMethodsFromClass(string, nameKind, string7, set, set2, set3, bl, true);
                }
            }
            if ((object3 = searchResult.getValue("extendWith")) != null) {
                boolean bl6 = false;
                if (string5 != null) {
                    bl6 = this.addMethodsFromClass(string, nameKind, string5 + "::" + (String)object3, set, set2, set3, bl, true);
                }
                if (!bl6) {
                    this.addMethodsFromClass(string, nameKind, (String)object3, set, set2, set3, bl, true);
                }
            }
            if ((object2 = searchResult.getValues("method")) != null) {
                Object object4 = object2;
                n2 = ((String[])object4).length;
                for (int i = 0; i < n2; ++i) {
                    String string8 = object4[i];
                    if (string.length() == 0 && !Character.isLowerCase(string8.charAt(0)) || set2.contains(string8) || !string8.startsWith(string)) continue;
                    if (nameKind == NameKind.EXACT_NAME) {
                        if (string8.length() > string.length() && string8.charAt(string.length()) != '(' && string8.charAt(string.length()) != ';') {
                            continue;
                        }
                    } else assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX);
                    set2.add(string8);
                    IndexedMethod indexedMethod = this.createMethod(string8, searchResult, bl2);
                    indexedMethod.setSmart(!bl);
                    set.add(indexedMethod);
                }
            }
            if ((stringArray = searchResult.getValues("attribute")) == null) continue;
            for (String string7 : stringArray) {
                if (string.length() == 0 && !Character.isLowerCase(string7.charAt(0)) || set2.contains(string7) || !string7.startsWith(string)) continue;
                if (nameKind == NameKind.EXACT_NAME) {
                    if (string7.length() > string.length() && string7.charAt(string.length()) != '(' && string7.charAt(string.length()) != ';') {
                        continue;
                    }
                } else assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX);
                set2.add(string7);
                IndexedMethod indexedMethod = this.createMethod(string7, searchResult, bl2);
                indexedMethod.setSmart(!bl);
                indexedMethod.setMethodType(IndexedMethod.MethodType.ATTRIBUTE);
                set.add(indexedMethod);
            }
        }
        if (string2.equals(OBJECT)) {
            return bl3;
        }
        if (string4 == null) {
            if (bl) {
                this.addMethodsFromClass(string, nameKind, OBJECT, set, set2, set3, true, true);
            } else {
                this.addMethodsFromClass(string, nameKind, CLASS, set, set2, set3, true, true);
            }
        } else {
            if ("ActiveRecord::Base".equals(string4)) {
                this.addDatabaseProperties(string, nameKind, string2, set);
            }
            if (!this.addMethodsFromClass(string, nameKind, string4, set, set2, set3, bl, true)) {
                int n4;
                for (object = string5; object != null && !this.addMethodsFromClass(string, nameKind, (String)object + "::" + string4, set, set2, set3, bl, true) && (n4 = ((String)object).lastIndexOf("::")) != -1; object = ((String)object).substring(0, n4)) {
                }
            }
        }
        return bl3;
    }

    private void addDatabaseProperties(String string, NameKind nameKind, String string2, Set<IndexedMethod> set) {
        Object object;
        Object object2;
        Object object3;
        if (string2.indexOf("::") != -1) {
            return;
        }
        String string3 = RubyUtils.tableize(string2);
        String string4 = "dbtable";
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search(string4, string3, NameKind.EXACT_NAME, hashSet);
        ArrayList<TableDefinition> arrayList = new ArrayList<TableDefinition>();
        TableDefinition object5 = null;
        for (Index.SearchResult object6 : hashSet) {
            assert (object6 != null);
            object3 = object6.getValue("dbversion");
            assert (string3.equals(object6.getValue("dbtable")));
            object2 = object6.getPersistentUrl();
            TableDefinition tableDefinition = new TableDefinition(string3, (String)object3, (String)object2);
            arrayList.add(tableDefinition);
            object = object6.getValues("dbcolumn");
            if (object != null) {
                for (Object object4 : object) {
                    tableDefinition.addColumn((String)object4);
                }
            }
            if (!"schema".equals(object3)) continue;
            object5 = tableDefinition;
            break;
        }
        if (arrayList.size() > 0) {
            IndexedMethod indexedMethod;
            String string5;
            String string6;
            String string7;
            Object object6;
            Object object4;
            HashMap hashMap = new HashMap();
            HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
            object3 = new HashSet();
            if (object5 != null) {
                object2 = object5.getColumns();
                if (object2 != null) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        int n = ((String)object).indexOf(59);
                        if (n != -1) {
                            String string8 = ((String)object).substring(0, n);
                            if (n < ((String)object).length() - 1 && ((String)object).charAt(n + 1) == '-') {
                                object3.remove(object);
                                continue;
                            }
                            object3.add(string8);
                            hashMap2.put(object, object5.getFileUrl());
                            hashMap.put(string8, object);
                            continue;
                        }
                        object3.add(object);
                        hashMap.put(object, object);
                        hashMap2.put(object, object5.getFileUrl());
                    }
                }
            } else {
                Collections.sort(arrayList);
                for (TableDefinition tableDefinition : arrayList) {
                    object = tableDefinition.getColumns();
                    if (object == null) continue;
                    object6 = object.iterator();
                    while (object6.hasNext()) {
                        String string9 = (String)object6.next();
                        int n = string9.indexOf(59);
                        if (n != -1) {
                            object4 = string9.substring(0, n);
                            if (n < string9.length() - 1 && string9.charAt(n + 1) == '-') {
                                object3.remove(object4);
                                continue;
                            }
                            object3.add(object4);
                            hashMap2.put(string9, tableDefinition.getFileUrl());
                            hashMap.put(object4, string9);
                            continue;
                        }
                        object3.add(string9);
                        hashMap.put(string9, string9);
                        hashMap2.put(string9, tableDefinition.getFileUrl());
                    }
                }
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                String string10 = (String)object2.next();
                if (!string10.startsWith(string)) continue;
                if (nameKind == NameKind.EXACT_NAME) {
                    if (string10.length() > string.length()) {
                        continue;
                    }
                } else assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX);
                object = (String)hashMap.get(string10);
                object6 = string3;
                int n = ((String)object).indexOf(59);
                if (n != -1) {
                    object6 = ((String)object).substring(n + 1);
                }
                String string11 = (String)hashMap2.get(string10);
                object4 = string10;
                string7 = string3 + "#" + string10;
                Object object7 = object6;
                string6 = null;
                string5 = "";
                int n2 = 0;
                indexedMethod = IndexedMethod.create(this, (String)object4, string7, (String)object7, string11, string6, string5, n2);
                indexedMethod.setMethodType(IndexedMethod.MethodType.DBCOLUMN);
                indexedMethod.setSmart(true);
                set.add(indexedMethod);
            }
            if ("find_by_".startsWith(string) || "find_all_by".startsWith(string)) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    String string12;
                    String string13 = (String)object2.next();
                    object = "find_by_" + string13;
                    object6 = "find_all_by_" + string13;
                    if (!((String)object).startsWith(string) && !((String)object6).startsWith(string)) continue;
                    if (nameKind == NameKind.EXACT_NAME) {
                        if (string13.length() > string.length()) {
                            continue;
                        }
                    } else assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX);
                    String string14 = (String)hashMap.get(string13);
                    string14 = string14.substring(string14.indexOf(59) + 1);
                    String string15 = (String)hashMap2.get(string13);
                    object4 = string2;
                    string7 = null;
                    int n = 16;
                    string6 = IndexedElement.flagToString(n) + ";;;" + "options(:first|:all),args(=>conditions|order|group|limit|offset|joins|readonly:bool|include|select|from|readonly:bool|lock:bool)";
                    if (((String)object).startsWith(string)) {
                        string5 = (String)object + "(" + string13 + ",*options)";
                        string12 = string3 + "#" + string5;
                        indexedMethod = IndexedMethod.create(this, string5, string12, (String)object4, string15, string7, string6, n);
                        indexedMethod.setInherited(false);
                        indexedMethod.setSmart(true);
                        set.add(indexedMethod);
                    }
                    if (!((String)object6).startsWith(string)) continue;
                    string5 = (String)object6 + "(" + string13 + ",*options)";
                    string12 = string3 + "#" + string5;
                    indexedMethod = IndexedMethod.create(this, string5, string12, (String)object4, string15, string7, string6, n);
                    indexedMethod.setInherited(false);
                    indexedMethod.setSmart(true);
                    set.add(indexedMethod);
                }
            }
        }
    }

    public Set<String> getDatabaseTables(String string, NameKind nameKind) {
        String string2 = "dbtable";
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search(string2, string, nameKind, hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Index.SearchResult searchResult : hashSet) {
            assert (searchResult != null);
            String string3 = searchResult.getValue("dbtable");
            if (string3 == null) continue;
            hashSet2.add(string3);
        }
        return hashSet2;
    }

    public Set<IndexedField> getInheritedFields(String string, String string2, NameKind nameKind, boolean bl) {
        boolean bl2 = false;
        if (string == null || string.equals(OBJECT)) {
            string = CLASS;
            bl2 = true;
        } else if (MODULE.equals(string) || CLASS.equals(string)) {
            bl2 = true;
        }
        HashSet<IndexedField> hashSet = new HashSet<IndexedField>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        boolean bl3 = true;
        if (string2 == null) {
            string2 = "";
        } else if (string2.startsWith("@@")) {
            bl3 = false;
            string2 = string2.substring(2);
        } else if (string2.startsWith("@")) {
            string2 = string2.substring(1);
        }
        this.addFieldsFromClass(string2, nameKind, string, hashSet, hashSet3, hashSet2, bl2, bl3, bl);
        return hashSet;
    }

    private boolean addFieldsFromClass(String string, NameKind nameKind, String string2, Set<IndexedField> set, Set<String> set2, Set<String> set3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (set3.contains(string2)) {
            return false;
        }
        set3.add(string2);
        String string3 = "fqn";
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search(string3, string2, NameKind.EXACT_NAME, hashSet);
        boolean bl5 = bl4 = hashSet.size() > 0;
        if (!bl4) {
            return bl4;
        }
        String string4 = null;
        String string5 = null;
        int n = string2.lastIndexOf("::");
        if (n != -1) {
            string5 = string2.substring(0, n);
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            int n2;
            Object object2;
            Object object3;
            String string6;
            Index.SearchResult searchResult = (Index.SearchResult)object.next();
            assert (searchResult != null);
            if (string4 == null) {
                string4 = searchResult.getValue("extends");
            }
            if ((string6 = searchResult.getValue("includes")) != null) {
                object2 = object3 = string6.split(",");
                int n3 = ((String[])object2).length;
                for (n2 = 0; n2 < n3; ++n2) {
                    String string7 = object2[n2];
                    boolean bl6 = false;
                    if (string5 != null) {
                        bl6 = this.addFieldsFromClass(string, nameKind, string5 + "::" + string7, set, set2, set3, bl, bl2, true);
                    }
                    if (bl6) continue;
                    this.addFieldsFromClass(string, nameKind, string7, set, set2, set3, bl, bl2, true);
                }
            }
            if ((object3 = searchResult.getValue("extendWith")) != null) {
                boolean bl7 = false;
                if (string5 != null) {
                    bl7 = this.addFieldsFromClass(string, nameKind, string5 + "::" + (String)object3, set, set2, set3, bl, bl2, true);
                }
                if (!bl7) {
                    this.addFieldsFromClass(string, nameKind, (String)object3, set, set2, set3, bl, bl2, true);
                }
            }
            if ((object2 = searchResult.getValues("field")) == null) continue;
            Object object4 = object2;
            n2 = ((String[])object4).length;
            for (int i = 0; i < n2; ++i) {
                String string8 = object4[i];
                if (string.length() == 0 && !Character.isLowerCase(string8.charAt(0)) || set2.contains(string8)) continue;
                boolean bl8 = true;
                int n4 = string8.indexOf(59);
                if (n4 != -1 && string8.indexOf(115, n4 + 1) != -1) {
                    bl8 = false;
                }
                if (bl8 != bl2 || !string8.startsWith(string)) continue;
                if (nameKind == NameKind.EXACT_NAME) {
                    if (string8.length() > string.length() && string8.charAt(string.length()) != '(' && string8.charAt(string.length()) != ';') {
                        continue;
                    }
                } else assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX);
                set2.add(string8);
                IndexedField indexedField = this.createField(string8, searchResult, bl8, bl3);
                indexedField.setSmart(!bl);
                set.add(indexedField);
            }
        }
        if (string2.equals(OBJECT)) {
            return bl4;
        }
        if (string4 == null) {
            if (bl) {
                this.addFieldsFromClass(string, nameKind, OBJECT, set, set2, set3, true, bl2, true);
            } else {
                this.addFieldsFromClass(string, nameKind, CLASS, set, set2, set3, true, bl2, true);
            }
        } else if (!this.addFieldsFromClass(string, nameKind, string4, set, set2, set3, bl, bl2, true)) {
            int n5;
            for (object = string5; object != null && !this.addFieldsFromClass(string, nameKind, (String)object + "::" + string4, set, set2, set3, bl, bl2, true) && (n5 = ((String)object).lastIndexOf("::")) != -1; object = ((String)object).substring(0, n5)) {
            }
        }
        return bl4;
    }

    public Set<? extends IndexedElement> getDocumented(String string) {
        assert (string != null && string.length() > 0);
        int n = string.indexOf(35);
        if (n == -1) {
            return this.getDocumentedClasses(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return this.getDocumentedMethods(string2, string3);
    }

    private Set<IndexedClass> getDocumentedClasses(String string) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string2 = "fqn";
        this.search(string2, string, NameKind.EXACT_NAME, hashSet);
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (Index.SearchResult searchResult : hashSet) {
            int n;
            assert (searchResult != null);
            String string3 = searchResult.getValue("attrs");
            if (string3 == null || ((n = IndexedElement.stringToFlag(string3, 0)) & 1) == 0) continue;
            hashSet2.add(this.createClass(string, null, searchResult));
        }
        return hashSet2;
    }

    private Set<IndexedMethod> getDocumentedMethods(String string, String string2) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string3 = "fqn";
        this.search(string3, string, NameKind.EXACT_NAME, hashSet);
        HashSet<IndexedMethod> hashSet2 = new HashSet<IndexedMethod>();
        for (Index.SearchResult searchResult : hashSet) {
            int n;
            String[] stringArray;
            String[] stringArray2 = searchResult.getValues("method");
            if (stringArray2 != null) {
                stringArray = stringArray2;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    int n3;
                    int n4;
                    String string4 = stringArray[n];
                    if ((string2 == null || string2.length() == 0) && !Character.isLowerCase(string4.charAt(0)) || !string4.startsWith(string2) || string4.length() > string2.length() && string4.charAt(string2.length()) != '(' && string4.charAt(string2.length()) != ';' || (n4 = string4.indexOf(59, string2.length())) == -1 || ((n3 = IndexedElement.stringToFlag(string4, n4 + 1)) & 1) == 0) continue;
                    assert (searchResult != null);
                    hashSet2.add(this.createMethod(string4, searchResult, false));
                }
            }
            if ((stringArray = searchResult.getValues("attribute")) == null) continue;
            String[] stringArray3 = stringArray;
            n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string5 = stringArray3[i];
                if ((string2 == null || string2.length() == 0) && !Character.isLowerCase(string5.charAt(0)) || !string5.startsWith(string2) || string5.length() > string2.length() && string5.charAt(string2.length()) != ';') continue;
                assert (searchResult != null);
                hashSet2.add(this.createMethod(string5, searchResult, false));
            }
        }
        return hashSet2;
    }

    public String getRequiredFileUrl(String string) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        String string2 = "require";
        this.search(string2, string, NameKind.EXACT_NAME, hashSet);
        for (Index.SearchResult searchResult : hashSet) {
            String string3 = searchResult.getPersistentUrl();
            if (string3 == null) continue;
            return string3;
        }
        return null;
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-ruby.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        Object object;
        if (RubyIndexer.PREINDEXING) {
            object = RubyPlatformManager.platformIterator();
            while (object.hasNext()) {
                RubyPlatform rubyPlatform = (RubyPlatform)object.next();
                String string2 = RubyIndex.getGemHomeURL(rubyPlatform);
                if (string2 != null && string.startsWith(string2)) {
                    return GEM_URL + string.substring(string2.length());
                }
                string2 = rubyPlatform.getHomeUrl();
                if (!string.startsWith(string2)) continue;
                string = RUBYHOME_URL + string.substring(string2.length());
                return string;
            }
        } else {
            object = RubyPlatformManager.getDefaultPlatform();
            String string3 = RubyIndex.getGemHomeURL((RubyPlatform)object);
            if (string3 != null && string.startsWith(string3)) {
                return GEM_URL + string.substring(string3.length());
            }
            string3 = object.getHomeUrl();
            if (string.startsWith(string3)) {
                string = RUBYHOME_URL + string.substring(string3.length());
                return string;
            }
        }
        if (string.startsWith((String)(object = RubyIndex.getClusterUrl()))) {
            return CLUSTER_URL + string.substring(((String)object).length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(RUBYHOME_URL)) {
                Iterator iterator = RubyPlatformManager.platformIterator();
                while (iterator.hasNext()) {
                    RubyPlatform rubyPlatform = (RubyPlatform)iterator.next();
                    string = rubyPlatform.getHomeUrl() + string.substring(RUBYHOME_URL.length());
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
                    if (fileObject == null) continue;
                    return fileObject;
                }
                return null;
            }
            if (string.startsWith(GEM_URL)) {
                Iterator iterator = RubyPlatformManager.platformIterator();
                while (iterator.hasNext()) {
                    FileObject fileObject;
                    RubyPlatform rubyPlatform = (RubyPlatform)iterator.next();
                    if (!rubyPlatform.hasRubyGemsInstalled() || (fileObject = URLMapper.findFileObject((URL)new URL(string = rubyPlatform.getGemManager().getGemHomeUrl() + string.substring(GEM_URL.length())))) == null) continue;
                    return fileObject;
                }
                return null;
            }
            if (string.startsWith(CLUSTER_URL)) {
                string = RubyIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            return URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private static String getGemHomeURL(RubyPlatform rubyPlatform) {
        return rubyPlatform.hasRubyGemsInstalled() ? rubyPlatform.getGemManager().getGemHomeUrl() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableDefinition
    implements Comparable<TableDefinition> {
        private String version;
        private String table;
        private String fileUrl;
        private List<String> cols;

        TableDefinition(String string, String string2, String string3) {
            this.table = string;
            this.version = string2;
            this.fileUrl = string3;
        }

        @Override
        public int compareTo(TableDefinition tableDefinition) {
            if (this.version.length() != tableDefinition.version.length()) {
                return this.version.length() - tableDefinition.version.length();
            }
            return this.version.compareTo(tableDefinition.version);
        }

        String getFileUrl() {
            return this.fileUrl;
        }

        void addColumn(String string) {
            if (this.cols == null) {
                this.cols = new ArrayList<String>();
            }
            this.cols.add(string);
        }

        List<String> getColumns() {
            return this.cols;
        }
    }
}

