/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.DVarNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.types.INameNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.openide.filesystems.FileObject;

public class RubyTypeAnalyzer {
    static final String PARAM_HINT_ARG = "#:arg:";
    static final String PARAM_HINT_RETURN = "#:return:=>";
    private RubyIndex index;
    private Map<String, String> types;
    private final int astOffset;
    private final int lexOffset;
    private final Node root;
    private Node target;
    private final BaseDocument doc;
    private final FileObject fileObject;
    private static final String[] RAILS_CONTROLLER_VARS = new String[]{"action_name", "String", "assigns", "Hash", "cookies", "ActionController::CookieJar", "flash", "ActionController::Flash::FlashHash", "headers", "Hash", "params", "Hash", "request", "ActionController::CgiRequest", "session", "CGI::Session", "url", "ActionController::UrlRewriter"};

    public RubyTypeAnalyzer(RubyIndex rubyIndex, Node node, Node node2, int n, int n2, BaseDocument baseDocument, FileObject fileObject) {
        this.index = rubyIndex;
        this.root = node;
        this.target = node2;
        this.astOffset = n;
        this.lexOffset = n2;
        this.doc = baseDocument;
        this.fileObject = fileObject;
    }

    private String analyze(Node node) {
        Object object;
        Object object2;
        if (node == this.target) {
            this.target = null;
        }
        if (this.target == null && node.getPosition().getStartOffset() > this.astOffset) {
            return null;
        }
        switch (node.nodeId) {
            case LOCALASGNNODE: 
            case INSTASGNNODE: 
            case GLOBALASGNNODE: 
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case DASGNNODE: {
                object2 = ((INameNode)node).getName();
                object = this.expressionType(node);
                if (object != null) {
                    this.types.put((String)object2, (String)object);
                    break;
                }
                this.types.remove(object2);
            }
        }
        object2 = node.childNodes();
        object = object2.iterator();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            if (node2.isInvisible()) continue;
            this.analyze(node2);
        }
        return null;
    }

    private String expressionType(Node node) {
        List list = node.childNodes();
        if (list.size() != 1) {
            return null;
        }
        Node node2 = (Node)list.get(0);
        switch (node2.nodeId) {
            case CALLNODE: {
                IndexedClass indexedClass;
                CallNode callNode = (CallNode)node2;
                String string = callNode.getName();
                if ("new".equals(string)) {
                    Node node3 = callNode.getReceiverNode();
                    if (node3 instanceof Colon2Node) {
                        return AstUtilities.getFqn((Colon2Node)node3);
                    }
                    if (!(node3 instanceof INameNode)) break;
                    return ((INameNode)node3).getName();
                }
                if (!string.startsWith("find")) break;
                Node node4 = callNode.getReceiverNode();
                String string2 = null;
                if (node4 instanceof Colon2Node) {
                    string2 = AstUtilities.getFqn((Colon2Node)node4);
                } else if (node4 instanceof INameNode) {
                    string2 = ((INameNode)node4).getName();
                }
                if (string2 == null || this.index == null || (indexedClass = this.index.getSuperclass(string2)) == null || !"ActiveRecord::Base".equals(indexedClass.getFqn())) break;
                return this.pickFinderType(callNode, string, string2);
            }
            case LOCALVARNODE: {
                return this.types.get(((LocalVarNode)node2).getName());
            }
            case DVARNODE: {
                return this.types.get(((DVarNode)node2).getName());
            }
            case INSTVARNODE: {
                return this.types.get(((InstVarNode)node2).getName());
            }
            case GLOBALVARNODE: {
                return this.types.get(((GlobalVarNode)node2).getName());
            }
            case CLASSVARNODE: {
                return this.types.get(((ClassVarNode)node2).getName());
            }
            case ARRAYNODE: 
            case ZARRAYNODE: {
                return "Array";
            }
            case STRNODE: 
            case DSTRNODE: 
            case XSTRNODE: 
            case DXSTRNODE: {
                return "String";
            }
            case FIXNUMNODE: {
                return "Fixnum";
            }
            case BIGNUMNODE: {
                return "Bignum";
            }
            case HASHNODE: {
                return "Hash";
            }
            case REGEXPNODE: 
            case DREGEXPNODE: {
                return "Regexp";
            }
            case SYMBOLNODE: 
            case DSYMBOLNODE: {
                return "Symbol";
            }
            case FLOATNODE: {
                return "Float";
            }
            case NILNODE: {
                if (node2.isInvisible()) break;
                return "NilClass";
            }
            case TRUENODE: {
                return "TrueClass";
            }
            case FALSENODE: {
                return "FalseClass";
            }
        }
        return null;
    }

    public String getType(String string) {
        String string2;
        String string3;
        if (this.types == null) {
            this.types = new HashMap<String, String>();
            if (this.fileObject != null) {
                this.initFileTypeVars();
            }
            if (this.doc != null) {
                this.initTypeAssertions();
            }
            this.analyze(this.root);
        }
        if ((string3 = this.types.get(string)) == null && "t".equals(string) && this.root.nodeId == NodeType.DEFSNODE && ("up".equals(string2 = ((INameNode)this.root).getName()) || "down".equals(string2))) {
            return "ActiveRecord::ConnectionAdapters::TableDefinition";
        }
        if (string3 != null && string3.startsWith("Array<")) {
            return "Array";
        }
        return string3;
    }

    private void initFileTypeVars() {
        assert (this.fileObject != null);
        String string = this.fileObject.getExt();
        if (string.equals("rb")) {
            String string2 = this.fileObject.getName();
            if (string2.endsWith("_controller")) {
                for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                    String string3 = RAILS_CONTROLLER_VARS[i];
                    String string4 = RAILS_CONTROLLER_VARS[i + 1];
                    this.types.put(string3, string4);
                }
            }
        } else if (string.equals("rhtml") || string.equals("erb")) {
            for (int i = 0; i < RAILS_CONTROLLER_VARS.length; i += 2) {
                String string5 = RAILS_CONTROLLER_VARS[i];
                String string6 = RAILS_CONTROLLER_VARS[i + 1];
                this.types.put(string5, string6);
            }
        } else if (string.equals("rjs")) {
            this.types.put("page", "ActionView::Helpers::PrototypeHelper::JavaScriptGenerator::GeneratorMethods");
        } else if (string.equals("builder") || string.equals("rxml")) {
            this.types.put("xml", "Builder::XmlMarkup");
        }
    }

    private void initTypeAssertions() {
        List<String> list;
        if (this.root instanceof MethodDefNode && (list = AstUtilities.gatherDocumentation(null, this.doc, this.root)) != null && list.size() > 0) {
            for (String string : list) {
                char c;
                int n;
                if (!string.startsWith(PARAM_HINT_ARG)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = null;
                int n2 = string.length();
                for (n = PARAM_HINT_ARG.length(); n < n2; ++n) {
                    c = string.charAt(n);
                    if (c == ' ') continue;
                    if (c == '=') break;
                    stringBuilder.append(c);
                }
                if (n == n2 || string.charAt(n) != '=') continue;
                ++n;
                if (stringBuilder.length() <= 0) continue;
                string2 = stringBuilder.toString();
                stringBuilder.setLength(0);
                if (n == n2 || string.charAt(n) != '>') continue;
                ++n;
                while (n < n2) {
                    c = string.charAt(n);
                    if (c != ' ') {
                        if (!Character.isJavaIdentifierPart(c)) break;
                        stringBuilder.append(c);
                    }
                    ++n;
                }
                if (stringBuilder.length() <= 0) continue;
                String string3 = stringBuilder.toString();
                this.types.put(string2, string3);
            }
        }
    }

    private String pickFinderType(CallNode callNode, String string, String string2) {
        boolean bl;
        if (string.startsWith("find_all")) {
            bl = true;
        } else if (string.startsWith("find_by_") || string.equals("find_first")) {
            bl = false;
        } else if (string.equals("find")) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            AstUtilities.addNodesByType((Node)callNode, new NodeType[]{NodeType.SYMBOLNODE}, arrayList);
            boolean bl2 = false;
            for (Node node : arrayList) {
                SymbolNode symbolNode = (SymbolNode)node;
                if (!"all".equals(symbolNode.getName())) continue;
                bl2 = true;
                break;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            return "Array<" + string2 + ">";
        }
        return string2;
    }
}

