/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.InputStreamLexerSource;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyLexer
implements Lexer<RubyTokenId> {
    private static final boolean REUSE_LEXERS = false;
    private static RubyLexer cached;
    private final RubyYaccLexer lexer = new RubyYaccLexer();
    private LexerSource lexerSource;
    private boolean inRegexp;
    private LexerInput input;
    private TokenFactory<RubyTokenId> tokenFactory;
    private boolean substituting;
    private boolean inSymbol;
    private boolean inEmbedded;

    private RubyLexer(LexerRestartInfo<RubyTokenId> lexerRestartInfo) {
        this.lexer.setWarnings((IRubyWarnings)new NullWarnings());
        this.lexer.setPreserveSpaces(true);
    }

    public static synchronized RubyLexer create(LexerRestartInfo<RubyTokenId> lexerRestartInfo) {
        RubyLexer rubyLexer = cached;
        if (rubyLexer == null) {
            rubyLexer = new RubyLexer(lexerRestartInfo);
        }
        rubyLexer.restart(lexerRestartInfo);
        return rubyLexer;
    }

    void restart(LexerRestartInfo<RubyTokenId> lexerRestartInfo) {
        this.inEmbedded = false;
        this.inSymbol = false;
        this.substituting = false;
        this.inRegexp = false;
        this.lexer.reset();
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        String string = "unknown";
        LexerInputStream lexerInputStream = new LexerInputStream(this.input);
        this.lexerSource = new InputStreamLexerSource(string, (InputStream)lexerInputStream, null, 0, false);
        this.lexer.setSource(this.lexerSource);
        Object object = lexerRestartInfo.state();
        if (object instanceof JRubyLexerRestartInfo) {
            ((JRubyLexerRestartInfo)object).initializeState(this);
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            this.lexer.setState(RubyYaccLexer.LexState.fromOrdinal((int)n));
        }
    }

    public void release() {
    }

    public Object state() {
        if (JRubyLexerRestartInfo.needsStateStorage(this)) {
            return new JRubyLexerRestartInfo(this);
        }
        RubyYaccLexer.LexState lexState = this.lexer.getLexState();
        if (lexState == null) {
            return null;
        }
        if (this.lexer.getStrTerm() != null) {
            return new JRubyLexerRestartInfo(this);
        }
        return lexState.getOrdinal();
    }

    private Token<RubyTokenId> token(RubyTokenId rubyTokenId, int n) {
        String string = rubyTokenId.fixedText();
        return string != null ? this.tokenFactory.getFlyweightToken((TokenId)rubyTokenId, string) : this.tokenFactory.createToken((TokenId)rubyTokenId, n);
    }

    public Token<RubyTokenId> nextToken() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.lexerSource.getOffset();
        while (n3 == 0) {
            block18: {
                try {
                    this.lexer.advance();
                    n2 = this.lexer.token();
                    StrTerm strTerm = this.lexer.getStrTerm();
                    if (strTerm == null) break block18;
                    strTerm.splitEmbeddedTokens();
                }
                catch (StringTerm.UnterminatedStringException unterminatedStringException) {
                    int n5;
                    n2 = 256;
                    int n6 = this.lexerSource.chompReadAhead();
                    if (n6 > 0) {
                        this.input.backup(n6);
                    }
                    this.input.backup(this.input.readLengthEOF());
                    n3 = 0;
                    while ((n5 = this.input.read()) != -1) {
                        ++n3;
                        if (n5 != 10) continue;
                        break;
                    }
                    this.lexerSource.setOffset(n4 + n3);
                    if (n3 > 0) {
                        return this.token(RubyTokenId.ERROR, n3);
                    }
                    return null;
                }
                catch (SyntaxException syntaxException) {
                    n2 = 256;
                    n3 = this.lexerSource.getOffset() - n4;
                    if (n3 != 0) break;
                    if (this.input.readLength() > 0) {
                        return this.token(RubyTokenId.IDENTIFIER, this.input.readLength());
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(throwable);
                    break;
                }
            }
            assert (n2 != 0);
            if (n2 == -1) {
                if (this.input.readLength() > 0) {
                    return this.token(RubyTokenId.IDENTIFIER, this.input.readLength());
                }
                return null;
            }
            int n7 = this.lexerSource.getOffset();
            n3 = n7 - n4;
        }
        if ((n = this.lexerSource.chompReadAhead()) > 0) {
            this.input.backup(n);
        }
        RubyTokenId rubyTokenId = this.getTokenId(n2, n4);
        if (this.inSymbol) {
            String string = rubyTokenId.primaryCategory();
            boolean bl = "string".equals(string);
            if (!bl || rubyTokenId == RubyTokenId.STRING_END || rubyTokenId == RubyTokenId.QUOTED_STRING_END) {
                boolean bl2 = this.inSymbol = n2 == 366;
            }
            if (bl || rubyTokenId == RubyTokenId.IDENTIFIER || rubyTokenId == RubyTokenId.CONSTANT || "keyword".equals(string)) {
                rubyTokenId = RubyTokenId.TYPE_SYMBOL;
            }
        } else {
            boolean bl = this.inSymbol = n2 == 366;
        }
        if (n3 <= 0) {
            return this.token(RubyTokenId.IDENTIFIER, 1);
        }
        return this.token(rubyTokenId, n3);
    }

    private RubyTokenId getTokenId(int n, int n2) {
        switch (n) {
            case 50000: {
                return RubyTokenId.LINE_COMMENT;
            }
            case 50001: {
                return RubyTokenId.WHITESPACE;
            }
            case 314: {
                return RubyTokenId.FLOAT_LITERAL;
            }
            case 313: {
                return RubyTokenId.INT_LITERAL;
            }
            case 367: 
            case 368: 
            case 370: 
            case 371: {
                this.substituting = this.lexer.getStrTerm() != null ? this.lexer.getStrTerm().isSubstituting() : false;
                return this.substituting ? RubyTokenId.QUOTED_STRING_BEGIN : RubyTokenId.STRING_BEGIN;
            }
            case 372: 
            case 373: {
                this.inEmbedded = true;
                return this.inRegexp ? RubyTokenId.REGEXP_LITERAL : RubyTokenId.STRING_LITERAL;
            }
            case 374: {
                return this.substituting ? RubyTokenId.QUOTED_STRING_END : RubyTokenId.STRING_END;
            }
            case 312: {
                if (this.inEmbedded) {
                    this.inEmbedded = false;
                    return RubyTokenId.EMBEDDED_RUBY;
                }
                if (this.inRegexp) {
                    return RubyTokenId.REGEXP_LITERAL;
                }
                if (this.lexer.getStrTerm() != null) {
                    this.substituting = this.lexer.getStrTerm().isSubstituting();
                    if (this.substituting) {
                        return RubyTokenId.QUOTED_STRING_LITERAL;
                    }
                    return RubyTokenId.STRING_LITERAL;
                }
                this.substituting = false;
                return RubyTokenId.STRING_LITERAL;
            }
            case 369: {
                this.inRegexp = true;
                return RubyTokenId.REGEXP_BEGIN;
            }
            case 315: {
                this.inRegexp = false;
                return RubyTokenId.REGEXP_END;
            }
            case 50002: {
                return RubyTokenId.DOCUMENTATION;
            }
            case 256: {
                return RubyTokenId.ERROR;
            }
            case 306: {
                return RubyTokenId.GLOBAL_VAR;
            }
            case 307: {
                return RubyTokenId.INSTANCE_VAR;
            }
            case 309: {
                return RubyTokenId.CLASS_VAR;
            }
            case 308: {
                return RubyTokenId.CONSTANT;
            }
            case 304: {
                return RubyTokenId.IDENTIFIER;
            }
            case 366: {
                return RubyTokenId.TYPE_SYMBOL;
            }
            case 91: 
            case 345: {
                return RubyTokenId.LBRACKET;
            }
            case 93: 
            case 346: {
                return RubyTokenId.RBRACKET;
            }
            case 341: 
            case 342: 
            case 344: {
                return RubyTokenId.LPAREN;
            }
            case 343: {
                return RubyTokenId.RPAREN;
            }
            case 347: 
            case 348: 
            case 363: {
                return RubyTokenId.LBRACE;
            }
            case 364: {
                return RubyTokenId.RBRACE;
            }
            case 259: {
                return RubyTokenId.DEF;
            }
            case 264: {
                return RubyTokenId.END;
            }
            case 257: {
                return RubyTokenId.CLASS;
            }
            case 258: {
                return RubyTokenId.MODULE;
            }
            case 261: {
                return RubyTokenId.BEGIN;
            }
            case 265: {
                return RubyTokenId.IF;
            }
            case 266: {
                return RubyTokenId.UNLESS;
            }
            case 272: {
                return RubyTokenId.WHILE;
            }
            case 273: {
                return RubyTokenId.UNTIL;
            }
            case 281: 
            case 282: {
                return RubyTokenId.ANY_KEYWORD;
            }
            case 280: {
                return RubyTokenId.DO;
            }
            case 270: {
                return RubyTokenId.CASE;
            }
            case 274: {
                return RubyTokenId.FOR;
            }
            case 269: {
                return RubyTokenId.ELSE;
            }
            case 268: {
                return RubyTokenId.ELSIF;
            }
            case 263: {
                return RubyTokenId.ENSURE;
            }
            case 271: {
                return RubyTokenId.WHEN;
            }
            case 262: {
                return RubyTokenId.RESCUE;
            }
            case 285: {
                return RubyTokenId.SUPER;
            }
            case 286: {
                return RubyTokenId.SELF;
            }
            case 333: 
            case 334: {
                return RubyTokenId.ANY_OPERATOR;
            }
            case 260: 
            case 267: 
            case 275: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 283: 
            case 284: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                return RubyTokenId.ANY_KEYWORD;
            }
            case 58: 
            case 61: 
            case 63: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 335: 
            case 336: 
            case 339: 
            case 340: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: {
                return RubyTokenId.NONUNARY_OP;
            }
            case 330: {
                return RubyTokenId.DOT;
            }
            case 331: 
            case 332: {
                return RubyTokenId.RANGE;
            }
            case 338: {
                return RubyTokenId.COLON3;
            }
        }
        return RubyTokenId.IDENTIFIER;
    }

    private static class LexerInputStream
    extends InputStream {
        private LexerInput input;

        LexerInputStream(LexerInput lexerInput) {
            this.input = lexerInput;
        }

        public void close() throws IOException {
        }

        public int read() throws IOException {
            int n = this.input.read();
            if (n == -1) {
                return -1;
            }
            return n;
        }
    }

    private static class LexerInputReader
    extends Reader {
        private LexerInput input;

        LexerInputReader(LexerInput lexerInput) {
            this.input = lexerInput;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                int n3 = this.input.read();
                if (n3 == -1) {
                    return -1;
                }
                cArray[i + n] = (char)n3;
            }
            return n2;
        }

        public void close() throws IOException {
        }
    }

    private static class JRubyLexerRestartInfo {
        private static final int IN_REGEXP = 1;
        private static final int IN_SYMBOL = 2;
        private static final int IN_EMBEDDED = 4;
        private static final int IN_SUBSTITUTING = 8;
        private static final int SET_SPACE_SEEN = 16;
        private static final int SET_COMMAND_START = 32;
        private final StrTerm strTerm;
        private int localState;
        private final RubyYaccLexer.LexState lexState;
        private Object strTermState;
        private final RubyYaccLexer.HeredocContext heredocContext;

        JRubyLexerRestartInfo(RubyLexer rubyLexer) {
            this.strTerm = rubyLexer.lexer.getStrTerm();
            if (this.strTerm != null) {
                this.strTermState = this.strTerm.getMutableState();
            }
            this.heredocContext = ((RubyLexer)rubyLexer).lexer.heredocContext;
            this.lexState = rubyLexer.lexer.getLexState();
            if (rubyLexer.inRegexp) {
                ++this.localState;
            }
            if (rubyLexer.inSymbol) {
                this.localState += 2;
            }
            if (rubyLexer.inEmbedded) {
                this.localState += 4;
            }
            if (rubyLexer.substituting) {
                this.localState += 8;
            }
            if (rubyLexer.lexer.isSetSpaceSeen()) {
                this.localState += 16;
            }
            if (rubyLexer.lexer.isCommandStart()) {
                this.localState += 32;
            }
        }

        public static boolean needsStateStorage(RubyLexer rubyLexer) {
            return rubyLexer.inRegexp || rubyLexer.inSymbol || rubyLexer.inEmbedded || rubyLexer.substituting || rubyLexer.lexer.isCommandStart() || ((RubyLexer)rubyLexer).lexer.heredocContext != null || rubyLexer.lexer.isSetSpaceSeen();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            JRubyLexerRestartInfo jRubyLexerRestartInfo = (JRubyLexerRestartInfo)object;
            if (!(this.strTerm == jRubyLexerRestartInfo.strTerm || this.strTerm != null && this.strTerm.equals(jRubyLexerRestartInfo.strTerm))) {
                return false;
            }
            if (this.localState != jRubyLexerRestartInfo.localState) {
                return false;
            }
            if (this.lexState != jRubyLexerRestartInfo.lexState && (this.lexState == null || this.lexState.getOrdinal() != jRubyLexerRestartInfo.lexState.getOrdinal())) {
                return false;
            }
            if (!(this.strTermState == jRubyLexerRestartInfo.strTermState || this.strTermState != null && this.strTermState.equals(jRubyLexerRestartInfo.strTermState))) {
                return false;
            }
            return this.heredocContext == jRubyLexerRestartInfo.heredocContext || this.heredocContext != null && this.heredocContext.equals((Object)jRubyLexerRestartInfo.heredocContext);
        }

        public int hashCode() {
            int n = 7;
            n = 43 * n + this.localState;
            n = 43 * n + (this.strTerm != null ? this.strTerm.hashCode() : 0);
            n = 43 * n + (this.strTermState != null ? this.strTermState.hashCode() : 0);
            return n;
        }

        private static String toStateString(int n) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            if ((n & 1) != 0) {
                stringBuilder.append("regexp|");
            }
            if ((n & 2) != 0) {
                stringBuilder.append("symbol|");
            }
            if ((n & 4) != 0) {
                stringBuilder.append("embedded|");
            }
            if ((n & 8) != 0) {
                stringBuilder.append("substituting|");
            }
            if ((n & 0x20) != 0) {
                stringBuilder.append("commandstart|");
            }
            if ((n & 0x10) != 0) {
                stringBuilder.append("spaceseen|");
            }
            if ((string = stringBuilder.toString()).endsWith("|")) {
                string = string.substring(0, string.length() - 1);
            } else if (string.length() == 0) {
                string = "-";
            }
            return string;
        }

        public String toString() {
            return "RubyLexerState[" + JRubyLexerRestartInfo.toStateString(this.localState) + "," + this.strTerm + "," + this.lexState + "," + this.strTermState + "," + this.heredocContext + "]";
        }

        void initializeState(RubyLexer rubyLexer) {
            rubyLexer.lexer.setStrTerm(this.strTerm);
            ((RubyLexer)rubyLexer).lexer.heredocContext = this.heredocContext;
            if (this.strTermState != null && this.strTerm != null) {
                this.strTerm.setMutableState(this.strTermState);
            }
            if ((this.localState & 1) != 0) {
                rubyLexer.inRegexp = true;
            }
            if ((this.localState & 2) != 0) {
                rubyLexer.inSymbol = true;
            }
            if ((this.localState & 4) != 0) {
                rubyLexer.inEmbedded = true;
            }
            if ((this.localState & 8) != 0) {
                rubyLexer.substituting = true;
            }
            if ((this.localState & 0x20) != 0) {
                rubyLexer.lexer.setCommandStart(true);
            }
            if ((this.localState & 0x10) != 0) {
                rubyLexer.lexer.setSpaceSeen(true);
            }
            rubyLexer.lexer.setLexState(this.lexState);
        }
    }
}

