/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.options;

import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.options.FmtOptions;

public final class CodeStyle {
    private Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static CodeStyle getTestStyle(Preferences preferences) {
        return new CodeStyle(preferences);
    }

    public static synchronized CodeStyle getDefault(Project project) {
        return FmtOptions.codeStyleProducer.create(FmtOptions.getPreferences(project));
    }

    public boolean expandTabToSpaces() {
        return this.preferences.getBoolean("expand-tabs", FmtOptions.getGlobalExpandTabToSpaces());
    }

    public int getTabSize() {
        return this.preferences.getInt("tab-size", FmtOptions.getGlobalTabSize());
    }

    public int getIndentSize() {
        int n = this.preferences.getInt("indent-shift-width", FmtOptions.getGlobalIndentSize());
        if (n <= 0) {
            boolean bl = this.preferences.getBoolean("expand-tabs", FmtOptions.getGlobalExpandTabToSpaces());
            n = bl ? this.preferences.getInt("spaces-per-tab", FmtOptions.getGlobalSpacesPerTab()) : this.preferences.getInt("tab-size", FmtOptions.getGlobalTabSize());
        }
        return n;
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", FmtOptions.getDefaultAsInt("continuationIndentSize"));
    }

    public boolean reformatComments() {
        return this.preferences.getBoolean("reformatComments", FmtOptions.getDefaultAsBoolean("reformatComments"));
    }

    public boolean indentHtml() {
        return this.preferences.getBoolean("indentHtml", FmtOptions.getDefaultAsBoolean("indentHtml"));
    }

    public int getRightMargin() {
        return this.preferences.getInt("text-limit-width", FmtOptions.getGlobalRightMargin());
    }

    static {
        FmtOptions.codeStyleProducer = new Producer();
        FmtOptions.codeStyleProducer = new Producer();
    }

    private static class Producer
    implements FmtOptions.CodeStyleProducer {
        private Producer() {
        }

        public CodeStyle create(Preferences preferences) {
            return new CodeStyle(preferences);
        }
    }
}

