/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.ruby.RubyFormatter;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.options.CodeStyle;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmtOptions {
    public static final String expandTabToSpaces = "expand-tabs";
    public static final String tabSize = "tab-size";
    public static final String spacesPerTab = "spaces-per-tab";
    public static final String indentSize = "indent-shift-width";
    public static final String rightMargin = "text-limit-width";
    public static final String continuationIndentSize = "continuationIndentSize";
    public static final String reformatComments = "reformatComments";
    public static final String indentHtml = "indentHtml";
    public static CodeStyleProducer codeStyleProducer;
    public static Preferences lastValues;
    private static Class<? extends EditorKit> kitClass;
    static final String CODE_STYLE_PROFILE = "CodeStyle";
    private static final String DEFAULT_PROFILE = "default";
    static final String PROJECT_PROFILE = "project";
    static final String usedProfile = "usedProfile";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static Map<String, String> defaults;

    private FmtOptions() {
    }

    public static int getDefaultAsInt(String string) {
        return Integer.parseInt(defaults.get(string));
    }

    public static boolean getDefaultAsBoolean(String string) {
        return Boolean.parseBoolean(defaults.get(string));
    }

    public static String getDefaultAsString(String string) {
        return defaults.get(string);
    }

    public static Preferences getPreferences(String string) {
        return NbPreferences.forModule(CodeStyle.class).node(CODE_STYLE_PROFILE).node(string);
    }

    public static Preferences getPreferences(Project project) {
        Preferences preferences;
        String string;
        if (project != null && PROJECT_PROFILE.equals(string = (preferences = ProjectUtils.getPreferences((Project)project, IndentUtils.class, (boolean)true).node(CODE_STYLE_PROFILE)).get(usedProfile, DEFAULT_PROFILE))) {
            return preferences.node(PROJECT_PROFILE).node("text/x-ruby");
        }
        return (Preferences)MimeLookup.getLookup((String)"text/x-ruby").lookup(Preferences.class);
    }

    public static Class<? extends EditorKit> getKitClass() {
        if (kitClass == null) {
            EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-ruby")).lookup(EditorKit.class);
            kitClass = editorKit != null ? editorKit.getClass() : EditorKit.class;
        }
        return kitClass;
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static CodeStyle createCodeStyle(Preferences preferences) {
        CodeStyle.getDefault(null);
        return codeStyleProducer.create(preferences);
    }

    public static boolean getGlobalExpandTabToSpaces() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-ruby").lookup(Preferences.class);
        return preferences.getBoolean(expandTabToSpaces, FmtOptions.getDefaultAsBoolean(expandTabToSpaces));
    }

    public static int getGlobalTabSize() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-ruby").lookup(Preferences.class);
        return preferences.getInt(tabSize, FmtOptions.getDefaultAsInt(tabSize));
    }

    public static int getGlobalSpacesPerTab() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-ruby").lookup(Preferences.class);
        return preferences.getInt(spacesPerTab, FmtOptions.getDefaultAsInt(spacesPerTab));
    }

    public static int getGlobalIndentSize() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-ruby").lookup(Preferences.class);
        return preferences.getInt(indentSize, -1);
    }

    public static int getGlobalRightMargin() {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-ruby").lookup(Preferences.class);
        return preferences.getInt(rightMargin, FmtOptions.getDefaultAsInt(rightMargin));
    }

    public static boolean isInteger(String string) {
        String string2 = defaults.get(string);
        try {
            Integer.parseInt(string2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static void createDefaults() {
        String[][] stringArrayArray = new String[][]{{expandTabToSpaces, TRUE}, {tabSize, "2"}, {spacesPerTab, "4"}, {indentSize, "2"}, {continuationIndentSize, "2"}, {rightMargin, "120"}, {reformatComments, FALSE}, {indentHtml, TRUE}};
        defaults = new HashMap<String, String>();
        for (String[] stringArray : stringArrayArray) {
            defaults.put(stringArray[0], stringArray[1]);
        }
    }

    static {
        FmtOptions.createDefaults();
    }

    public static interface CodeStyleProducer {
        public CodeStyle create(Preferences var1);
    }

    public static class PreviewPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        protected void putSpi(String string, String string2) {
            this.map.put(string, string2);
        }

        protected String getSpi(String string) {
            return (String)this.map.get(string);
        }

        protected void removeSpi(String string) {
            this.map.remove(string);
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            String[] stringArray = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(stringArray);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategorySupport
    extends OptionsPanelController
    implements ActionListener,
    DocumentListener,
    HierarchyListener {
        public static final String OPTION_ID = "org.netbeans.modules.ruby.options.FormatingOptions.ID";
        private static final int LOAD = 0;
        private static final int STORE = 1;
        private static final int ADD_LISTENERS = 2;
        private String previewText = NbBundle.getMessage(FmtOptions.class, (String)"SAMPLE_Default");
        private String[][] forcedOptions;
        private boolean changed = false;
        private boolean loaded = false;
        private JPanel panel;
        private List<JComponent> components = new LinkedList<JComponent>();
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private JEditorPane previewPane;
        protected Preferences preferences;

        public CategorySupport(JPanel jPanel, String string, String[] ... stringArray) {
            this.panel = jPanel;
            jPanel.addHierarchyListener(this);
            this.scan(jPanel, this.components);
            this.previewText = string == null ? this.previewText : string;
            this.forcedOptions = stringArray;
            this.addListeners();
        }

        protected void addListeners() {
            this.scan(2, null);
        }

        public void update() {
            this.loaded = true;
            this.scan(0, this.preferences);
            this.loaded = false;
            this.changed = false;
        }

        public void applyChanges() {
            this.storeTo(this.preferences);
            RubyFormatter.syncCurrentOptions();
        }

        public void cancel() {
        }

        public boolean isValid() {
            return true;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public JComponent getComponent(Lookup lookup) {
            this.preferences = (Preferences)lookup.lookup(Preferences.class);
            this.previewPane = (JEditorPane)lookup.lookup(JEditorPane.class);
            return this.panel;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        protected void storeTo(Preferences preferences) {
            this.scan(1, preferences);
        }

        void changed() {
            if (this.loaded) {
                return;
            }
            if (!this.changed) {
                this.changed = true;
                this.pcs.firePropertyChange("changed", false, true);
            }
            this.pcs.firePropertyChange("valid", null, null);
            this.refreshPreview();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.changed();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (this.panel.isShowing()) {
                this.refreshPreview();
            }
        }

        private void refreshPreview() {
            Object object;
            JComponent jComponent;
            PreviewPreferences previewPreferences = new PreviewPreferences();
            this.storeTo(previewPreferences);
            for (String[] object22 : this.forcedOptions) {
                ((Preferences)previewPreferences).put(object22[0], object22[1]);
            }
            try {
                int n = ((Preferences)previewPreferences).getInt(FmtOptions.rightMargin, FmtOptions.getDefaultAsInt(FmtOptions.rightMargin));
                this.previewPane.putClientProperty("TextLimitLine", n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                Class.forName(CodeStyle.class.getName(), true, CodeStyle.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            CodeStyle codeStyle = codeStyleProducer.create(previewPreferences);
            int n = 30;
            try {
                int n2;
                Font font;
                int n3;
                n = ((Preferences)previewPreferences).getInt(FmtOptions.rightMargin, FmtOptions.getDefaultAsInt(FmtOptions.rightMargin));
                jComponent = this.previewPane;
                if (this.previewPane.getParent() instanceof JViewport) {
                    jComponent = (JViewport)this.previewPane.getParent();
                }
                if ((n3 = ((FontMetrics)(object = jComponent.getFontMetrics(font = jComponent.getFont()))).charWidth('x')) > 0 && (n2 = jComponent.getWidth() / n3) > 3) {
                    n = n2 - 2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.previewPane.setIgnoreRepaint(true);
            try {
                jComponent = new BaseDocument(null, false);
                jComponent.putProperty("mimeType", "text/x-ruby");
                jComponent.putProperty(Language.class, RubyTokenId.language());
                jComponent.insertString(0, this.previewText, null);
                RubyFormatter rubyFormatter = new RubyFormatter(codeStyle, n);
                rubyFormatter.reformat((Document)((Object)jComponent), 0, jComponent.getLength(), null);
                object = jComponent.getText(0, jComponent.getLength());
                this.previewPane.setText((String)object);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            this.previewPane.setIgnoreRepaint(false);
            this.previewPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            this.previewPane.repaint(100L);
        }

        private void performOperation(int n, JComponent jComponent, String string, Preferences preferences) {
            switch (n) {
                case 0: {
                    this.loadData(jComponent, string, preferences);
                    break;
                }
                case 1: {
                    this.storeData(jComponent, string, preferences);
                    break;
                }
                case 2: {
                    this.addListener(jComponent);
                }
            }
        }

        private void scan(int n, Preferences preferences) {
            for (JComponent jComponent : this.components) {
                Object object = jComponent.getClientProperty(OPTION_ID);
                if (object instanceof String) {
                    this.performOperation(n, jComponent, (String)object, preferences);
                    continue;
                }
                if (!(object instanceof String[])) continue;
                for (String string : (String[])object) {
                    this.performOperation(n, jComponent, string, preferences);
                }
            }
        }

        private void scan(Container container, List<JComponent> list) {
            for (Component component : container.getComponents()) {
                JComponent jComponent;
                Object object;
                if (component instanceof JComponent && ((object = (jComponent = (JComponent)component).getClientProperty(OPTION_ID)) instanceof String || object instanceof String[])) {
                    list.add(jComponent);
                }
                if (!(component instanceof Container)) continue;
                this.scan((Container)component, list);
            }
        }

        private void loadData(JComponent jComponent, String string, Preferences preferences) {
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.setText(preferences.get(string, FmtOptions.getDefaultAsString(string)));
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                boolean bl = FmtOptions.getDefaultAsBoolean(string);
                jCheckBox.setSelected(preferences.getBoolean(string, bl));
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                String string2 = preferences.get(string, FmtOptions.getDefaultAsString(string));
                ComboBoxModel comboBoxModel = this.createModel(string2);
                jComboBox.setModel(comboBoxModel);
                ComboItem comboItem = CategorySupport.whichItem(string2, comboBoxModel);
                jComboBox.setSelectedItem(comboItem);
            }
        }

        private void storeData(JComponent jComponent, String string, Preferences preferences) {
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                String string2 = jTextField.getText();
                if (FmtOptions.isInteger(string)) {
                    try {
                        int n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                if (!string.equals(FmtOptions.tabSize) && !string.equals(FmtOptions.spacesPerTab) && !string.equals(FmtOptions.indentSize) && FmtOptions.getDefaultAsString(string).equals(string2)) {
                    preferences.remove(string);
                } else {
                    preferences.put(string, string2);
                }
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                if (!string.equals(FmtOptions.expandTabToSpaces) && FmtOptions.getDefaultAsBoolean(string) == jCheckBox.isSelected()) {
                    preferences.remove(string);
                } else {
                    preferences.putBoolean(string, jCheckBox.isSelected());
                }
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                String string3 = ((ComboItem)jComboBox.getSelectedItem()).value;
                if (FmtOptions.getDefaultAsString(string).equals(string3)) {
                    preferences.remove(string);
                } else {
                    preferences.put(string, string3);
                }
            }
        }

        private void addListener(JComponent jComponent) {
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.addActionListener(this);
                jTextField.getDocument().addDocumentListener(this);
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                jCheckBox.addActionListener(this);
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                jComboBox.addActionListener(this);
            }
        }

        private ComboBoxModel createModel(String string) {
            return null;
        }

        private static ComboItem whichItem(String string, ComboBoxModel comboBoxModel) {
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                ComboItem comboItem = (ComboItem)comboBoxModel.getElementAt(i);
                if (!string.equals(comboItem.value)) continue;
                return comboItem;
            }
            return null;
        }

        private static class ComboItem {
            String value;
            String displayName;

            public ComboItem(String string, String string2) {
                this.value = string;
                this.displayName = NbBundle.getMessage(FmtOptions.class, (String)string2);
            }

            public String toString() {
                return this.displayName;
            }
        }
    }
}

