/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql.execute;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.api.sql.execute.SQLExecutionInfo;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.loader.SQLExecutionLoggerImpl;

public class SQLExecutor {
    private static Logger LOGGER = Logger.getLogger(SQLExecutor.class.getName());

    public static SQLExecutionInfo execute(DatabaseConnection databaseConnection, String string) throws DatabaseException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("You can not run this method on the event dispatching thread.");
        }
        try {
            if (databaseConnection.getJDBCConnection() == null || databaseConnection.getJDBCConnection().isClosed()) {
                throw new DatabaseException("The connection is not open");
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException((Throwable)sQLException);
        }
        SQLExecutionResults sQLExecutionResults = SQLExecuteHelper.execute(string, 0, string.length(), databaseConnection, new SQLExecutionLoggerImpl(""));
        return new SQLExecutionInfoImpl(sQLExecutionResults);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SQLExecutionInfoImpl
    implements SQLExecutionInfo {
        private final boolean hasExceptions;
        private final List<Throwable> exceptions;

        SQLExecutionInfoImpl(SQLExecutionResults sQLExecutionResults) {
            this.hasExceptions = sQLExecutionResults.hasExceptions();
            this.exceptions = new ArrayList<Throwable>();
            for (SQLExecutionResult sQLExecutionResult : sQLExecutionResults.getResults()) {
                if (!sQLExecutionResult.hasExceptions()) continue;
                this.exceptions.addAll(sQLExecutionResult.getExceptions());
            }
        }

        @Override
        public boolean hasExceptions() {
            return this.hasExceptions;
        }

        @Override
        public List<? extends Throwable> getExceptions() {
            return this.exceptions;
        }
    }
}

