/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.db.sql.history.SQLHistory;
import org.netbeans.modules.db.sql.history.SQLHistoryModel;
import org.netbeans.modules.db.sql.history.SQLHistoryModelImpl;
import org.netbeans.modules.db.sql.history.SQLHistoryPersistenceManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class SQLHistoryPanel
extends JPanel {
    public static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";
    public static final String SQL_HISTORY_FILE_NAME = "sql_history";
    public static final String SAVE_STATEMENTS_MAX_LIMIT_ENTERED = "10000";
    public static final String SAVE_STATEMENTS_CLEARED = "";
    public static final int SAVE_STATEMENTS_MAX_LIMIT = 10000;
    public static final int TABLE_DATA_WIDTH_SQL = 125;
    public static final Logger LOGGER = Logger.getLogger(SQLHistoryPanel.class.getName());
    private static Object[][] data;
    private Object[] comboData;
    private SQLHistoryView view;
    private JEditorPane editorPane;
    private JComboBox connectionComboBox;
    private JLabel inputWarningLabel;
    private JButton insertSQLButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextField searchTextField;
    private JTable sqlHistoryTable;
    private JButton sqlLimitButton;
    private JLabel sqlLimitLabel;
    private JTextField sqlLimitTextField;

    public SQLHistoryPanel(JEditorPane jEditorPane) {
        this.editorPane = jEditorPane;
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SQLHistoryPanel.this.view = new SQLHistoryView(new SQLHistoryModelImpl());
            }
        });
        task.run();
        this.initSQLHistoryTableData(this.view);
        this.initComponents();
        this.connectionComboBox.addActionListener((HistoryTableModel)this.sqlHistoryTable.getModel());
        this.searchTextField.getDocument().addDocumentListener((HistoryTableModel)this.sqlHistoryTable.getModel());
        this.sqlHistoryTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SQLTableTitle"));
        this.sqlHistoryTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_DateTableTitle"));
        this.view.updateUrl();
        this.inputWarningLabel.setVisible(false);
        String string = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
        if (string != null) {
            this.sqlLimitTextField.setText(string);
        } else {
            this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
        }
        if (string.equals(SAVE_STATEMENTS_CLEARED)) {
            string = SAVE_STATEMENTS_MAX_LIMIT_ENTERED;
        }
        SQLHistoryPersistenceManager.getInstance().updateSQLSaved(Integer.parseInt(string), Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(SQL_HISTORY_FOLDER));
        this.verifySQLLimit();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SQLHistoryPanel.adjustColumnPreferredWidths(SQLHistoryPanel.this.sqlHistoryTable);
                SQLHistoryPanel.this.sqlHistoryTable.revalidate();
            }
        });
    }

    private void initSQLHistoryTableData(SQLHistoryView sQLHistoryView) {
        List<String> list = this.view.getSQLList();
        List<String> list2 = this.view.getDateList();
        data = new Object[list.size()][2];
        int n = 0;
        for (String string : list) {
            int n2 = string.trim().length();
            int n3 = n2 > 125 ? 125 : n2;
            SQLHistoryPanel.data[n][0] = string.trim().substring(0, n3);
            ++n;
        }
        n = 0;
        for (String string : list2) {
            SQLHistoryPanel.data[n][1] = string;
            ++n;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.connectionComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.searchTextField = new JTextField();
        this.insertSQLButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sqlHistoryTable = new JTable(){

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(SQLHistoryPanel.this.view.getSQLHistoryTooltipValue(n, n2));
                }
                return component;
            }
        };
        this.sqlLimitLabel = new JLabel();
        this.sqlLimitTextField = new JTextField();
        this.sqlLimitButton = new JButton();
        this.inputWarningLabel = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Connection"));
        this.connectionComboBox.setRenderer(new ConnectionRenderer());
        this.jLabel2.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Match"));
        this.searchTextField.setMinimumSize(new Dimension(20, 22));
        this.insertSQLButton.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_Insert"));
        this.insertSQLButton.setFocusTraversalPolicyProvider(true);
        this.insertSQLButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLHistoryPanel.this.insertSQLButtonActionPerformed(actionEvent);
            }
        });
        this.sqlHistoryTable.setModel(new HistoryTableModel());
        this.sqlHistoryTable.setGridColor(Color.lightGray);
        this.sqlHistoryTable.setNextFocusableComponent(this.sqlLimitTextField);
        this.sqlHistoryTable.setSelectionBackground(UIManager.getDefaults().getColor("EditorPane.selectionBackground"));
        this.jScrollPane1.setViewportView(this.sqlHistoryTable);
        this.sqlHistoryTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_History"));
        this.sqlHistoryTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_History"));
        this.sqlLimitLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_SqlLimit"));
        this.sqlLimitTextField.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_InitialLimit"));
        this.sqlLimitTextField.setFocusTraversalPolicyProvider(true);
        this.sqlLimitTextField.setMinimumSize(new Dimension(18, 22));
        this.sqlLimitButton.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ApplyButton"));
        this.sqlLimitButton.setNextFocusableComponent(this.insertSQLButton);
        this.sqlLimitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLHistoryPanel.this.sqlLimitButtonActionPerformed(actionEvent);
            }
        });
        this.inputWarningLabel.setForeground(Color.red);
        this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_TextInputWarningLabel"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.connectionComboBox, 0, 208, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jLabel2).addPreferredGap(1).add((Component)this.searchTextField, -2, 147, -2)).add((Component)this.jScrollPane1, -1, 556, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.insertSQLButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sqlLimitLabel).addPreferredGap(0).add((Component)this.sqlLimitTextField, -2, 62, -2).addPreferredGap(0).add((Component)this.sqlLimitButton).add(18, 18, 18).add((Component)this.inputWarningLabel))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.searchTextField, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.connectionComboBox, -2, 27, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.insertSQLButton).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 185, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sqlLimitLabel).add((Component)this.sqlLimitTextField, -2, -1, -2).add((Component)this.sqlLimitButton).add((Component)this.inputWarningLabel)))).addContainerGap()));
        this.connectionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ASCN_ConnectionCombo"));
        this.connectionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_ConnectionCombo"));
        this.searchTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Match"));
        this.searchTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Match"));
        this.insertSQLButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Insert"));
        this.insertSQLButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Insert"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Save"));
        this.sqlLimitTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Save"));
        this.sqlLimitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSN_Apply"));
        this.sqlLimitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SQLHistoryPanel.class, (String)"ACSD_Apply"));
    }

    private void insertSQLButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.sqlHistoryTable.getSelectedRow();
        try {
            List<SQLHistory> list = this.view.getSQLHistoryList();
            int n2 = 0;
            String string = SAVE_STATEMENTS_CLEARED;
            for (SQLHistory sQLHistory : list) {
                if (n == n2) {
                    string = sQLHistory.getSql().trim();
                }
                ++n2;
            }
            new InsertSQLUtility().insert(string, this.editorPane);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private void sqlLimitButtonActionPerformed(ActionEvent actionEvent) {
        this.verifySQLLimit();
    }

    private void verifySQLLimit() {
        String string = this.sqlLimitTextField.getText();
        int n = 0;
        this.inputWarningLabel.setVisible(false);
        if (string.equals(SAVE_STATEMENTS_CLEARED)) {
            n = 10000;
            SQLHistoryPersistenceManager.getInstance().updateSQLSaved(n, Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(SQL_HISTORY_FOLDER));
            ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(null);
            NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", Integer.toString(n));
            this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
        } else {
            try {
                n = Integer.parseInt(string);
                String string2 = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
                if (n < 0 || n > 10000) {
                    this.sqlLimitButton.setEnabled(true);
                    this.inputWarningLabel.setVisible(true);
                    this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_NumberInputWarningLabel"));
                    if (string2 != null) {
                        this.sqlLimitTextField.setText(string2);
                    } else {
                        this.sqlLimitTextField.setText(SAVE_STATEMENTS_CLEARED);
                        this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
                    }
                } else {
                    SQLHistoryPersistenceManager.getInstance().updateSQLSaved(n, Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(SQL_HISTORY_FOLDER));
                    ((HistoryTableModel)this.sqlHistoryTable.getModel()).refreshTable(null);
                    NbPreferences.forModule(SQLHistoryPanel.class).put("SQL_STATEMENTS_SAVED_FOR_HISTORY", Integer.toString(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.inputWarningLabel.setVisible(true);
                this.inputWarningLabel.setText(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_TextInputWarningLabel"));
                String string3 = NbPreferences.forModule(SQLHistoryPanel.class).get("SQL_STATEMENTS_SAVED_FOR_HISTORY", SAVE_STATEMENTS_CLEARED);
                if (string3 != null) {
                    this.sqlLimitTextField.setText(string3);
                }
                this.sqlLimitTextField.setText(SAVE_STATEMENTS_MAX_LIMIT_ENTERED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Document document) throws InterruptedException, Exception {
        Renderer renderer = new Renderer(document);
        document.render(renderer);
        Renderer renderer2 = renderer;
        synchronized (renderer2) {
            while (!renderer.done) {
                renderer.wait();
                if (renderer.err == null) continue;
                throw new Exception(renderer.err);
            }
        }
        return renderer.result;
    }

    private static void adjustColumnPreferredWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            int n = 0;
            for (int j = 0; j < jTable.getRowCount(); ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                Object object = jTable.getValueAt(j, i);
                Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, j, i);
                n = Math.max(component.getPreferredSize().width, n);
            }
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n);
        }
    }

    static /* synthetic */ Object[][] access$1002(Object[][] objectArray) {
        data = objectArray;
        return objectArray;
    }

    private static final class ConnectionRenderer
    extends DefaultListCellRenderer {
        private ConnectionRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setToolTipText((String)object);
            return jLabel;
        }
    }

    private class InsertSQLUtility {
        public void insert(String string, JEditorPane jEditorPane) throws BadLocationException {
            this.insert(string, jEditorPane, false);
        }

        public void insert(String string, JEditorPane jEditorPane, boolean bl) throws BadLocationException {
            Document document;
            if (string == null) {
                string = SQLHistoryPanel.SAVE_STATEMENTS_CLEARED;
            }
            if ((document = jEditorPane.getDocument()) == null) {
                return;
            }
            if (document instanceof BaseDocument) {
                ((BaseDocument)document).atomicLock();
            }
            int n = this.insert(string, jEditorPane, document);
            if (document instanceof BaseDocument) {
                ((BaseDocument)document).atomicUnlock();
            }
        }

        private int insert(String string, JEditorPane jEditorPane, Document document) throws BadLocationException {
            int n = -1;
            try {
                Caret caret = jEditorPane.getCaret();
                int n2 = Math.min(caret.getDot(), caret.getMark());
                int n3 = Math.max(caret.getDot(), caret.getMark());
                document.remove(n2, n3 - n2);
                n = caret.getDot();
                document.insertString(n, string + ";", null);
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.WARNING, NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_InsertAtLocationError") + badLocationException);
            }
            return n;
        }
    }

    private static class Renderer
    implements Runnable {
        Document doc;
        String result;
        Throwable err;
        boolean done;

        Renderer(Document document) {
            this.doc = document;
        }

        public synchronized void run() {
            try {
                this.result = this.doc.getText(0, this.doc.getLength());
            }
            catch (Throwable throwable) {
                this.err = throwable;
                Exceptions.printStackTrace((Throwable)throwable);
            }
            this.done = true;
            this.notify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HistoryTableModel
    extends DefaultTableModel
    implements ActionListener,
    DocumentListener {
        List<String> sqlList;
        List<String> dateList;

        private HistoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return data.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object == null) {
                return String.class;
            }
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.adjustColumnPreferredWidths(SQLHistoryPanel.this.sqlHistoryTable);
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        public void adjustColumnPreferredWidths(JTable jTable) {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                int n = 0;
                for (int j = 0; j < jTable.getRowCount(); ++j) {
                    TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                    Object object = jTable.getValueAt(j, i);
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, j, i);
                    n = Math.max(component.getPreferredSize().width, n);
                }
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(n);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.refreshTable(actionEvent);
        }

        public void refreshTable(ActionEvent actionEvent) {
            String string;
            List<Object> list = new ArrayList();
            if (actionEvent != null) {
                string = ((JComboBox)actionEvent.getSource()).getSelectedItem().toString();
                list = SQLHistoryPanel.this.view.getSQLHistoryList();
            } else {
                string = SQLHistoryPanel.this.connectionComboBox.getSelectedItem().toString();
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(SQLHistoryPanel.SQL_HISTORY_FOLDER);
                String string2 = FileUtil.getFileDisplayName((FileObject)fileObject) + File.separator + SQLHistoryPanel.SQL_HISTORY_FILE_NAME + ".xml";
                try {
                    list = SQLHistoryPersistenceManager.getInstance().retrieve(string2, fileObject);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Exceptions.printStackTrace((Throwable)classNotFoundException);
                }
            }
            this.sqlList = new ArrayList<String>();
            this.dateList = new ArrayList<String>();
            SQLHistoryPanel.this.connectionComboBox.setToolTipText(string);
            boolean bl = false;
            for (SQLHistory iterator : list) {
                int n;
                if (string.equals(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem"))) {
                    n = iterator.getSql().trim().length();
                    int n2 = n > 125 ? 125 : n;
                    this.sqlList.add(iterator.getSql().trim().substring(0, n2));
                    this.dateList.add(DateFormat.getInstance().format(iterator.getDate()));
                    continue;
                }
                if (!string.equals(iterator.getUrl())) continue;
                n = iterator.getSql().trim().length();
                int n3 = n > 125 ? 125 : n;
                this.sqlList.add(iterator.getSql().trim().substring(0, n3));
                this.dateList.add(DateFormat.getInstance().format(iterator.getDate()));
            }
            SQLHistoryPanel.access$1002(null);
            SQLHistoryPanel.access$1002(new Object[this.sqlList.size()][2]);
            int n = 0;
            for (String string2 : this.sqlList) {
                int n4 = string2.trim().length();
                int n5 = n4 > 125 ? 125 : n4;
                data[n][0] = string2.trim().substring(0, n5);
                ++n;
            }
            n = 0;
            for (String string2 : this.dateList) {
                data[n++][1] = string2;
            }
            if (data.length >= 0) {
                SQLHistoryPanel.this.sqlHistoryTable.repaint();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            try {
                String string = SQLHistoryPanel.read(documentEvent.getDocument());
                Object[][] objectArray = new Object[this.sqlList.size()][2];
                int n = 0;
                Iterator<String> iterator = this.dateList.iterator();
                for (String string2 : this.sqlList) {
                    if (string2.trim().toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
                    int n2 = string2.trim().length();
                    int n3 = n2 > 125 ? 125 : n2;
                    objectArray[n][0] = string2.trim().substring(0, n3);
                    objectArray[n][1] = iterator.next();
                    ++n;
                }
                if (n > 0) {
                    SQLHistoryPanel.access$1002(new Object[n][2]);
                    for (int i = 0; i < n; ++i) {
                        data[i][0] = objectArray[i][0];
                        data[i][1] = objectArray[i][1];
                    }
                } else {
                    SQLHistoryPanel.access$1002(new Object[0][0]);
                }
                SQLHistoryPanel.this.sqlHistoryTable.repaint();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            try {
                String string = SQLHistoryPanel.read(documentEvent.getDocument());
                Object[][] objectArray = new Object[this.sqlList.size()][2];
                int n = 0;
                Iterator<String> iterator = this.dateList.iterator();
                for (String string2 : this.sqlList) {
                    if (string2.trim().toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
                    int n2 = string2.trim().length();
                    int n3 = n2 > 125 ? 125 : n2;
                    objectArray[n][0] = string2.trim().substring(0, n3);
                    objectArray[n][1] = iterator.next();
                    ++n;
                }
                if (n == 0) {
                    this.cleanTable();
                }
                if (n > 0) {
                    SQLHistoryPanel.access$1002(new Object[n][2]);
                    for (int i = 0; i < n; ++i) {
                        data[i][0] = objectArray[i][0];
                        data[i][1] = objectArray[i][1];
                    }
                } else {
                    SQLHistoryPanel.access$1002(new Object[0][0]);
                }
                SQLHistoryPanel.this.sqlHistoryTable.repaint();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void cleanTable() {
            List<SQLHistory> list = SQLHistoryPanel.this.view.getSQLHistoryList();
            SQLHistoryPanel.access$1002(null);
            SQLHistoryPanel.access$1002(new Object[list.size()][2]);
            SQLHistoryPanel.this.sqlHistoryTable.repaint();
        }
    }

    private final class UrlComboBoxModel
    implements ComboBoxModel,
    ActionListener {
        private UrlComboBoxModel() {
        }

        public void setSelectedItem(Object object) {
            SQLHistoryPanel.this.connectionComboBox.setSelectedItem(object);
        }

        public Object getSelectedItem() {
            return (String)SQLHistoryPanel.this.connectionComboBox.getSelectedItem();
        }

        public int getSize() {
            return SQLHistoryPanel.this.comboData.length;
        }

        public Object getElementAt(int n) {
            return SQLHistoryPanel.this.comboData[n];
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SQLHistoryView {
        private SQLHistoryModel model;
        List<SQLHistory> sqlHistoryList;
        public static final String MATCH_EMPTY = "";
        public static final String NO_MATCH = "";

        public SQLHistoryView(SQLHistoryModel sQLHistoryModel) {
            this.model = sQLHistoryModel;
            this.sqlHistoryList = sQLHistoryModel.getSQLHistoryList();
        }

        public List<SQLHistory> getSQLHistoryList() {
            return this.sqlHistoryList;
        }

        public String getSQLHistoryTooltipValue(int n, int n2) {
            List<SQLHistory> list = SQLHistoryPanel.this.view.filterSQLHistoryList();
            if (n < list.size()) {
                if (n2 == 0) {
                    String string = list.get(n).getSql().trim();
                    while (string.indexOf("\n") != -1) {
                        string = this.replace(string, "\n", "<br>");
                    }
                    return "<html>" + string + "</html>";
                }
                return DateFormat.getInstance().format(list.get(n).getDate());
            }
            return "";
        }

        public String replace(String string, String string2, String string3) {
            int n = string.indexOf(string2);
            if (n == -1) {
                return string;
            }
            int n2 = string2.length();
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n != -1) {
                stringBuffer.append(cArray, n3, n - n3);
                stringBuffer.append(string3);
                n3 = n + n2;
                n = string.indexOf(string2, n3);
            }
            stringBuffer.append(cArray, n3, cArray.length - n3);
            return stringBuffer.toString();
        }

        public List<String> getUrlList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SQLHistory sQLHistory : this.sqlHistoryList) {
                String string = sQLHistory.getUrl();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        public List<String> getSQLList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SQLHistory sQLHistory : this.sqlHistoryList) {
                String string = sQLHistory.getSql();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        public List<String> getDateList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (SQLHistory sQLHistory : this.sqlHistoryList) {
                String string = DateFormat.getInstance().format(sQLHistory.getDate());
                String string2 = sQLHistory.getSql();
                if (arrayList2.contains(string2)) continue;
                arrayList2.add(string2);
                arrayList.add(string);
            }
            return arrayList;
        }

        public void updateUrl() {
            SQLHistoryPanel.this.connectionComboBox.addItem(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_URLComboBoxAllConnectionsItem"));
            List<String> list = this.getUrlList();
            for (String string : list) {
                Object object = new Object();
                object = string;
                SQLHistoryPanel.this.connectionComboBox.addItem(object);
            }
        }

        private List<SQLHistory> filterSQLHistoryList() {
            ArrayList<SQLHistory> arrayList = new ArrayList<SQLHistory>();
            String string = SQLHistoryPanel.this.searchTextField.getText();
            String string2 = (String)SQLHistoryPanel.this.connectionComboBox.getSelectedItem();
            for (SQLHistory sQLHistory : this.sqlHistoryList) {
                if (!sQLHistory.getUrl().equals(string2) && !string2.equals(NbBundle.getMessage(SQLHistoryPanel.class, (String)"LBL_ConnectionCombo"))) continue;
                if (!string.equals("")) {
                    if (sQLHistory.getSql().toLowerCase().indexOf(string.toLowerCase()) == -1) continue;
                    arrayList.add(sQLHistory);
                    continue;
                }
                arrayList.add(sQLHistory);
            }
            return arrayList;
        }
    }
}

