/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.libraries.LibraryAccessor;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class AllLibrariesCustomizer
extends JPanel {
    private LibrariesCustomizer librariesCustomizer;
    private JLabel jLabel1;
    private JComboBox libraryManagerComboBox;
    private JPanel placeholder;

    public AllLibrariesCustomizer() {
        this.initComponents();
        this.librariesCustomizer = new LibrariesCustomizer(null);
        this.placeholder.add(this.librariesCustomizer);
        this.initModel();
    }

    public boolean apply() {
        return this.librariesCustomizer.apply();
    }

    private void initModel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NbBundle.getMessage(AllLibrariesCustomizer.class, (String)"LABEL_Global_Libraries"));
        for (LibraryManager libraryManager : LibraryManager.getOpenManagers()) {
            if (libraryManager.getLocation() == null) continue;
            arrayList.add(LibrariesSupport.convertURIToFilePath(URI.create(libraryManager.getLocation().toExternalForm())));
        }
        this.libraryManagerComboBox.setModel(new DefaultComboBoxModel<String>(arrayList.toArray(new String[arrayList.size()])));
    }

    private void initComponents() {
        this.libraryManagerComboBox = new JComboBox();
        this.placeholder = new JPanel();
        this.jLabel1 = new JLabel();
        this.libraryManagerComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AllLibrariesCustomizer.this.libraryManagerComboBoxActionPerformed(actionEvent);
            }
        });
        this.placeholder.setLayout(new BorderLayout());
        this.jLabel1.setText(MessageFormat.format(NbBundle.getMessage(AllLibrariesCustomizer.class, (String)"AllLibrariesCustomizer.jLabel1.text"), new Object[0]));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.placeholder, -1, 377, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.libraryManagerComboBox, 0, 289, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.libraryManagerComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.placeholder, -1, 230, Short.MAX_VALUE)));
    }

    private void libraryManagerComboBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.libraryManagerComboBox.getSelectedIndex();
        if (n == -1) {
            return;
        }
        if (n == 0) {
            this.librariesCustomizer.setLibraryStorageArea(null);
        } else if (n > 0) {
            URL uRL = null;
            try {
                uRL = new File((String)this.libraryManagerComboBox.getModel().getSelectedItem()).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            this.librariesCustomizer.setLibraryStorageArea(this.findLibraryStorageArea(uRL));
        }
    }

    private LibraryStorageArea findLibraryStorageArea(URL uRL) {
        for (ArealLibraryProvider arealLibraryProvider : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (LibraryStorageArea libraryStorageArea : LibraryAccessor.getOpenAreas(arealLibraryProvider)) {
                if (!uRL.equals(libraryStorageArea.getLocation())) continue;
                return libraryStorageArea;
            }
        }
        return null;
    }
}

