/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Node;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintSeverity;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.Rule;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.hints.StrictWarning;
import org.netbeans.modules.javascript.hints.infrastructure.JsAstRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsErrorRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsRuleContext;
import org.netbeans.modules.javascript.hints.infrastructure.JsSelectionRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsHintsProvider
implements HintsProvider {
    private boolean cancelled;

    public void computeErrors(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, List<Error> list2) {
        ParserResult parserResult = ruleContext.parserResult;
        if (parserResult == null) {
            return;
        }
        List list3 = parserResult.getDiagnostics();
        if (list3 == null || list3.size() == 0) {
            return;
        }
        this.cancelled = false;
        Map map = hintsManager.getErrors();
        if (map.isEmpty() || this.isCancelled()) {
            list2.addAll(list3);
            return;
        }
        for (Error error : list3) {
            if (this.applyErrorRules(hintsManager, ruleContext, error, map, list)) continue;
            list2.add(error);
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n, int n2) {
        this.cancelled = false;
        if (ruleContext.parserResult == null) {
            return;
        }
        Node node = AstUtilities.getRoot((ParserResult)ruleContext.parserResult);
        if (node == null) {
            return;
        }
        List list2 = hintsManager.getSelectionHints();
        if (list2.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        this.applySelectionRules(hintsManager, ruleContext, list2, list);
    }

    public void computeHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list) {
        this.cancelled = false;
        if (ruleContext.parserResult == null) {
            return;
        }
        Node node = AstUtilities.getRoot((ParserResult)ruleContext.parserResult);
        if (node == null) {
            return;
        }
        Map map = hintsManager.getHints(false, ruleContext);
        if (map.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        AstPath astPath = new AstPath();
        astPath.descend(node);
        this.applyHints(hintsManager, ruleContext, -1, node, astPath, map, list);
        this.scan(hintsManager, ruleContext, node, astPath, map, list);
        astPath.ascend();
    }

    public void computeSuggestions(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n) {
        Object object;
        List list2;
        this.cancelled = false;
        if (ruleContext.parserResult == null) {
            return;
        }
        Node node = AstUtilities.getRoot((ParserResult)ruleContext.parserResult);
        if (node == null) {
            return;
        }
        HashMap<Integer, List<JsAstRule>> hashMap = new HashMap<Integer, List<JsAstRule>>();
        hashMap.putAll(hintsManager.getHints(true, ruleContext));
        Set set = hintsManager.getSuggestions().entrySet();
        for (Map.Entry entry : set) {
            list2 = (List)hashMap.get(entry.getKey());
            if (list2 != null) {
                object = new LinkedList();
                object.addAll(list2);
                object.addAll((Collection)entry.getValue());
                hashMap.put((Integer)entry.getKey(), (List<JsAstRule>)object);
                continue;
            }
            hashMap.put((Integer)entry.getKey(), (List<JsAstRule>)entry.getValue());
        }
        if (hashMap.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        int n2 = AstUtilities.getAstOffset((CompilationInfo)compilationInfo, (int)n);
        list2 = new AstPath(node, n2);
        object = list2.leafToRoot();
        while (object.hasNext()) {
            if (this.isCancelled()) {
                return;
            }
            Node node2 = (Node)object.next();
            this.applyHints(hintsManager, ruleContext, node2.getType(), node2, (AstPath)list2, hashMap, list);
        }
    }

    private void applyHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, int n, Node node, AstPath astPath, Map<Integer, List<JsAstRule>> map, List<Hint> list) {
        List<JsAstRule> list2 = map.get(n);
        if (list2 != null) {
            JsRuleContext jsRuleContext = (JsRuleContext)ruleContext;
            jsRuleContext.node = node;
            jsRuleContext.path = astPath;
            for (JsAstRule jsAstRule : list2) {
                if (!hintsManager.isEnabled((Rule.UserConfigurableRule)jsAstRule)) continue;
                jsAstRule.run(jsRuleContext, list);
            }
        }
    }

    private boolean applyErrorRules(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, Error error, Map<String, List<JsErrorRule>> map, List<Hint> list) {
        List<JsErrorRule> list2;
        String string = error.getKey();
        if (string != null && (list2 = map.get(string)) != null) {
            int n = list.size();
            JsRuleContext jsRuleContext = (JsRuleContext)ruleContext;
            boolean bl = false;
            for (JsErrorRule jsErrorRule : list2) {
                if (!hintsManager.isEnabled((Rule.UserConfigurableRule)jsErrorRule)) {
                    bl = true;
                    continue;
                }
                if (!jsErrorRule.appliesTo(ruleContext)) continue;
                jsErrorRule.run(jsRuleContext, error, list);
            }
            return bl || n < list.size() || jsRuleContext.remove;
        }
        return false;
    }

    private void applySelectionRules(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<JsSelectionRule> list, List<Hint> list2) {
        for (JsSelectionRule jsSelectionRule : list) {
            if (!jsSelectionRule.appliesTo(ruleContext)) continue;
            jsSelectionRule.run(ruleContext, list2);
        }
    }

    private void scan(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, Node node, AstPath astPath, Map<Integer, List<JsAstRule>> map, List<Hint> list) {
        this.applyHints(hintsManager, ruleContext, node.getType(), node, astPath, map, list);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (this.isCancelled()) {
                return;
            }
            astPath.descend(node2);
            this.scan(hintsManager, ruleContext, node2, astPath, map, list);
            astPath.ascend();
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    private boolean isCancelled() {
        return this.cancelled;
    }

    public RuleContext createRuleContext() {
        return new JsRuleContext();
    }

    public List<Rule> getBuiltinRules() {
        ArrayList<Rule> arrayList = new ArrayList<Rule>(StrictWarning.KNOWN_STRICT_ERROR_KEYS.length);
        for (String string : StrictWarning.KNOWN_STRICT_ERROR_KEYS) {
            StrictWarning strictWarning = new StrictWarning(string);
            if ("msg.reserved.keyword".equals(string) || "msg.trailing.comma".equals(string)) {
                strictWarning.setDefaultSeverity(HintSeverity.ERROR);
            }
            arrayList.add((Rule)strictWarning);
        }
        return arrayList;
    }
}

