/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.configextension.redelivery.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoint;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.configextension.redelivery.properties.Endpoint;
import org.netbeans.modules.compapp.configextension.redelivery.properties.EndpointOperation;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public class RedirectTargetCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private CasaWrapperModel model;
    private JComboBox endpointComboBox;
    private JLabel endpointLabel;
    private JComboBox operationComboBox;
    private JLabel operationLabel;

    public RedirectTargetCustomEditor(CasaWrapperModel casaWrapperModel) {
        this.initComponents();
        this.model = casaWrapperModel;
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        List list = casaWrapperModel.getRootComponent().getEndpoints().getEndpoints();
        for (CasaEndpoint casaEndpoint : list) {
            Endpoint endpoint = new Endpoint(casaEndpoint.getServiceQName(), casaEndpoint.getEndpointName());
            arrayList.add(endpoint);
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray(new Object[0]));
        this.endpointComboBox.setModel(defaultComboBoxModel);
    }

    public void setValue(EndpointOperation endpointOperation) {
        Endpoint endpoint = endpointOperation.getEndpoint();
        String string = endpointOperation.getOperationName();
        this.endpointComboBox.setSelectedItem(endpoint);
        this.operationComboBox.setSelectedItem(string);
        this.endpointChanged(null);
    }

    private void initComponents() {
        this.endpointLabel = new JLabel();
        this.endpointComboBox = new JComboBox();
        this.operationLabel = new JLabel();
        this.operationComboBox = new JComboBox();
        this.endpointLabel.setText(NbBundle.getMessage(RedirectTargetCustomEditor.class, (String)"RedirectTargetCustomEditor.endpointLabel.text"));
        this.endpointComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RedirectTargetCustomEditor.this.endpointComboBoxItemStateChanged(itemEvent);
            }
        });
        this.endpointComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RedirectTargetCustomEditor.this.endpointChanged(actionEvent);
            }
        });
        this.operationLabel.setText(NbBundle.getMessage(RedirectTargetCustomEditor.class, (String)"RedirectTargetCustomEditor.operationLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.endpointLabel).add((Component)this.operationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.operationComboBox, 0, 461, Short.MAX_VALUE).add((Component)this.endpointComboBox, 0, 461, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.endpointLabel).add((Component)this.endpointComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.operationLabel).add((Component)this.operationComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void endpointChanged(ActionEvent actionEvent) {
        Endpoint endpoint = (Endpoint)this.endpointComboBox.getSelectedItem();
        if (endpoint == null) {
            this.operationLabel.setEnabled(false);
            this.operationComboBox.setEnabled(false);
        } else {
            this.operationLabel.setEnabled(true);
            this.operationComboBox.setEnabled(true);
            String string = endpoint.getEndpointName();
            List list = this.model.getRootComponent().getEndpoints().getEndpoints();
            QName qName = null;
            for (Object object : list) {
                String string2 = object.getEndpointName();
                if (!string.equals(string2)) continue;
                qName = object.getInterfaceQName();
                break;
            }
            if (qName != null) {
                ArrayList arrayList = new ArrayList();
                try {
                    Object object;
                    for (String string2 : this.model.getRootComponent().getPortTypes().getLinks()) {
                        String string3 = string2.getHref();
                        PortType portType = (PortType)this.model.getWSDLComponentFromXLinkHref(string3, PortType.class);
                        String string4 = portType.getName();
                        if (!string4.equals(qName.getLocalPart())) continue;
                        for (Operation operation : portType.getOperations()) {
                            arrayList.add(operation.getName());
                        }
                    }
                    object = new DefaultComboBoxModel<Object>(arrayList.toArray(new Object[0]));
                    this.operationComboBox.setModel(object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void endpointComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.endpointChanged(null);
    }

    public EndpointOperation getPropertyValue() throws IllegalStateException {
        Endpoint endpoint = (Endpoint)this.endpointComboBox.getSelectedItem();
        String string = (String)this.operationComboBox.getSelectedItem();
        return new EndpointOperation(endpoint, string);
    }

    public void validateValue() throws PropertyVetoException {
        Endpoint endpoint = (Endpoint)this.endpointComboBox.getSelectedItem();
        String string = (String)this.operationComboBox.getSelectedItem();
        if (endpoint == null) {
            throw new PropertyVetoException("An error endpoint must be selected.", null);
        }
        if (string == null) {
            throw new PropertyVetoException("An operation must be selected.", null);
        }
    }
}

