/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.openide.util.NbBundle;

public class IdentifierErrorProvider
extends CsmErrorProvider {
    private static final boolean ENABLED = IdentifierErrorProvider.getBoolean("cnd.identifier.error.provider", true);

    public void getErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        if (ENABLED && request.getFile().isParsed()) {
            CsmFileReferences.getDefault().accept((CsmScope)request.getFile(), (CsmFileReferences.Visitor)new ReferenceVisitor(request, response), CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE);
        }
        response.done();
    }

    private static boolean getBoolean(String string, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    private static class IdentifierErrorInfo
    implements CsmErrorInfo {
        private final int startOffset;
        private final int endOffset;
        private final String message;
        private final CsmErrorInfo.Severity severity;

        public IdentifierErrorInfo(int n, int n2, String string, CsmErrorInfo.Severity severity) {
            this.startOffset = n;
            this.endOffset = n2;
            this.message = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"HighlightProvider_IdentifierMissed", (Object)string);
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public CsmErrorInfo.Severity getSeverity() {
            return this.severity;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    private static class ReferenceVisitor
    implements CsmFileReferences.Visitor {
        private final CsmErrorProvider.Request request;
        private final CsmErrorProvider.Response response;

        public ReferenceVisitor(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
            this.request = request;
            this.response = response;
        }

        public void visit(CsmReference csmReference, CsmReference csmReference2, CsmReference csmReference3) {
            if (csmReference.getReferencedObject() == null) {
                CsmErrorInfo.Severity severity = CsmErrorInfo.Severity.ERROR;
                if (CsmFileReferences.isTemplateBased((CsmReference)csmReference, (CsmReference)csmReference2, (CsmReference)csmReference3) || CsmFileReferences.isMacroBased((CsmReference)csmReference, (CsmReference)csmReference2, (CsmReference)csmReference3)) {
                    severity = CsmErrorInfo.Severity.WARNING;
                }
                this.response.addError((CsmErrorInfo)new IdentifierErrorInfo(csmReference.getStartOffset(), csmReference.getEndOffset(), ((Object)csmReference.getText()).toString(), severity));
            }
        }
    }
}

