/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error.includes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.highlight.error.includes.ErrorFilesModel;
import org.netbeans.modules.cnd.highlight.error.includes.ErrorIncludesModel;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorIncludeDialog
extends JPanel
implements CsmModelListener {
    private static final boolean TRACE_ERROR_STATISTIC = Boolean.getBoolean("cnd.highlight.trace.statistic");
    private CsmProject baseProject;
    private Dialog parent;
    private ErrorIncludesModel model;
    private JList leftList;
    private JList rightList;
    private JTextArea guessList;
    private Map<String, List<String>> searchBase;
    private static final String CYG_DRIVE_UNIX = "/cygdrive/";
    private static final String CYG_DRIVE_WIN = "\\cygdrive\\";

    public ErrorIncludeDialog(Set<CsmFile> set) {
        ArrayList<CsmInclude> arrayList = new ArrayList<CsmInclude>();
        for (CsmFile csmFile : set) {
            boolean bl = false;
            for (CsmInclude csmInclude : csmFile.getIncludes()) {
                if (csmInclude.getIncludeFile() != null) continue;
                arrayList.add(csmInclude);
                bl = true;
            }
            if (this.baseProject == null) {
                this.baseProject = csmFile.getProject();
            }
            if (bl || !TRACE_ERROR_STATISTIC) continue;
            System.out.println("File marked as failed does not contain failed directives:");
            System.out.println("  " + csmFile.getAbsolutePath());
        }
        if (this.baseProject != null && TRACE_ERROR_STATISTIC) {
            this.checkHighlightModel(set);
        }
        this.createComponents(arrayList);
        this.setPreferredSize(new Dimension(500, 240));
        this.setMinimumSize(new Dimension(320, 240));
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getChangeFlags() == 4L && !hierarchyEvent.getChanged().isVisible()) {
                    ErrorIncludeDialog.this.leftList.setModel(new DefaultListModel());
                    ErrorIncludeDialog.this.rightList.setModel(new DefaultListModel());
                    ErrorIncludeDialog.this.model = null;
                    ErrorIncludeDialog.this.baseProject = null;
                    ErrorIncludeDialog.this.parent = null;
                    if (ErrorIncludeDialog.this.searchBase != null) {
                        ErrorIncludeDialog.this.searchBase.clear();
                    }
                    CsmListeners.getDefault().removeModelListener((CsmModelListener)ErrorIncludeDialog.this);
                }
            }
        });
    }

    public void projectOpened(CsmProject csmProject) {
    }

    public void projectClosed(CsmProject csmProject) {
        if (csmProject == this.baseProject && this.parent != null) {
            this.parent.setVisible(false);
        }
    }

    public void modelChanged(CsmChangeEvent csmChangeEvent) {
    }

    public static void showErrorIncludeDialog(Set<CsmFile> set) {
        ErrorIncludeDialog errorIncludeDialog = new ErrorIncludeDialog(set);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)errorIncludeDialog, ErrorIncludeDialog.i18n("ErrorIncludeDialog_Title"), false, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        errorIncludeDialog.parent = dialog;
        CsmListeners.getDefault().addModelListener((CsmModelListener)errorIncludeDialog);
    }

    private void createComponents(List<CsmInclude> list) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.createIncludesPane(), gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleName"));
        this.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescription"));
        this.model = new ErrorIncludesModel(list);
        this.leftList.setModel(this.model);
        this.addListeners();
        if (TRACE_ERROR_STATISTIC) {
            this.printStatistic();
        }
    }

    private void checkHighlightModel(Set<CsmFile> set) {
        boolean bl;
        CsmFile csmFile;
        CsmFile csmFile2;
        Iterator iterator = this.baseProject.getSourceFiles().iterator();
        while (iterator.hasNext()) {
            csmFile = csmFile2 = (CsmFile)iterator.next();
            bl = false;
            for (CsmInclude csmInclude : csmFile.getIncludes()) {
                if (csmInclude.getIncludeFile() != null) continue;
                bl = true;
            }
            if (bl) {
                if (set.contains(csmFile)) continue;
                System.out.println("Project source file is failed and not found in highlight");
                System.out.println("  " + csmFile.getAbsolutePath());
                continue;
            }
            if (!set.contains(csmFile)) continue;
            System.out.println("Project source file is not failed and found in highlight");
            System.out.println("  " + csmFile.getAbsolutePath());
        }
        iterator = this.baseProject.getHeaderFiles().iterator();
        while (iterator.hasNext()) {
            csmFile = csmFile2 = (CsmFile)iterator.next();
            bl = false;
            for (CsmInclude csmInclude : csmFile.getIncludes()) {
                if (csmInclude.getIncludeFile() != null) continue;
                bl = true;
            }
            if (bl) {
                if (set.contains(csmFile)) continue;
                System.out.println("Project header file is failed and not found in highlight");
                System.out.println("  " + csmFile.getAbsolutePath());
                continue;
            }
            if (!set.contains(csmFile)) continue;
            System.out.println("Project header file is not failed and found in highlight");
            System.out.println("  " + csmFile.getAbsolutePath());
        }
    }

    private void printStatistic() {
        if (this.baseProject != null) {
            Object object;
            boolean bl;
            Object object2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (CsmFile csmFile : this.baseProject.getSourceFiles()) {
                object2 = csmFile;
                ++n;
                bl = false;
                for (CsmInclude csmInclude : object2.getIncludes()) {
                    if (csmInclude.getIncludeFile() == null) {
                        ++n3;
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) continue;
                ++n4;
            }
            for (CsmFile csmFile : this.baseProject.getHeaderFiles()) {
                object2 = csmFile;
                ++n;
                bl = false;
                for (CsmInclude csmInclude : object2.getIncludes()) {
                    if (csmInclude.getIncludeFile() == null) {
                        ++n3;
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) continue;
                ++n4;
            }
            System.out.println("*Model #includes statistic*");
            System.out.println("  Amount of #includes:" + n2);
            System.out.println("  Failed    #includes:" + n3);
            System.out.println("  Amount     of files:" + n);
            System.out.println("  Failed        files:" + n4);
            if (n2 > 0) {
                double d = 100.0 * (double)(n2 - n3) / (double)n2;
                System.out.println("  Resolve #include Accuracy:" + d + "%");
                d = 100.0 * (double)(n - n4) / (double)n;
                System.out.println("  File-based       Accuracy:" + d + "%");
            }
            if ((object = this.baseProject.getPlatformProject()) instanceof NativeProject) {
                CsmFile csmFile;
                n = 0;
                csmFile = (NativeProject)object;
                for (NativeFileItem nativeFileItem : csmFile.getAllFiles()) {
                    if (nativeFileItem.isExcluded()) continue;
                    switch (nativeFileItem.getLanguage()) {
                        case C: 
                        case CPP: 
                        case C_HEADER: {
                            ++n;
                            break;
                        }
                    }
                }
                System.out.println("*Details for project statistic*");
                System.out.println("  Amount of native project files:" + n);
                System.out.println("  Failed   highlight   #includes:" + this.model.getFailedIncludesSize());
                System.out.println("  Failed   highlight      files:" + this.model.getFailedFilesSize());
            }
        }
    }

    private JComponent createIncludesPane() {
        this.leftList = new JList();
        this.leftList.setBorder(BorderFactory.createEmptyBorder());
        this.leftList.setSelectionMode(0);
        this.rightList = new JList();
        this.rightList.setBorder(BorderFactory.createEmptyBorder());
        this.rightList.setSelectionMode(0);
        this.guessList = new JTextArea();
        this.guessList.setEditable(false);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(0.35);
        jSplitPane.setResizeWeight(0.35);
        jSplitPane.setOneTouchExpandable(true);
        JScrollPane jScrollPane = new JScrollPane(this.leftList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setLabelFor(this.leftList);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)ErrorIncludeDialog.i18n("ErrorIncludeDialog_TitleInclides"));
        jLabel.setToolTipText(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameInclides"));
        jLabel.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameInclides"));
        jLabel.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescriptionInclides"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 6, 5, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 5, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jSplitPane.setLeftComponent(jPanel);
        JSplitPane jSplitPane2 = new JSplitPane(0);
        jSplitPane2.setDividerLocation(0.65);
        jSplitPane2.setResizeWeight(0.65);
        jSplitPane2.setOneTouchExpandable(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.rightList);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jLabel = new JLabel();
        jLabel.setLabelFor(this.rightList);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)ErrorIncludeDialog.i18n("ErrorIncludeDialog_TitleFiles"));
        jLabel.setToolTipText(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameFiles"));
        jLabel.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameFiles"));
        jLabel.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescriptionFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 6, 5, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 5, 5);
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        jSplitPane2.setTopComponent(jPanel);
        JScrollPane jScrollPane3 = new JScrollPane(this.guessList);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jLabel = new JLabel();
        jLabel.setLabelFor(this.guessList);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)ErrorIncludeDialog.i18n("ErrorIncludeDialog_TitleGuess"));
        jLabel.setToolTipText(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameGuess"));
        jLabel.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameGuess"));
        jLabel.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescriptionGuess"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 6, 5, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 5, 5);
        jPanel.add((Component)jScrollPane3, gridBagConstraints);
        jSplitPane2.setBottomComponent(jPanel);
        jSplitPane.setRightComponent(jSplitPane2);
        return jSplitPane;
    }

    private void addListeners() {
        this.leftList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = ErrorIncludeDialog.this.leftList.getSelectedIndex()) >= 0) {
                    List<CsmInclude> list = ErrorIncludeDialog.this.baseProject != null && ErrorIncludeDialog.this.baseProject.isValid() ? ErrorIncludeDialog.this.model.getElementList(n) : Collections.emptyList();
                    ErrorFilesModel errorFilesModel = new ErrorFilesModel(list);
                    ErrorIncludeDialog.this.rightList.setModel(errorFilesModel);
                    if (list.size() > 0) {
                        ErrorIncludeDialog.this.rightList.setSelectedIndex(0);
                        ErrorIncludeDialog.this.rightList.invalidate();
                        ErrorIncludeDialog.this.rightList.repaint();
                        CsmInclude csmInclude = errorFilesModel.getElementInclude(0);
                        ErrorIncludeDialog.this.guess(csmInclude, (String)ErrorIncludeDialog.this.model.getElementAt(n));
                    } else {
                        ErrorIncludeDialog.this.guessList.setText("");
                    }
                }
            }
        });
        this.leftList.setSelectedIndex(0);
        this.rightList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                    if (n >= 0 && ErrorIncludeDialog.this.baseProject != null && ErrorIncludeDialog.this.baseProject.isValid()) {
                        ErrorFilesModel errorFilesModel = (ErrorFilesModel)ErrorIncludeDialog.this.rightList.getModel();
                        CsmInclude csmInclude = errorFilesModel.getElementInclude(n);
                        ErrorIncludeDialog.this.guess(csmInclude, (String)ErrorIncludeDialog.this.model.getElementAt(ErrorIncludeDialog.this.leftList.getSelectedIndex()));
                    } else {
                        ErrorIncludeDialog.this.guessList.setText("");
                    }
                }
            }
        });
        this.leftList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (mouseEvent.getClickCount() == 2 && n >= 0) {
                    ErrorIncludeDialog.this.openElement(n);
                }
            }
        });
        this.leftList.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                int n = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (keyEvent.getModifiers() == 0 && keyEvent.getKeyCode() == 32 && n >= 0) {
                    ErrorIncludeDialog.this.openElement(n);
                }
            }
        });
        this.rightList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (mouseEvent.getClickCount() == 2 && n >= 0) {
                    ErrorIncludeDialog.this.openElement(n);
                }
            }
        });
        this.rightList.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                int n = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (keyEvent.getModifiers() == 0 && keyEvent.getKeyCode() == 32 && n >= 0) {
                    ErrorIncludeDialog.this.openElement(n);
                }
            }
        });
    }

    private void openElement(int n) {
        ErrorFilesModel errorFilesModel;
        CsmInclude csmInclude;
        if (this.baseProject != null && this.baseProject.isValid() && CsmKindUtilities.isOffsetable((Object)(csmInclude = (errorFilesModel = (ErrorFilesModel)this.rightList.getModel()).getElementInclude(n)))) {
            CsmUtilities.openSource((CsmObject)csmInclude);
        }
    }

    private void guess(CsmInclude csmInclude, String string) {
        List<String> list;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.searchBase == null) {
            this.searchBase = this.search(csmInclude);
        }
        string = string.replace("<", "");
        string = string.replace(">", "");
        string = string.replace("\"", "");
        if ((string = string.replace("\\", "/")).indexOf(47) >= 0) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        if ((list = this.searchBase.get(string)) != null) {
            for (String string2 : list) {
                stringBuilder.append(string2 + "\n");
            }
        }
        this.guessList.setText(stringBuilder.toString());
        this.getObjectFile(string, ((Object)csmInclude.getContainingFile().getAbsolutePath()).toString());
    }

    private void getObjectFile(String string, String string2) {
        List<String> list;
        String string3 = string2.replace("<", "");
        string3 = string3.replace(">", "");
        string3 = string3.replace("\"", "");
        if ((string3 = string3.replace("\\", "/")).indexOf(47) >= 0) {
            string3 = string3.substring(string3.lastIndexOf(47) + 1);
        }
        if (string3.lastIndexOf(46) > 0 && (list = this.searchBase.get(string3 = string3.substring(0, string3.lastIndexOf(46)) + ".o")) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : list) {
                stringBuilder.append(string4 + "\n");
                String string5 = this.trace(string, string4, string2);
                if (string5 == null) continue;
                stringBuilder.append(string5 + "\n");
            }
            this.guessList.setText(this.guessList.getText() + stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String trace(String string, String string2, String string3) {
        Dwarf dwarf = null;
        try {
            ArrayList arrayList;
            CompilationUnit compilationUnit;
            String string4;
            dwarf = new Dwarf(string2);
            List list = dwarf.getCompilationUnits();
            if (list.size() > 0 && string3.equals(string4 = this.getRightName((compilationUnit = (CompilationUnit)list.get(0)).getSourceFileAbsolutePath())) && (arrayList = compilationUnit.getStatementList().getPathsForFile(string)).size() > 0) {
                String string5 = this.getRightName(compilationUnit.getCompilationDir());
                String string6 = ErrorIncludeDialog.i18n("HeaderFromBinary");
                String string7 = MessageFormat.format(string6, string5, string4, arrayList.get(0));
                return string7;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (WrongFileFormatException wrongFileFormatException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
        }
        finally {
            if (dwarf != null) {
                dwarf.dispose();
            }
        }
        return null;
    }

    private String fixFileName(String string) {
        if (string != null && Utilities.isWindows()) {
            if (string.startsWith(CYG_DRIVE_UNIX)) {
                string = string.substring(CYG_DRIVE_UNIX.length());
                string = "" + Character.toUpperCase(string.charAt(0)) + ':' + string.substring(1);
            } else {
                int n = string.indexOf(CYG_DRIVE_WIN);
                if (n > 0) {
                    string = string.substring(n + CYG_DRIVE_UNIX.length());
                    string = "" + Character.toUpperCase(string.charAt(0)) + ':' + string.substring(1);
                }
            }
            string = string.replace('/', '\\');
        }
        return string;
    }

    private String getRightName(String string) {
        File file = new File(string);
        string = FileUtil.normalizeFile((File)file).getAbsolutePath();
        string = this.fixFileName(string);
        return string;
    }

    private Map<String, List<String>> search(CsmInclude csmInclude) {
        Object object;
        Object object22;
        CsmProject csmProject = csmInclude.getContainingFile().getProject();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object22 : csmProject.getSourceFiles()) {
            object = new File(((Object)object22.getAbsolutePath()).toString());
            hashSet.add(((File)object).getParentFile().getAbsolutePath());
        }
        for (Object object22 : csmProject.getHeaderFiles()) {
            object = new File(((Object)object22.getAbsolutePath()).toString());
            hashSet.add(((File)object).getParentFile().getAbsolutePath());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            object = new File((String)object22.next());
            this.gatherSubFolders((File)object, hashSet);
        }
        object22 = new HashMap();
        object = hashSet.iterator();
        while (object.hasNext()) {
            File file = new File((String)object.next());
            if (!file.isDirectory()) continue;
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile()) continue;
                ArrayList<String> arrayList2 = (ArrayList<String>)((HashMap)object22).get(fileArray[i].getName());
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>();
                    ((HashMap)object22).put(fileArray[i].getName(), arrayList2);
                }
                arrayList2.add(fileArray[i].getAbsolutePath());
            }
        }
        return object22;
    }

    private void gatherSubFolders(File file, HashSet<String> hashSet) {
        if (file.isDirectory()) {
            if (DiscoveryUtils.ignoreFolder((File)file)) {
                return;
            }
            String string = file.getAbsolutePath();
            if (!hashSet.contains(string)) {
                hashSet.add(file.getAbsolutePath());
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.gatherSubFolders(fileArray[i], hashSet);
                }
            }
        }
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(ErrorIncludeDialog.class, (String)string);
    }
}

