/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.lang.ref.WeakReference;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmFontColorManager;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

public abstract class HighlighterBase
implements CsmFileTaskFactory.PhaseRunner,
CsmFontColorManager.FontColorChangeListener {
    static final boolean MINIMAL = Boolean.getBoolean("cnd.highlighting.minimal");
    private final OffsetsBag bag;
    private final WeakReference<BaseDocument> weakDoc;

    public HighlighterBase(Document document) {
        this.bag = new OffsetsBag(document);
        this.weakDoc = document instanceof BaseDocument ? new WeakReference<BaseDocument>((BaseDocument)document) : null;
        String string = (String)document.getProperty("mimeType");
        CsmFontColorManager.instance().addListener(string, (CsmFontColorManager.FontColorChangeListener)this);
    }

    protected BaseDocument getDocument() {
        return this.weakDoc != null ? (BaseDocument)this.weakDoc.get() : null;
    }

    public OffsetsBag getHighlightsBag() {
        return this.bag;
    }

    public void stateChanged(FontColorProvider fontColorProvider) {
        this.updateFontColors(fontColorProvider);
        this.run(CsmFileTaskFactory.PhaseRunner.Phase.INIT);
    }

    protected abstract void updateFontColors(FontColorProvider var1);

    protected boolean isCancelled() {
        return Thread.interrupted();
    }
}

