/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CsmReference>[] getStorage(CsmFile csmFile, int n) {
        List[] listArray = (List[])Instantiator.map.get(csmFile);
        Map map = Instantiator.map;
        synchronized (map) {
            if (listArray == null || listArray[n] == null) {
                listArray = new List[Instantiator.validators.length];
                Instantiator.map.put(csmFile, listArray);
            }
        }
        return listArray;
    }

    private static List<CsmReference> getBlocksFromReferences(CsmFile csmFile, final Validator validator) {
        final ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

            public void visit(CsmReference csmReference, CsmReference csmReference2, CsmReference csmReference3) {
                if (validator.validate(csmReference)) {
                    arrayList.add(csmReference);
                }
            }
        });
        return arrayList;
    }

    private static List<CsmReference> getBlocksFromReferences2(final CsmFile csmFile, int n) {
        final List[] listArray = ModelUtils.getStorage(csmFile, n);
        if (listArray[n] == null) {
            for (int i = 0; i < Instantiator.validators.length; ++i) {
                listArray[i] = new ArrayList<CsmReference>();
            }
            CsmFileReferences.getDefault().accept((CsmScope)csmFile, new CsmFileReferences.Visitor(){

                public void visit(CsmReference csmReference, CsmReference csmReference2, CsmReference csmReference3) {
                    for (int i = 0; i < Instantiator.validators.length; ++i) {
                        if (!Instantiator.validators[i].validate(csmReference, csmFile)) continue;
                        listArray[i].add(csmReference);
                    }
                }
            });
        }
        List<CsmReference> list = listArray[n];
        listArray[n] = null;
        return list;
    }

    static List<? extends CsmOffsetable> getFieldsBlocks(CsmFile csmFile) {
        return ModelUtils.getBlocksFromReferences(csmFile, new Validator(){

            public boolean validate(CsmReference csmReference) {
                CsmObject csmObject = csmReference.getReferencedObject();
                return csmObject != null && CsmKindUtilities.isField((CsmObject)csmObject);
            }
        });
    }

    static List<CsmReference> getFunctionNames(final CsmFile csmFile) {
        return ModelUtils.getBlocksFromReferences(csmFile, new Validator(){

            public boolean validate(CsmReference csmReference) {
                CsmFunctionDefinition csmFunctionDefinition;
                CsmObject csmObject = csmReference.getReferencedObject();
                if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                    CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)csmObject;
                    if (csmOffsetableDeclaration.getContainingFile().equals(csmFile) && csmOffsetableDeclaration.getStartOffset() <= csmReference.getStartOffset() && csmOffsetableDeclaration.getEndOffset() >= csmReference.getEndOffset()) {
                        return true;
                    }
                    CsmFunctionDefinition csmFunctionDefinition2 = ((CsmFunction)csmObject).getDefinition();
                    if (csmFunctionDefinition2 != null && csmFile.equals(csmFunctionDefinition2.getContainingFile()) && csmFunctionDefinition2.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition2.getBody().getStartOffset()) {
                        return true;
                    }
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) && csmFile.equals((csmFunctionDefinition = (CsmFunctionDefinition)csmObject).getContainingFile()) && csmFunctionDefinition.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition.getBody().getStartOffset()) {
                    return true;
                }
                return false;
            }
        });
    }

    static List<CsmOffsetable> getInactiveCodeBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(csmFile);
    }

    static List<CsmReference> getMacroBlocks(CsmFile csmFile) {
        return CsmFileInfoQuery.getDefault().getMacroUsages(csmFile);
    }

    static List<? extends CsmOffsetable> getTypedefBlocks(CsmFile csmFile) {
        return ModelUtils.getBlocksFromReferences(csmFile, new Validator(){

            public boolean validate(CsmReference csmReference) {
                CsmObject csmObject = csmReference.getReferencedObject();
                return csmObject != null && CsmKindUtilities.isTypedef((CsmObject)csmObject);
            }
        });
    }

    private static class Instantiator {
        private static final Map<CsmFile, List<CsmReference>[]> map = new WeakHashMap<CsmFile, List<CsmReference>[]>();
        private static Validator2[] validators = new Validator2[]{new Validator2(){

            public boolean validate(CsmReference csmReference, CsmFile csmFile) {
                CsmObject csmObject = csmReference.getReferencedObject();
                return csmObject != null && CsmKindUtilities.isField((CsmObject)csmObject);
            }
        }, new Validator2(){

            public boolean validate(CsmReference csmReference, CsmFile csmFile) {
                CsmObject csmObject = csmReference.getReferencedObject();
                return csmObject != null && CsmKindUtilities.isTypedef((CsmObject)csmObject);
            }
        }, new Validator2(){

            public boolean validate(CsmReference csmReference, CsmFile csmFile) {
                CsmFunctionDefinition csmFunctionDefinition;
                CsmObject csmObject = csmReference.getReferencedObject();
                if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                    CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)csmObject;
                    if (csmOffsetableDeclaration.getContainingFile().equals(csmFile) && csmOffsetableDeclaration.getStartOffset() <= csmReference.getStartOffset() && csmOffsetableDeclaration.getEndOffset() >= csmReference.getEndOffset()) {
                        return true;
                    }
                    CsmFunctionDefinition csmFunctionDefinition2 = ((CsmFunction)csmObject).getDefinition();
                    if (csmFunctionDefinition2 != null && csmFile.equals(csmFunctionDefinition2.getContainingFile()) && csmFunctionDefinition2.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition2.getBody().getStartOffset()) {
                        return true;
                    }
                } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) && csmFile.equals((csmFunctionDefinition = (CsmFunctionDefinition)csmObject).getContainingFile()) && csmFunctionDefinition.getStartOffset() <= csmReference.getStartOffset() && csmReference.getStartOffset() <= csmFunctionDefinition.getBody().getStartOffset()) {
                    return true;
                }
                return false;
            }
        }};

        private Instantiator() {
        }
    }

    private static interface Validator2 {
        public boolean validate(CsmReference var1, CsmFile var2);
    }

    private static interface Validator {
        public boolean validate(CsmReference var1);
    }
}

