/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntitiesProvider;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.openide.util.NbBundle;

public class SemanticHighlightingOptionsPanel
extends JPanel
implements ActionListener {
    private boolean isChanged = false;
    private List<Entity> entities = new ArrayList<Entity>();
    JCheckBox cbMacros;
    private JCheckBox cbKeepMarks;
    private JCheckBox cbMarkOccurrences;
    private JPanel jPanel1;

    public SemanticHighlightingOptionsPanel() {
        this.initComponents();
        this.initGeneratedComponents();
        this.initMnemonics();
        this.cbKeepMarks.addActionListener(this);
        this.setName("TAB_SemanticHighlightingTab");
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.jPanel1.setOpaque(false);
            this.setOpaque(false);
        }
    }

    void applyChanges() {
        SemanticHighlightingOptions.instance().setEnableMarkOccurrences(this.cbMarkOccurrences.isSelected());
        SemanticHighlightingOptions.instance().setKeepMarks(this.cbKeepMarks.isSelected());
        for (Entity entity : this.entities) {
            SemanticHighlightingOptions.instance().setEnabled(entity.se.getName(), entity.cb.isSelected());
        }
        this.isChanged = false;
    }

    void update() {
        this.cbMarkOccurrences.setSelected(SemanticHighlightingOptions.instance().getEnableMarkOccurrences());
        this.cbKeepMarks.setSelected(SemanticHighlightingOptions.instance().getKeepMarks());
        for (Entity entity : this.entities) {
            entity.cb.setSelected(SemanticHighlightingOptions.instance().isEnabled(entity.se.getName()));
        }
        this.updateValidation();
    }

    void cancel() {
        this.isChanged = false;
    }

    boolean isChanged() {
        return this.isChanged;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.isChanged = true;
    }

    private void updateValidation() {
        this.cbKeepMarks.setEnabled(this.cbMarkOccurrences.isSelected());
    }

    private void initMnemonics() {
        this.cbMarkOccurrences.setMnemonic(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences_Mnemonic").charAt(0));
        this.cbKeepMarks.setMnemonic(SemanticHighlightingOptionsPanel.getString("KeepMarks_Mnemonic").charAt(0));
        this.cbMarkOccurrences.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences_AD"));
        this.cbKeepMarks.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("KeepMarks_AD"));
    }

    private void initGeneratedComponents() {
        JCheckBox jCheckBox;
        SemanticEntity semanticEntity2;
        for (SemanticEntity semanticEntity2 : SemanticEntitiesProvider.instance().get()) {
            jCheckBox = new JCheckBox();
            jCheckBox.setMnemonic(SemanticHighlightingOptionsPanel.getString("Show-" + semanticEntity2.getName() + "-mnemonic").charAt(0));
            jCheckBox.getAccessibleContext().setAccessibleDescription(SemanticHighlightingOptionsPanel.getString("Show-" + semanticEntity2.getName() + "-AD"));
            jCheckBox.setText(SemanticHighlightingOptionsPanel.getString("Show-" + semanticEntity2.getName()));
            jCheckBox.setOpaque(false);
            this.entities.add(new Entity(semanticEntity2, jCheckBox));
        }
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        semanticEntity2 = groupLayout.createParallelGroup(1);
        jCheckBox = groupLayout.createSequentialGroup();
        for (Entity entity : this.entities) {
            semanticEntity2.add(entity.cb);
            jCheckBox.addPreferredGap(0).add((Component)entity.cb);
        }
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)semanticEntity2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)jCheckBox.addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initComponents() {
        this.cbKeepMarks = new JCheckBox();
        this.cbMarkOccurrences = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.cbKeepMarks.setText(SemanticHighlightingOptionsPanel.getString("KeepMarks"));
        this.cbKeepMarks.setOpaque(false);
        this.cbMarkOccurrences.setText(SemanticHighlightingOptionsPanel.getString("EnableMarkOccurrences"));
        this.cbMarkOccurrences.setOpaque(false);
        this.cbMarkOccurrences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SemanticHighlightingOptionsPanel.this.cbMarkOccurrencesActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 398, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 214, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(29, 29, 29).add((Component)this.cbKeepMarks)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.cbMarkOccurrences)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.cbMarkOccurrences).addPreferredGap(0).add((Component)this.cbKeepMarks).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SemanticHighlightingOptionsPanel.class, (String)"SemanticHighlightingOptionsPanel_AN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SemanticHighlightingOptionsPanel.class, (String)"SemanticHighlightingOptionsPanel_AD"));
    }

    private void cbMarkOccurrencesActionPerformed(ActionEvent actionEvent) {
        this.updateValidation();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SemanticHighlightingOptionsPanel.class, (String)string);
    }

    private static class Entity {
        public final SemanticEntity se;
        public final JCheckBox cb;

        public Entity(SemanticEntity semanticEntity, JCheckBox jCheckBox) {
            this.se = semanticEntity;
            this.cb = jCheckBox;
        }
    }
}

