/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.FindPerformer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertiesTableCellEditor;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.PropertyPanel;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class BundleEditPanel
extends JPanel
implements PropertyChangeListener {
    private PropertiesDataObject obj;
    private DocumentListener listener;
    private static TableViewSettings settings;
    static final long serialVersionUID = -843810329041244483L;
    private Element.ItemElem lastSelectedBundleKey;
    private int lastSelectedColumn;
    private boolean selectionUpdateDisabled = false;
    private JButton addButton;
    private JCheckBox autoResizeCheck;
    private JPanel buttonPanel;
    private JLabel commentLabel;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton removeButton;
    private JScrollPane scrollPane;
    private JTable table;
    private JPanel tablePanel;
    private JTextArea textComment;
    private JTextArea textValue;
    private JLabel valueLabel;
    private JPanel valuePanel;

    public BundleEditPanel(final PropertiesDataObject propertiesDataObject, PropertiesTableModel propertiesTableModel) {
        this.obj = propertiesDataObject;
        this.initComponents();
        this.initAccessibility();
        this.initSettings();
        this.table.setColumnModel(new TableViewColumnModel());
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setDefaultRenderer(new TableViewHeaderRenderer(propertiesDataObject, jTableHeader.getDefaultRenderer()));
        this.table.setModel(propertiesTableModel);
        JTextField jTextField = new JTextField();
        jTextField.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        jTextField.setBorder(new LineBorder(Color.black));
        jTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BundleEditPanel.class).getString("ACSN_CellEditor"));
        jTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACSD_CellEditor"));
        this.listener = new ModifiedListener();
        this.table.setDefaultEditor(PropertiesTableModel.StringPair.class, new PropertiesTableCellEditor(jTextField, this.textComment, this.textValue, this.valueLabel, this.listener));
        this.table.setDefaultRenderer(PropertiesTableModel.StringPair.class, new TableViewRenderer());
        this.updateAddButton();
        this.table.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("tableCellEditor")) {
                    BundleEditPanel.this.updateEnabled();
                } else if (propertyChangeEvent.getPropertyName().equals("model")) {
                    BundleEditPanel.this.updateAddButton();
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = BundleEditPanel.this.table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (n < 0) {
                    return;
                }
                int n2 = tableColumnModel.getColumn(n).getModelIndex();
                if (n2 < 0) {
                    return;
                }
                propertiesDataObject.getBundleStructure().sort(n2);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                final boolean bl = !BundleEditPanel.this.selectionUpdateDisabled;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BundleEditPanel.this.updateSelection(bl);
                    }
                });
            }
        });
    }

    protected void stopEditing() {
        if (!this.table.isEditing()) {
            return;
        }
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private void updateEnabled() {
        this.textValue.setEditable(this.table.isEditing());
        this.textValue.setEnabled(this.table.isEditing());
        if (this.table.isEditing()) {
            PropertiesTableModel.StringPair stringPair = (PropertiesTableModel.StringPair)this.table.getCellEditor().getCellEditorValue();
            this.textComment.setEditable(stringPair.isCommentEditable());
            this.textComment.setEnabled(stringPair.isCommentEditable());
        } else {
            this.textComment.setEditable(false);
            this.textComment.setEnabled(false);
        }
    }

    private void updateSelection(boolean bl) {
        String string;
        String string2;
        Object object;
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (n == -1 && bl) {
            object = this.lastSelectedBundleKey;
            SwingUtilities.invokeLater(new Runnable((Element.ItemElem)object){
                final /* synthetic */ Element.ItemElem val$ex;
                {
                    this.val$ex = itemElem;
                }

                public void run() {
                    Object object;
                    int n;
                    if (this.val$ex == null) {
                        return;
                    }
                    String[] stringArray = BundleEditPanel.this.obj.getBundleStructure().getKeys();
                    for (n = 0; n < stringArray.length && !((String)(object = stringArray[n])).equals(this.val$ex.getKey()); ++n) {
                    }
                    if (n < stringArray.length) {
                        BundleEditPanel.this.table.requestFocusInWindow();
                        object = BundleEditPanel.this.table.getCellRect(n, 0, true);
                        BundleEditPanel.this.table.scrollRectToVisible((Rectangle)object);
                        BundleEditPanel.this.table.changeSelection(n, BundleEditPanel.this.lastSelectedColumn, false, false);
                    }
                }
            });
        }
        this.lastSelectedColumn = n2;
        object = this.obj.getBundleStructure();
        this.removeButton.setEnabled(n >= 0 && !((BundleStructure)object).isReadOnly());
        if (n2 == -1) {
            string2 = "";
            string = "";
            this.lastSelectedBundleKey = null;
        } else if (n2 == 0) {
            Element.ItemElem itemElem = ((BundleStructure)object).getItem(0, n);
            string2 = ((BundleStructure)object).keyAt(n);
            this.lastSelectedBundleKey = itemElem;
            string = itemElem != null ? itemElem.getComment() : "";
        } else {
            Element.ItemElem itemElem = ((BundleStructure)object).getItem(n2 - 1, n);
            if (itemElem != null) {
                string2 = itemElem.getValue();
                string = itemElem.getComment();
            } else {
                string2 = "";
                string = "";
            }
            this.lastSelectedBundleKey = itemElem;
        }
        this.textValue.getDocument().removeDocumentListener(this.listener);
        this.textComment.getDocument().removeDocumentListener(this.listener);
        this.textValue.setText(string2);
        this.textComment.setText(string);
        this.textValue.getDocument().addDocumentListener(this.listener);
        this.textComment.getDocument().addDocumentListener(this.listener);
    }

    private void updateAddButton() {
        this.addButton.setEnabled(!this.obj.getBundleStructure().isReadOnly());
    }

    public JTable getTable() {
        return this.table;
    }

    private void initSettings() {
        settings = TableViewSettings.getDefault();
        settings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)settings));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_BundleEditPanel"));
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BundleEditPanel.class).getString("ACSN_CTL_Table"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACSD_CTL_Table"));
        this.textValue.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_CTL_TEXTVALUE"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_LBL_AddPropertyButton"));
        this.textComment.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_CTL_TEXTCOMMENT"));
        this.autoResizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_CTL_AutoResize"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BundleEditPanel.class).getString("ACS_LBL_RemovePropertyButton"));
    }

    public boolean requestFocusInWindow() {
        return this.table.requestFocusInWindow();
    }

    private void initComponents() {
        this.tablePanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new BundleTable();
        this.valuePanel = new JPanel();
        this.commentLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textComment = new JTextArea();
        this.valueLabel = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.textValue = new JTextArea();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.autoResizeCheck = new JCheckBox();
        this.setFocusCycleRoot(true);
        this.setLayout(new GridBagLayout());
        this.tablePanel.setLayout(new GridBagLayout());
        this.table.setCellSelectionEnabled(true);
        this.scrollPane.setViewportView(this.table);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.tablePanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tablePanel, gridBagConstraints);
        this.valuePanel.setLayout(new GridBagLayout());
        this.commentLabel.setLabelFor(this.textComment);
        Mnemonics.setLocalizedText((JLabel)this.commentLabel, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_CommentLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.commentLabel, gridBagConstraints);
        this.textComment.setEditable(false);
        this.textComment.setLineWrap(true);
        this.textComment.setRows(3);
        this.textComment.setEnabled(false);
        this.jScrollPane2.setViewportView(this.textComment);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.valuePanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.valueLabel.setLabelFor(this.textValue);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_ValueLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 11, 11, 0);
        this.valuePanel.add((Component)this.valueLabel, gridBagConstraints);
        this.textValue.setEditable(false);
        this.textValue.setLineWrap(true);
        this.textValue.setRows(3);
        this.textValue.setEnabled(false);
        this.jScrollPane3.setViewportView(this.textValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 11, 11, 0);
        this.valuePanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.valuePanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_AddPropertyButton"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleEditPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(BundleEditPanel.class).getString("LBL_RemovePropertyButton"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleEditPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 11, 11, 11);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.autoResizeCheck.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoResizeCheck, (String)NbBundle.getBundle(BundleEditPanel.class).getString("CTL_AutoResize"));
        this.autoResizeCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleEditPanel.this.autoResizeCheckActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.buttonPanel.add((Component)this.autoResizeCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void autoResizeCheckActionPerformed(ActionEvent actionEvent) {
        if (this.autoResizeCheck.isSelected()) {
            this.table.setAutoResizeMode(4);
        } else {
            this.table.setAutoResizeMode(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        this.stopEditing();
        String string = ((PropertiesTableModel.StringPair)this.table.getModel().getValueAt(n, 0)).getValue();
        if (string == null) {
            return;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getBundle(BundleEditPanel.class).getString("MSG_DeleteKeyQuestion"), string), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.OK_OPTION)) {
            try {
                this.obj.getOpenSupport().atomicUndoRedoFlag = new Object();
                for (int i = 0; i < this.obj.getBundleStructure().getEntryCount(); ++i) {
                    PropertiesStructure propertiesStructure;
                    PropertiesFileEntry propertiesFileEntry = this.obj.getBundleStructure().getNthEntry(i);
                    if (propertiesFileEntry == null || (propertiesStructure = propertiesFileEntry.getHandler().getStructure()) == null) continue;
                    propertiesStructure.deleteItem(string);
                }
            }
            finally {
                this.obj.getOpenSupport().atomicUndoRedoFlag = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.stopEditing();
        PropertyPanel propertyPanel = new PropertyPanel();
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)propertyPanel, NbBundle.getMessage(BundleEditPanel.class, (String)"CTL_NewPropertyTitle")));
        if (object != NotifyDescriptor.OK_OPTION) {
            return;
        }
        final String string = propertyPanel.getKey();
        String string2 = propertyPanel.getValue();
        String string3 = propertyPanel.getComment();
        boolean bl = false;
        try {
            this.selectionUpdateDisabled = true;
            this.obj.getOpenSupport().atomicUndoRedoFlag = new Object();
            for (int i = 0; i < this.obj.getBundleStructure().getEntryCount(); ++i) {
                PropertiesFileEntry propertiesFileEntry = this.obj.getBundleStructure().getNthEntry(i);
                if (propertiesFileEntry != null && !propertiesFileEntry.getHandler().getStructure().addItem(string, string2, string3)) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(BundleEditPanel.class).getString("MSG_KeyExists"), string, Util.getLocaleLabel((MultiDataObject.Entry)propertiesFileEntry)), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    continue;
                }
                bl = true;
            }
        }
        finally {
            this.obj.getOpenSupport().atomicUndoRedoFlag = null;
            this.selectionUpdateDisabled = false;
        }
        if (bl) {
            PropertiesRequestProcessor.getInstance().post(new Runnable(){

                public void run() {
                    int n = BundleEditPanel.this.obj.getBundleStructure().getKeyIndexByName(string);
                    if (n != -1) {
                        final int n2 = n;
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    Rectangle rectangle;
                                    BundleEditPanel.this.selectionUpdateDisabled = true;
                                    if (BundleEditPanel.this.table.getAutoscrolls() && (rectangle = BundleEditPanel.this.table.getCellRect(n2, 1, false)) != null) {
                                        BundleEditPanel.this.table.scrollRectToVisible(rectangle);
                                    }
                                    BundleEditPanel.this.table.getColumnModel().getSelectionModel().setSelectionInterval(1, 1);
                                    BundleEditPanel.this.table.getSelectionModel().setSelectionInterval(n2, n2);
                                    BundleEditPanel.this.table.requestFocusInWindow();
                                    BundleEditPanel.this.table.editCellAt(n2, 1);
                                }
                                finally {
                                    BundleEditPanel.this.selectionUpdateDisabled = false;
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private class ModifiedListener
    implements DocumentListener {
        private ModifiedListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentModified();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentModified();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentModified();
        }

        private void documentModified() {
            BundleEditPanel.this.obj.setModified(true);
        }
    }

    static class BundleTable
    extends JTable {
        public BundleTable() {
            this.setRowHeight(this.getCellFontHeight() + 1);
        }

        public void removeEditorSilent() {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.removeCellEditorListener(this);
                if (this.editorComp != null) {
                    this.remove(this.editorComp);
                }
                Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(rectangle);
            }
        }

        private int getCellFontHeight() {
            FontMetrics fontMetrics;
            Font font = UIManager.getFont("TextField.font");
            if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
                return fontMetrics.getHeight();
            }
            return 14;
        }
    }

    private class TableViewRenderer
    extends DefaultTableCellRenderer {
        private TableViewRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            PropertiesTableModel.StringPair stringPair = (PropertiesTableModel.StringPair)object;
            this.setFont(settings.getFont());
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            String string = null;
            if (stringPair.getValue() != null) {
                string = stringPair.getValue();
            }
            if (BasicHTML.isHTMLString(string)) {
                string = " " + string;
            }
            this.setValue(string == null ? "" : string);
            if (stringPair.isKeyType()) {
                this.setBackground(settings.getKeyBackground());
            } else if (stringPair.getValue() != null) {
                this.setBackground(settings.getValueBackground());
            } else {
                this.setBackground(settings.getShadowColor());
            }
            if (stringPair.isKeyType()) {
                this.setForeground(settings.getKeyColor());
            } else {
                this.setForeground(settings.getValueColor());
            }
            Color color = this.getBackground();
            boolean bl3 = color != null && color.equals(jTable.getBackground()) && jTable.isOpaque();
            this.setOpaque(!bl3);
            return this;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (FindPerformer.getFindPerformer(BundleEditPanel.this.table).isHighlightSearch()) {
                String string = this.getText();
                String string2 = FindPerformer.getFindPerformer(BundleEditPanel.this.table).getFindString();
                if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                    int n = 0;
                    int n2 = (int)graphics.getFontMetrics().getStringBounds(string2, graphics).getWidth();
                    Color color = graphics.getColor();
                    while ((n = string.indexOf(string2, n)) >= 0) {
                        int n3 = (int)graphics.getFontMetrics().getStringBounds(string.substring(0, n), graphics).getWidth() + this.getInsets().left;
                        graphics.setColor(settings.getHighlightBackground());
                        graphics.fillRect(n3, 0, n2, graphics.getClipBounds().height);
                        graphics.setColor(settings.getHighlightColor());
                        graphics.drawString(string2, n3, -((int)graphics.getFontMetrics().getStringBounds(string2, graphics).getY()));
                        n += string2.length();
                    }
                    graphics.setColor(color);
                }
            }
        }
    }

    private class TableViewColumnModel
    extends DefaultTableColumnModel {
        private AncestorListener ancestorListener;

        private TableViewColumnModel() {
        }

        public void addColumn(TableColumn tableColumn) {
            if (tableColumn == null) {
                throw new IllegalArgumentException("Object is null");
            }
            this.tableColumns.addElement(tableColumn);
            tableColumn.addPropertyChangeListener(this);
            this.adjustColumnWidths();
            this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
        }

        private void adjustColumnWidths() {
            int n;
            Rectangle rectangle = Utilities.getUsableScreenBounds();
            int n2 = rectangle.width / 10;
            int n3 = 0;
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, BundleEditPanel.this.table);
            if (topComponent != null) {
                n3 = topComponent.getBounds().width;
            } else if (this.ancestorListener == null) {
                this.ancestorListener = new AncestorListener(){

                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        if (ancestorEvent.getAncestor() instanceof TopComponent) {
                            TableViewColumnModel.this.adjustColumnWidths();
                            BundleEditPanel.this.table.removeAncestorListener(TableViewColumnModel.this.ancestorListener);
                            TableViewColumnModel.this.ancestorListener = null;
                        }
                    }

                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }

                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }
                };
                BundleEditPanel.this.table.addAncestorListener(this.ancestorListener);
            }
            int n4 = 0;
            if ((n3 -= ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().left + ((BundleEditPanel)BundleEditPanel.this).scrollPane.getInsets().right + 12 + 11) > 0 && (n = n3 / BundleEditPanel.this.table.getColumnCount()) > n2) {
                n2 = n - BundleEditPanel.this.table.getColumnModel().getColumnMargin();
                n4 = n3 % BundleEditPanel.this.table.getColumnCount();
            }
            for (n = 0; n < BundleEditPanel.this.table.getColumnCount(); ++n) {
                TableColumn tableColumn = BundleEditPanel.this.table.getColumnModel().getColumn(n);
                if (n == 0) {
                    tableColumn.setPreferredWidth(n2 + n4);
                    tableColumn.setWidth(n2 + n4);
                    continue;
                }
                tableColumn.setPreferredWidth(n2);
                tableColumn.setWidth(n2);
            }
            this.recalcWidthCache();
            BundleEditPanel.this.table.revalidate();
            BundleEditPanel.this.table.getTableHeader().repaint();
        }
    }

    private static final class TableViewHeaderRenderer
    implements TableCellRenderer {
        private static final String ICON_PKG = "org/netbeans/modules/properties/";
        private static final String SORT_ASC_ICON = "org/netbeans/modules/properties/columnSortedAsc.gif";
        private static final String SORT_DESC_ICON = "org/netbeans/modules/properties/columnSortedDesc.gif";
        private final PropertiesDataObject propDataObj;
        private final TableCellRenderer origRenderer;
        private ImageIcon iconSortAsc;
        private ImageIcon iconSortDesc;

        TableViewHeaderRenderer(PropertiesDataObject propertiesDataObject, TableCellRenderer tableCellRenderer) {
            this.propDataObj = propertiesDataObject;
            this.origRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.origRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                BundleStructure bundleStructure = this.propDataObj.getBundleStructure();
                int n3 = jTable.convertColumnIndexToView(bundleStructure.getSortIndex());
                if (n2 == n3) {
                    boolean bl3 = bundleStructure.getSortOrder();
                    jLabel.setIcon(this.getSortIcon(bl3));
                    jLabel.setHorizontalTextPosition(2);
                } else {
                    jLabel.setIcon(null);
                }
            }
            return component;
        }

        private ImageIcon getSortIcon(boolean bl) {
            if (bl) {
                if (this.iconSortAsc == null) {
                    this.iconSortAsc = new ImageIcon(Utilities.loadImage((String)SORT_ASC_ICON));
                }
                return this.iconSortAsc;
            }
            if (this.iconSortDesc == null) {
                this.iconSortDesc = new ImageIcon(Utilities.loadImage((String)SORT_DESC_ICON));
            }
            return this.iconSortDesc;
        }
    }
}

