/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.bracesmatching.support;

import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

final class CharacterMatcher
implements BracesMatcher {
    private static final Logger LOG = Logger.getLogger(CharacterMatcher.class.getName());
    private final MatcherContext context;
    private final char[] matchingPairs;
    private final int lowerBound;
    private final int upperBound;
    private int originOffset;
    private char originalChar;
    private char matchingChar;
    private boolean backward;

    public CharacterMatcher(MatcherContext matcherContext, int n, int n2, char ... cArray) {
        this.context = matcherContext;
        this.lowerBound = n == -1 ? Integer.MIN_VALUE : n;
        int n3 = this.upperBound = n2 == -1 ? Integer.MAX_VALUE : n2;
        assert (cArray.length % 2 == 0) : "The matchingPairs parameter must contain even number of characters.";
        this.matchingPairs = cArray;
    }

    public int[] findOrigin() throws BadLocationException {
        int[] nArray = BracesMatcherSupport.findChar(this.context.getDocument(), this.context.getSearchOffset(), this.context.isSearchingBackward() ? Math.max(this.context.getLimitOffset(), this.lowerBound) : Math.min(this.context.getLimitOffset(), this.upperBound), this.matchingPairs);
        if (nArray != null) {
            this.originOffset = nArray[0];
            this.originalChar = this.matchingPairs[nArray[1]];
            this.matchingChar = this.matchingPairs[nArray[1] + nArray[2]];
            this.backward = nArray[2] < 0;
            return new int[]{this.originOffset, this.originOffset + 1};
        }
        return null;
    }

    public int[] findMatches() throws BadLocationException {
        int[] nArray;
        int n = BracesMatcherSupport.matchChar(this.context.getDocument(), this.backward ? this.originOffset : this.originOffset + 1, this.backward ? Math.max(0, this.lowerBound) : Math.min(this.context.getDocument().getLength(), this.upperBound), this.originalChar, this.matchingChar);
        if (n != -1) {
            int[] nArray2 = new int[2];
            nArray2[0] = n;
            nArray = nArray2;
            nArray2[1] = n + 1;
        } else {
            nArray = null;
        }
        return nArray;
    }
}

