/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.attach;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class URLAttachPanel
extends JPanel
implements Controller {
    private static Preferences preferences = NbPreferences.forModule(URLAttachPanel.class);
    private static final String DEBUG_URL = "debugURL";
    private static final String BROWSER = "browser";
    private final boolean ieBrowserSupported;
    private final boolean ffBrowserSupported;
    private ButtonGroup browserButtonGroup;
    private JLabel debugURLLabel;
    private JTextField debugURLTextField;
    private JRadioButton firefoxRadioButton;
    private JRadioButton internetExplorerRadioButton;
    private JTextField messageTextField;

    public URLAttachPanel() {
        this.initComponents();
        this.debugURLTextField.setText(preferences.get(DEBUG_URL, ""));
        this.debugURLTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void update() {
                URLAttachPanel.this.firePropertyChange("valid", null, null);
                URLAttachPanel.this.messageTextField.setText("");
            }
        });
        this.ieBrowserSupported = WebClientToolsProjectUtils.isInternetExplorerSupported();
        this.ffBrowserSupported = WebClientToolsProjectUtils.isFirefoxSupported();
        if (this.ieBrowserSupported && this.ffBrowserSupported) {
            String string = preferences.get(BROWSER, WebClientToolsProjectUtils.Browser.FIREFOX.name());
            this.firefoxRadioButton.setSelected(WebClientToolsProjectUtils.Browser.valueOf((String)string) == WebClientToolsProjectUtils.Browser.FIREFOX);
            this.internetExplorerRadioButton.setSelected(WebClientToolsProjectUtils.Browser.valueOf((String)string) == WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER);
        } else if (!this.ieBrowserSupported && !this.ffBrowserSupported) {
            this.debugURLTextField.setEnabled(false);
            this.debugURLTextField.setEditable(false);
            this.firefoxRadioButton.setEnabled(false);
            this.internetExplorerRadioButton.setEnabled(false);
            this.messageTextField.setText(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel_noSupportedBrowserMsg"));
        } else {
            this.firefoxRadioButton.setEnabled(this.ffBrowserSupported);
            this.firefoxRadioButton.setSelected(this.ffBrowserSupported);
            this.internetExplorerRadioButton.setEnabled(this.ieBrowserSupported);
            this.internetExplorerRadioButton.setSelected(this.ieBrowserSupported);
        }
    }

    private void initComponents() {
        this.browserButtonGroup = new ButtonGroup();
        this.debugURLLabel = new JLabel();
        this.debugURLTextField = new JTextField();
        this.firefoxRadioButton = new JRadioButton();
        this.internetExplorerRadioButton = new JRadioButton();
        this.messageTextField = new JTextField();
        this.debugURLLabel.setLabelFor(this.debugURLTextField);
        Mnemonics.setLocalizedText((JLabel)this.debugURLLabel, (String)NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.debugURLLabel.text"));
        this.browserButtonGroup.add(this.firefoxRadioButton);
        this.firefoxRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.firefoxRadioButton, (String)NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.firefoxRadioButton.text"));
        this.browserButtonGroup.add(this.internetExplorerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.internetExplorerRadioButton, (String)NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.internetExplorerRadioButton.text"));
        this.internetExplorerRadioButton.setToolTipText(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.internetExplorerRadioButton.tooltip"));
        this.messageTextField.setBackground(UIManager.getColor("Panel.background"));
        this.messageTextField.setEditable(false);
        this.messageTextField.setBorder(null);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.messageTextField, -1, 384, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debugURLLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.internetExplorerRadioButton).add((Component)this.firefoxRadioButton).add((Component)this.debugURLTextField, -1, 292, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.debugURLLabel).add((Component)this.debugURLTextField, -2, -1, -2)).addPreferredGap(1).add((Component)this.firefoxRadioButton).addPreferredGap(1).add((Component)this.internetExplorerRadioButton).addPreferredGap(1).add((Component)this.messageTextField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.debugURLTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.debugURLTextField.AccessibleContext.accessibleName"));
        this.debugURLTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.debugURLTextField.AccessibleContext.accessibleDescription"));
        this.firefoxRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLAttachPanel.class, (String)"URLAttachPanel.firefoxRadioButton.AccessibleContext.accessibleDescription"));
    }

    public boolean isValid() {
        return this.ieBrowserSupported || this.ffBrowserSupported;
    }

    public boolean ok() {
        preferences.put(DEBUG_URL, this.debugURLTextField.getText());
        if (Utilities.isWindows() && this.internetExplorerRadioButton.isSelected()) {
            preferences.put(BROWSER, WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name());
        } else {
            preferences.put(BROWSER, WebClientToolsProjectUtils.Browser.FIREFOX.name());
        }
        if (WebClientToolsSessionStarterService.isAvailable()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    block7: {
                        try {
                            URI uRI = new URI(URLAttachPanel.this.debugURLTextField.getText().trim());
                            try {
                                HtmlBrowser.Factory factory = null;
                                factory = URLAttachPanel.this.internetExplorerRadioButton.isSelected() ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
                                if (factory == null) {
                                    try {
                                        HtmlBrowser.URLDisplayer.getDefault().showURL(uRI.toURL());
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        URLAttachPanel.this.messageTextField.setText(malformedURLException.getMessage());
                                    }
                                    break block7;
                                }
                                WebClientToolsSessionStarterService.startSession((URI)uRI, (HtmlBrowser.Factory)factory, (Lookup)Lookup.EMPTY);
                            }
                            catch (WebClientToolsSessionException webClientToolsSessionException) {
                                StatusDisplayer.getDefault().setStatusText(webClientToolsSessionException.getMessage());
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            URLAttachPanel.this.messageTextField.setText(uRISyntaxException.getMessage());
                        }
                    }
                }
            });
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    private static HtmlBrowser.Factory getHtmlBrowserFactory() {
        Collection collection = Lookup.getDefault().lookupAll(HtmlBrowser.Factory.class);
        for (HtmlBrowser.Factory factory : collection) {
            if (!factory.getClass().getName().equals("org.netbeans.modules.extbrowser.FirefoxBrowser")) continue;
            return factory;
        }
        return (HtmlBrowser.Factory)collection.iterator().next();
    }
}

