/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.filesystem;

import java.awt.Image;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLContentProvider;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObject;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLRootFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class URLFileSystem
extends FileSystem {
    private static final long serialVersionUID = 281881787206L;
    static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    static final String HTML_MIMETYPE = "text/html";
    static final String CSS_MIMETYPE = "text/x-css";
    private URLRootFileObject root;
    private final FileSystem.Status displayStatus = new URLStatus();
    private String sessionId = NbBundle.getMessage(URLFileSystem.class, (String)"DEFAULT_FS_DISPLAY_NAME");
    private transient WeakReference<URLContentProvider> contentProvider;

    public URLContentProvider getContentProvider() {
        return this.contentProvider != null ? (URLContentProvider)this.contentProvider.get() : null;
    }

    public void setContentProvider(URLContentProvider uRLContentProvider) {
        this.contentProvider = new WeakReference<URLContentProvider>(uRLContentProvider);
    }

    public URLFileObject initialize(URL uRL) {
        this.root = new URLRootFileObject(this);
        URLFileObject uRLFileObject = new URLFileObject(uRL, this, this.root);
        this.root.addChild(uRLFileObject);
        return uRLFileObject;
    }

    public URLFileObject addURL(URL uRL) {
        if (this.root == null) {
            return this.initialize(uRL);
        }
        URLFileObject uRLFileObject = new URLFileObject(uRL, this, this.root);
        if (this.root.getFileObject(uRLFileObject.getPath()) == null) {
            this.root.addChild(uRLFileObject);
            return uRLFileObject;
        }
        throw new IllegalArgumentException(uRL.toExternalForm() + " is already in URLFileSystem");
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getDisplayName() {
        return this.sessionId;
    }

    public boolean isReadOnly() {
        return true;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public FileObject findResource(String string) {
        if (this.root != null) {
            return this.root.getFileObject(string);
        }
        return null;
    }

    public FileSystem.Status getStatus() {
        return this.displayStatus;
    }

    public SystemAction[] getActions() {
        return new SystemAction[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class URLStatus
    implements FileSystem.Status,
    Serializable {
        private static final long serialVersionUID = 620102785902L;
        private static Image JAVASCRIPT_IMAGE = new ImageIcon(URLFileSystem.class.getResource("javascript.png")).getImage();
        private static Image HTML_IMAGE = new ImageIcon(URLFileSystem.class.getResource("html.png")).getImage();

        private URLStatus() {
        }

        public String annotateName(String string, Set<? extends FileObject> set) {
            for (FileObject fileObject : set) {
                URLFileObject uRLFileObject;
                URL uRL;
                if (!(fileObject instanceof URLFileObject) || (uRL = (uRLFileObject = (URLFileObject)fileObject).getSourceURL()) == null || !uRLFileObject.getNameExt().equals(string)) continue;
                String string2 = uRL.getProtocol() + "://.../" + string;
                return string2;
            }
            return string;
        }

        public Image annotateIcon(Image image, int n, Set<? extends FileObject> set) {
            for (FileObject fileObject : set) {
                if (!(fileObject instanceof URLFileObject)) continue;
                URLFileObject uRLFileObject = (URLFileObject)fileObject;
                String string = uRLFileObject.getMIMEType();
                if (URLFileSystem.JAVASCRIPT_MIMETYPE.equals(string)) {
                    return JAVASCRIPT_IMAGE;
                }
                if (!URLFileSystem.HTML_MIMETYPE.equals(string)) continue;
                return HTML_IMAGE;
            }
            return image;
        }
    }
}

