/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.http.ui;

import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class HttpMonitorPreferences {
    public static final String PROP_FILTER_HTML = "Filter_HTML";
    public static final String PROP_FILTER_JS = "Filter_JS";
    public static final String PROP_FILTER_IMAGES = "Filter_Images";
    public static final String PROP_FILTER_CSS = "Filter_CSS";
    public static final String PROP_FILTER_XHR = "Filter_XHR";
    public static final String PROP_FILTER_FLASH = "Filter_FLASH";
    public static final String PROP_METHOD_COLUMN_WIDTH = "Method_Column_Width";
    private static boolean SHOW_HTML_DEFAULT = true;
    private static boolean SHOW_JS_DEFAULT = true;
    private static boolean SHOW_IMAGES_DEFAULT = true;
    private static boolean SHOW_CSS_DEFAULT = true;
    private static boolean SHOW_XHR_DEFAULT = true;
    private static boolean SHOW_FLASH_DEFAULT = true;
    private static int DEFAULT_METHOD_COLUMN_WIDTH = 4;
    private static HttpMonitorPreferences INSTANCE = null;

    public static HttpMonitorPreferences getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HttpMonitorPreferences();
        }
        return INSTANCE;
    }

    public static boolean isPreference(String string) {
        if (string == null) {
            return false;
        }
        return PROP_FILTER_HTML.equals(string) || PROP_FILTER_JS.equals(string) || PROP_FILTER_IMAGES.equals(string) || PROP_FILTER_CSS.equals(string) || PROP_FILTER_XHR.equals(string) || PROP_FILTER_FLASH.equals(string);
    }

    public int getMethodColumnWidth() {
        return this.getPreferences().getInt(PROP_METHOD_COLUMN_WIDTH, DEFAULT_METHOD_COLUMN_WIDTH);
    }

    public void setMethodColumnWidth(int n) {
        this.getPreferences().putInt(PROP_METHOD_COLUMN_WIDTH, n);
    }

    public boolean isShowHTML() {
        return this.getPreferences().getBoolean(PROP_FILTER_HTML, SHOW_HTML_DEFAULT);
    }

    public void setShowHTML(boolean bl) {
        this.getPreferences().putBoolean(PROP_FILTER_HTML, bl);
    }

    public boolean isShowJS() {
        return this.getPreferences().getBoolean(PROP_FILTER_JS, SHOW_JS_DEFAULT);
    }

    public void setShowJS(boolean bl) {
        this.getPreferences().putBoolean(PROP_FILTER_JS, bl);
    }

    public boolean isShowImages() {
        return this.getPreferences().getBoolean(PROP_FILTER_IMAGES, SHOW_IMAGES_DEFAULT);
    }

    public void setShowImages(boolean bl) {
        this.getPreferences().putBoolean(PROP_FILTER_IMAGES, bl);
    }

    public boolean isShowCSS() {
        return this.getPreferences().getBoolean(PROP_FILTER_CSS, SHOW_CSS_DEFAULT);
    }

    public void setShowCSS(boolean bl) {
        this.getPreferences().putBoolean(PROP_FILTER_CSS, bl);
    }

    public boolean isShowXHR() {
        return this.getPreferences().getBoolean(PROP_FILTER_XHR, SHOW_XHR_DEFAULT);
    }

    public void setShowXHR(boolean bl) {
        this.getPreferences().putBoolean(PROP_FILTER_XHR, bl);
    }

    public boolean isShowFlash() {
        return this.getPreferences().getBoolean(PROP_FILTER_FLASH, SHOW_FLASH_DEFAULT);
    }

    public void setShowFlash(boolean bl) {
        this.getPreferences().putBoolean(PROP_FILTER_FLASH, bl);
    }

    public boolean isShowAll() {
        return this.isShowFlash() && this.isShowXHR() && this.isShowCSS() && this.isShowImages() && this.isShowJS() && this.isShowHTML();
    }

    public void setShowAll(boolean bl) {
        this.setShowFlash(bl);
        this.setShowXHR(bl);
        this.setShowCSS(bl);
        this.setShowImages(bl);
        this.setShowJS(bl);
        this.setShowHTML(bl);
    }

    public void addPreferencesChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.getPreferences().addPreferenceChangeListener(preferenceChangeListener);
    }

    public void removePreferencesChangeListener(PreferenceChangeListener preferenceChangeListener) {
        this.getPreferences().removePreferenceChangeListener(preferenceChangeListener);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(HttpMonitorPreferences.class);
    }
}

