/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.http.ui;

import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpActivitiesModel;
import org.netbeans.modules.web.client.javascript.debugger.http.ui.models.HttpActivitiesWrapper;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSPreferences;

public class HttpMonitorUtility {
    private static final NbJSPreferences NbJSPREF = NbJSPreferences.getInstance();

    public static boolean isEnabled() {
        return NbJSPREF.getHttpMonitorEnabled();
    }

    public static void setEnabled(boolean bl) {
        NbJSPREF.setHttpMonitorEnabled(bl);
    }

    public static void setHttpMonitorOpened(boolean bl) {
        NbJSPREF.setHttpMonitorOpened(bl);
    }

    public static Session getCurrentSession() {
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        if (sessionArray.length > 0) {
            for (Session session : sessionArray) {
                if (!HttpMonitorUtility.isJSDebuggerSession(session)) continue;
                return session;
            }
        }
        return null;
    }

    public static boolean isJSDebuggerSession(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        return debuggerEngine.lookupFirst(null, NbJSDebugger.class) != null;
    }

    public static HttpActivitiesModel getCurrentHttpMonitorModel() {
        HttpActivitiesWrapper httpActivitiesWrapper;
        Session session = HttpMonitorUtility.getCurrentSession();
        if (session != null && (httpActivitiesWrapper = (HttpActivitiesWrapper)session.lookupFirst(null, HttpActivitiesWrapper.class)) != null) {
            return httpActivitiesWrapper.getModel();
        }
        return null;
    }
}

