/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSContextProviderWrapper;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSSource;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSWindow;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class NbJSThreadsModel
implements TreeModel,
TableModel,
NodeModel,
NodeActionsProvider,
JSDebuggerEventListener {
    private static final String WINDOW = "org/netbeans/modules/web/client/javascript/debugger/ui/resources/window";
    private static final String FRAME = "org/netbeans/modules/web/client/javascript/debugger/ui/resources/frame";
    private NbJSContextProviderWrapper contextProvider;
    private final NbJSDebugger debugger;
    private JSWindow[] windows;
    private final List<ModelListener> listeners;
    private PropertyChangeListener propertyChangeListener;
    private final Action GO_TO_ACTION;

    public NbJSThreadsModel(ContextProvider contextProvider) {
        this.contextProvider = NbJSContextProviderWrapper.getContextProviderWrapper(contextProvider);
        this.debugger = this.contextProvider.getNbJSDebugger();
        this.debugger.addJSDebuggerEventListener((JSDebuggerEventListener)WeakListeners.create(JSDebuggerEventListener.class, (EventListener)((Object)this), (Object)this.debugger));
        this.GO_TO_ACTION = NbJSEditorUtil.createDebuggerGoToAction(this.debugger);
        this.propertyChangeListener = new PropertyChangeListenerImpl();
        this.debugger.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)this.debugger));
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
        this.windows = this.debugger.getWindows();
    }

    private void setWindows(JSWindow[] jSWindowArray) {
        this.windows = jSWindowArray;
        this.fireChanges();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            if (this.windows != null) {
                return this.windows;
            }
            return new Object[0];
        }
        if (object instanceof JSWindow) {
            JSWindow[] jSWindowArray = ((JSWindow)object).getChildren();
            return jSWindowArray == null || jSWindowArray.length == 0 ? JSWindow.EMPTY_ARRAY : jSWindowArray;
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof JSWindow) {
            JSWindow[] jSWindowArray = ((JSWindow)object).getChildren();
            return jSWindowArray == null || jSWindowArray.length == 0;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            int n = 0;
            if (this.windows != null) {
                n += this.windows.length;
            }
            return n;
        }
        if (object instanceof JSWindow) {
            JSWindow[] jSWindowArray = ((JSWindow)object).getChildren();
            return jSWindowArray == null ? 0 : jSWindowArray.length;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(NbJSThreadsModel.class, (String)"CTL_ThreadsModel.Column.Name.Name");
        }
        if (object instanceof JSWindow) {
            JSWindow jSWindow = (JSWindow)object;
            String string = NbJSThreadsModel.getWindowName(jSWindow);
            return jSWindow.isSuspended() ? "<html><b>" + string + "</b></html>" : string;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return WINDOW;
        }
        if (object instanceof JSWindow) {
            JSWindow jSWindow = (JSWindow)object;
            if (jSWindow.getParent() == null) {
                return WINDOW;
            }
            return FRAME;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(NbJSThreadsModel.class, (String)"CTL_ThreadsModel.Column.Name.Desc");
        }
        if (object instanceof JSWindow) {
            return this.getDisplayName(object);
        }
        throw new UnknownTypeException(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof JSWindow) {
            if ("ThreadState".equals(string)) {
                return this.debugger.getState();
            }
            if ("ThreadSuspended".equals(string)) {
                if (this.debugger.getState().getState().equals((Object)JSDebuggerState.State.SUSPENDED)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object instanceof JSWindow) {
            JSWindow jSWindow = (JSWindow)object;
            String string = jSWindow.getURI();
            JSSource jSSource = JSFactory.createJSSource((String)string);
            NbJSEditorUtil.openFileObject(this.debugger.getFileObjectForSource(jSSource));
        }
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object instanceof JSWindow) {
            return new Action[]{this.GO_TO_ACTION};
        }
        return new Action[0];
    }

    private static final String getWindowName(JSWindow jSWindow) {
        return (jSWindow.getParent() == null ? "Window - " : "Frame - ") + jSWindow.getURI();
    }

    public void onDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
        JSDebuggerState jSDebuggerState = jSDebuggerEvent.getDebuggerState();
        NbJSDebugger nbJSDebugger = (NbJSDebugger)jSDebuggerEvent.getSource();
        switch (jSDebuggerState.getState()) {
            case DISCONNECTED: {
                nbJSDebugger.removeJSDebuggerEventListener(this);
                break;
            }
        }
        this.fireChanges();
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("windows")) {
                NbJSThreadsModel.this.setWindows((JSWindow[])propertyChangeEvent.getNewValue());
            }
        }
    }
}

