/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.io.File;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObject;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSDebuggerAnnotation;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointNodeActions;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSURIBreakpoint;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSSource;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSWindow;
import org.netbeans.modules.web.client.tools.javascript.debugger.impl.JSFactory;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.Models;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public final class NbJSEditorUtil {
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    private static NbJSDebuggerAnnotation currentLineDA;
    public static final String BREAKPOINT_ANNOTATION_TYPE;
    public static final String DISABLED_BREAKPOINT_ANNOTATION_TYPE;
    public static final String CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE;
    public static final String DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE;
    public static final String CURRENT_LINE_ANNOTATION_TYPE;
    public static final String CALL_STACK_FRAME_ANNOTATION_TYPE;
    public static final String PROP_LINE_NUMBER;

    public static String getAnnotationTooltip(String string) {
        return NbJSEditorUtil.getMessage("TOOLTIP_" + string);
    }

    private static String getMessage(String string) {
        return NbBundle.getBundle(NbJSEditorUtil.class).getString(string);
    }

    static void markCurrent(String string, int n) {
        NbJSEditorUtil.markCurrent(NbJSEditorUtil.getLineAnnotable(string, n));
    }

    private static void markCurrent(Line line) {
        NbJSEditorUtil.unmarkCurrent();
        if (line == null) {
            return;
        }
        currentLineDA = new NbJSDebuggerAnnotation(CURRENT_LINE_ANNOTATION_TYPE, (Annotatable)line);
        NbJSEditorUtil.showLine(line, true);
    }

    static void unmarkCurrent() {
        if (currentLineDA != null) {
            currentLineDA.detach();
            currentLineDA = null;
        }
    }

    public static void openFileObject(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            editorCookie.open();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
    }

    public static Line getLineAnnotable(String string, int n) {
        Line line = NbJSEditorUtil.getLine(string, n);
        return line;
    }

    public static Line getLine(String string, int n) {
        if (string == null || n < 0) {
            return null;
        }
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            NbJSUtil.info("Cannot resolve \"" + string + '\"');
            return null;
        }
        LineCookie lineCookie = NbJSEditorUtil.getLineCookie(fileObject);
        assert (lineCookie != null);
        return lineCookie.getLineSet().getCurrent(n);
    }

    public static Line getLine(FileObject fileObject, int n) {
        Line.Set set;
        LineCookie lineCookie;
        if (fileObject != null && (lineCookie = NbJSEditorUtil.getLineCookie(fileObject)) != null && (set = lineCookie.getLineSet()) != null) {
            return set.getCurrent(n - 1);
        }
        return null;
    }

    public static Line getLine(NbJSDebugger nbJSDebugger, JSCallStackFrame jSCallStackFrame) {
        JSLocation jSLocation = jSCallStackFrame.getLocation();
        JSSource jSSource = JSFactory.createJSSource((String)jSLocation.getURI().toString());
        FileObject fileObject = nbJSDebugger.getFileObjectForSource(jSSource);
        return NbJSEditorUtil.getLine(fileObject, jSCallStackFrame.getLineNumber());
    }

    public static LineCookie getLineCookie(FileObject fileObject) {
        LineCookie lineCookie = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null) {
                lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            NbJSUtil.LOGGER.log(Level.FINE, "Cannot find DataObject for: " + fileObject, dataObjectNotFoundException.getMessage());
        }
        return lineCookie;
    }

    public static void showLine(final Line line, final boolean bl) {
        if (line == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                line.show(bl ? 3 : 2);
            }
        });
    }

    public static void showLine(Line line) {
        NbJSEditorUtil.showLine(line, false);
    }

    public static Line getCurrentLine() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fileObject == null) {
            return null;
        }
        if (!NbJSEditorUtil.isJavascriptSource(fileObject) && !NbJSEditorUtil.isHTMLSource(fileObject)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    public static boolean isHTMLSource(FileObject fileObject) {
        return HTML_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static boolean isJavascriptSource(FileObject fileObject) {
        return JAVASCRIPT_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static final void goToSource(FileObject fileObject, int n) {
        Line line = NbJSEditorUtil.getLine(fileObject.getPath(), n - 1);
        NbJSEditorUtil.showLine(line);
    }

    public static final Action createDebuggerGoToAction(final NbJSDebugger nbJSDebugger) {
        Models.ActionPerformer actionPerformer = new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                JSCallStackFrame jSCallStackFrame;
                JSLocation jSLocation;
                FileObject fileObject;
                Object object = objectArray[0];
                if (object instanceof JSWindow) {
                    JSWindow jSWindow = (JSWindow)object;
                    String string = jSWindow.getURI();
                    JSSource jSSource = JSFactory.createJSSource((String)string);
                    NbJSEditorUtil.openFileObject(nbJSDebugger.getFileObjectForSource(jSSource));
                } else if (object instanceof JSSource) {
                    JSSource jSSource = (JSSource)object;
                    FileObject fileObject2 = nbJSDebugger.getFileObjectForSource(jSSource);
                    NbJSEditorUtil.openFileObject(fileObject2);
                } else if (object instanceof JSCallStackFrame && (fileObject = nbJSDebugger.getFileObjectForSource(JSFactory.createJSSource((String)(jSLocation = (jSCallStackFrame = (JSCallStackFrame)object).getLocation()).getURI().toString()))) != null) {
                    NbJSEditorUtil.showLine(NbJSEditorUtil.getLine(fileObject, jSLocation.getLineNumber()), true);
                }
            }
        };
        return Models.createAction((String)NbBundle.getMessage(NbJSBreakpointNodeActions.class, (String)"CTL_GoToSource"), (Models.ActionPerformer)actionPerformer, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    public static final Action createDebuggerGoToClientSourceAction(final NbJSDebugger nbJSDebugger) {
        Models.ActionPerformer actionPerformer = new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                Object object = objectArray[0];
                if (object instanceof JSSource) {
                    JSSource jSSource = (JSSource)object;
                    FileObject fileObject = nbJSDebugger.getFileObjectForSource(jSSource);
                    if (!(fileObject instanceof URLFileObject)) {
                        fileObject = nbJSDebugger.getURLFileObjectForSource(jSSource);
                    }
                    NbJSEditorUtil.openFileObject(fileObject);
                }
            }
        };
        return Models.createAction((String)NbBundle.getMessage(NbJSEditorUtil.class, (String)"CTL_GoToClientSource"), (Models.ActionPerformer)actionPerformer, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    public static final Action createGoToAction() {
        Models.ActionPerformer actionPerformer = new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] objectArray) {
                Object object = objectArray[0];
                if (object instanceof NbJSBreakpoint) {
                    NbJSBreakpoint nbJSBreakpoint = (NbJSBreakpoint)((Object)object);
                    Line line = nbJSBreakpoint.getLine();
                    if (line != null) {
                        NbJSEditorUtil.showLine(line, true);
                    } else {
                        assert (nbJSBreakpoint instanceof NbJSURIBreakpoint);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor(null, "Can't open without a Client-Side Debugger Session Running.");
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                        dialog.setVisible(true);
                    }
                }
            }
        };
        return Models.createAction((String)NbBundle.getMessage(NbJSBreakpointNodeActions.class, (String)"CTL_GoToSource"), (Models.ActionPerformer)actionPerformer, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static {
        BREAKPOINT_ANNOTATION_TYPE = new String("Breakpoint");
        DISABLED_BREAKPOINT_ANNOTATION_TYPE = new String("DisabledBreakpoint");
        CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = new String("CondBreakpoint");
        DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = new String("DisabledCondBreakpoint");
        CURRENT_LINE_ANNOTATION_TYPE = new String("CurrentPC");
        CALL_STACK_FRAME_ANNOTATION_TYPE = new String("CallSite");
        PROP_LINE_NUMBER = new String("lineNumber");
    }
}

