/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSContextProviderWrapper;
import org.netbeans.modules.web.client.tools.api.JSAbstractLocation;
import org.netbeans.modules.web.client.tools.api.JSLocation;
import org.netbeans.modules.web.client.tools.api.NbJSLocation;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public abstract class NbJSBreakpoint
extends Breakpoint {
    protected PROP_SUSPEND_STATE suspend = PROP_SUSPEND_STATE.SUSPEND;
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_UPDATED = "updated";
    public static final String PROP_PRINT_TEXT = "printText";
    private boolean enabled;
    private String condition = "";
    private String printText;
    private JSAbstractLocation location;

    public NbJSBreakpoint(JSAbstractLocation jSAbstractLocation) {
        assert (jSAbstractLocation != null);
        this.location = jSAbstractLocation;
        this.enabled = true;
    }

    public void notifyUpdated(Object object) {
        NbJSContextProviderWrapper.getBreakpointModel().fireChanges();
        this.firePropertyChange(PROP_UPDATED, null, null);
    }

    public void notifyUpdated(String string, Object object, Object object2) {
        NbJSContextProviderWrapper.getBreakpointModel().fireChanges();
        this.firePropertyChange(string, object, object2);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            this.firePropertyChange("enabled", true, false);
        }
    }

    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.firePropertyChange("enabled", false, true);
        }
    }

    public abstract FileObject getFileObject();

    public abstract int getLineNumber();

    public abstract Line getLine();

    public abstract void setLine(Line var1);

    public String toString() {
        return this.getLocation().getDisplayName();
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String string) {
        String string2;
        NbJSBreakpoint nbJSBreakpoint = this;
        synchronized (nbJSBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()) == this.condition || string != null && this.condition != null && this.condition.equals(string)) {
                return;
            }
            string2 = this.condition;
            this.condition = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String string) {
        if (this.printText == string) {
            return;
        }
        String string2 = this.printText;
        this.printText = string;
        this.firePropertyChange(PROP_PRINT_TEXT, string2, string);
    }

    public PROP_SUSPEND_STATE getSuspend() {
        return this.suspend;
    }

    public void setSuspend(PROP_SUSPEND_STATE pROP_SUSPEND_STATE) {
        if (pROP_SUSPEND_STATE == this.suspend) {
            return;
        }
        PROP_SUSPEND_STATE pROP_SUSPEND_STATE2 = this.suspend;
        this.suspend = pROP_SUSPEND_STATE;
        this.firePropertyChange(PROP_SUSPEND, (Object)pROP_SUSPEND_STATE2, (Object)pROP_SUSPEND_STATE);
    }

    public JSAbstractLocation getLocation() {
        return this.location;
    }

    public void setLocation(JSAbstractLocation jSAbstractLocation) {
        JSAbstractLocation jSAbstractLocation2 = this.location;
        this.location = jSAbstractLocation;
        this.firePropertyChange("lineNumber", jSAbstractLocation2, jSAbstractLocation);
    }

    public String getDisplayName() {
        return this.getLocation().getDisplayName();
    }

    public boolean isResolved() {
        return this.getLocation().getJSLocation() != null;
    }

    public String getResolvedLocation() {
        NbJSToJSLocationMapper nbJSToJSLocationMapper;
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session != null && (nbJSToJSLocationMapper = (NbJSToJSLocationMapper)session.lookupFirst(null, NbJSToJSLocationMapper.class)) != null) {
            JSAbstractLocation jSAbstractLocation = this.getLocation();
            JSLocation jSLocation = null;
            if (jSAbstractLocation instanceof NbJSLocation) {
                jSLocation = nbJSToJSLocationMapper.getJSLocation((NbJSLocation)jSAbstractLocation, null);
            } else if (jSAbstractLocation instanceof JSLocation) {
                jSLocation = (JSLocation)jSAbstractLocation;
            }
            if (jSLocation != null) {
                return jSLocation.getDisplayName();
            }
        }
        return "";
    }

    public int getResolvedLineNumber() {
        JSLocation jSLocation = this.getLocation().getJSLocation();
        if (jSLocation == null) {
            return -1;
        }
        return jSLocation.getLineNumber();
    }

    public boolean isConditional() {
        return this.getCondition() != null ? this.getCondition().length() > 0 || this.getHitCountFilter() > 0 : false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PROP_SUSPEND_STATE {
        SUSPEND,
        SUSPEND_NONE;

    }
}

