/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObject;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSEditorUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointLineUpdater;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSFileObjectBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSURIBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public final class NbJSBreakpointManager {
    private static final Map<NbJSBreakpoint, NbJSBreakpointLineUpdater> BLUS = new HashMap<NbJSBreakpoint, NbJSBreakpointLineUpdater>();

    private NbJSBreakpointManager() {
    }

    protected static final NbJSBreakpoint createBreakpoint(Line line) {
        DataObject dataObject = (DataObject)line.getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        NbJSBreakpoint nbJSBreakpoint = null;
        if (fileObject instanceof URLFileObject) {
            try {
                URL uRL = fileObject.getURL();
                nbJSBreakpoint = new NbJSURIBreakpoint(uRL.toString(), line.getLineNumber() + 1);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        } else {
            nbJSBreakpoint = new NbJSFileObjectBreakpoint(line);
        }
        NbJSBreakpointManager.attachLineUpdater(nbJSBreakpoint);
        return nbJSBreakpoint;
    }

    protected static final NbJSURIBreakpoint createURIBreakpoint(String string, int n) {
        NbJSURIBreakpoint nbJSURIBreakpoint = new NbJSURIBreakpoint(string, n + 1);
        NbJSBreakpointManager.attachLineUpdater(nbJSURIBreakpoint);
        return nbJSURIBreakpoint;
    }

    private static final void attachLineUpdater(NbJSBreakpoint nbJSBreakpoint) {
        NbJSBreakpointLineUpdater nbJSBreakpointLineUpdater = new NbJSBreakpointLineUpdater(nbJSBreakpoint);
        try {
            nbJSBreakpointLineUpdater.attach();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        BLUS.put(nbJSBreakpoint, nbJSBreakpointLineUpdater);
    }

    public static NbJSBreakpoint addURIBreakpoint(String string, int n) {
        NbJSURIBreakpoint nbJSURIBreakpoint = NbJSBreakpointManager.createURIBreakpoint(string, n);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)nbJSURIBreakpoint);
        return nbJSURIBreakpoint;
    }

    public static NbJSBreakpoint addBreakpoint(Line line) {
        NbJSBreakpoint nbJSBreakpoint = NbJSBreakpointManager.createBreakpoint(line);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)nbJSBreakpoint);
        return nbJSBreakpoint;
    }

    public static void removeBreakpoint(NbJSBreakpoint nbJSBreakpoint) {
        NbJSBreakpointLineUpdater nbJSBreakpointLineUpdater = BLUS.remove((Object)nbJSBreakpoint);
        if (nbJSBreakpointLineUpdater != null) {
            nbJSBreakpointLineUpdater.detach();
        }
        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)nbJSBreakpoint);
    }

    public static NbJSBreakpoint[] getBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<NbJSBreakpoint> arrayList = new ArrayList<NbJSBreakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (!(breakpoint instanceof NbJSBreakpoint)) continue;
            arrayList.add((NbJSBreakpoint)breakpoint);
        }
        return arrayList.toArray(new NbJSBreakpoint[arrayList.size()]);
    }

    static NbJSBreakpoint[] getBreakpoints(FileObject fileObject) {
        assert (fileObject != null);
        ArrayList<NbJSBreakpoint> arrayList = new ArrayList<NbJSBreakpoint>();
        for (NbJSBreakpoint nbJSBreakpoint : NbJSBreakpointManager.getBreakpoints()) {
            FileObject fileObject2 = nbJSBreakpoint.getFileObject();
            if (!fileObject.equals(fileObject2)) continue;
            arrayList.add(nbJSBreakpoint);
        }
        return arrayList.toArray(new NbJSBreakpoint[arrayList.size()]);
    }

    public static boolean isBreakpointOnLine(FileObject fileObject, int n) {
        for (NbJSBreakpoint nbJSBreakpoint : NbJSBreakpointManager.getBreakpoints()) {
            if (!fileObject.equals(nbJSBreakpoint.getFileObject()) || n != nbJSBreakpoint.getLineNumber()) continue;
            return true;
        }
        return false;
    }

    public static NbJSBreakpoint getCurrentLineBreakpoint() {
        Line line = NbJSEditorUtil.getCurrentLine();
        if (line == null) {
            return null;
        }
        for (NbJSBreakpoint nbJSBreakpoint : NbJSBreakpointManager.getBreakpoints()) {
            FileObject fileObject = ((DataObject)line.getLookup().lookup(DataObject.class)).getPrimaryFile();
            if (!fileObject.equals(nbJSBreakpoint.getFileObject()) || nbJSBreakpoint.getLineNumber() != line.getLineNumber() + 1) continue;
            return nbJSBreakpoint;
        }
        return null;
    }
}

