/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointAnnotation;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpointAnnotationListener;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSURIBreakpoint;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;

public final class NbJSURIBreakpointAnnotationListener
extends NbJSBreakpointAnnotationListener {
    private final List<NbJSURIBreakpoint> uriBreakpoints = new CopyOnWriteArrayList<NbJSURIBreakpoint>();
    private final Map<DebuggerEngine, Map<NbJSURIBreakpoint, Annotation>> engineToBreakpointsToAnnotations = new HashMap<DebuggerEngine, Map<NbJSURIBreakpoint, Annotation>>();

    public String[] getProperties() {
        return new String[]{"breakpoints", "debuggerEngines"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof NbJSURIBreakpoint)) {
            return;
        }
        NbJSURIBreakpoint nbJSURIBreakpoint = (NbJSURIBreakpoint)breakpoint;
        this.addBreakpointAnnotation(nbJSURIBreakpoint);
        this.uriBreakpoints.add(nbJSURIBreakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof NbJSURIBreakpoint)) {
            return;
        }
        NbJSURIBreakpoint nbJSURIBreakpoint = (NbJSURIBreakpoint)breakpoint;
        this.removeBreakpointAnnotation(nbJSURIBreakpoint);
        this.uriBreakpoints.remove((Object)nbJSURIBreakpoint);
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
        NbJSDebugger nbJSDebugger = (NbJSDebugger)debuggerEngine.lookupFirst(null, NbJSDebugger.class);
        if (nbJSDebugger == null) {
            return;
        }
        assert (!this.engineToBreakpointsToAnnotations.containsKey(debuggerEngine));
        this.engineToBreakpointsToAnnotations.put(debuggerEngine, new HashMap());
        for (NbJSURIBreakpoint nbJSURIBreakpoint : this.uriBreakpoints) {
            this.addBreakpointAnnotation(nbJSURIBreakpoint, debuggerEngine);
        }
        super.engineAdded(debuggerEngine);
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
        this.engineToBreakpointsToAnnotations.remove(debuggerEngine);
        super.engineRemoved(debuggerEngine);
    }

    protected final void addBreakpointAnnotation(NbJSBreakpoint nbJSBreakpoint) {
        assert (nbJSBreakpoint instanceof NbJSURIBreakpoint);
        for (DebuggerEngine debuggerEngine : this.engineToBreakpointsToAnnotations.keySet()) {
            this.addBreakpointAnnotation((NbJSURIBreakpoint)nbJSBreakpoint, debuggerEngine);
        }
        nbJSBreakpoint.addPropertyChangeListener(this.getEnableBreakpointPropertyChangeListener());
    }

    protected final void removeBreakpointAnnotation(NbJSBreakpoint nbJSBreakpoint) {
        assert (nbJSBreakpoint instanceof NbJSURIBreakpoint);
        for (DebuggerEngine debuggerEngine : this.engineToBreakpointsToAnnotations.keySet()) {
            this.removeBreakpointAnnotation((NbJSURIBreakpoint)nbJSBreakpoint, debuggerEngine);
        }
        assert (this.enableBreakpointPropertyChangeListener != null);
        nbJSBreakpoint.removePropertyChangeListener(this.enableBreakpointPropertyChangeListener);
    }

    private final void addBreakpointAnnotation(NbJSURIBreakpoint nbJSURIBreakpoint, DebuggerEngine debuggerEngine) {
        Line line = nbJSURIBreakpoint.getLine(debuggerEngine);
        if (line != null) {
            NbJSBreakpointAnnotation nbJSBreakpointAnnotation = new NbJSBreakpointAnnotation((Annotatable)line, nbJSURIBreakpoint);
            Map<NbJSURIBreakpoint, Annotation> map = this.engineToBreakpointsToAnnotations.get(debuggerEngine);
            map.put(nbJSURIBreakpoint, (Annotation)nbJSBreakpointAnnotation);
        }
    }

    private final void removeBreakpointAnnotation(NbJSURIBreakpoint nbJSURIBreakpoint, DebuggerEngine debuggerEngine) {
        Map<NbJSURIBreakpoint, Annotation> map = this.engineToBreakpointsToAnnotations.get(debuggerEngine);
        Annotation annotation = map.remove((Object)nbJSURIBreakpoint);
        if (annotation == null) {
            return;
        }
        annotation.detach();
    }
}

