/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javascript.editing.spi.JSPreferencesPanel;
import org.netbeans.modules.javascript.editing.spi.JSPreferencesPanelProvider;
import org.netbeans.modules.web.client.javascript.debugger.models.NbJSPreferences;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NbJSPreferencesPanelProvider
extends JSPreferencesPanel
implements JSPreferencesPanelProvider,
ActionListener {
    private List<ChangeListener> listeners;
    private NbJSPreferencesPanelProvider INSTANCE = null;
    public static final NbJSPreferences preferences = NbJSPreferences.getInstance();
    private JCheckBox EnableStepFilters;
    private JCheckBox bypassConstructor;
    private JLabel jLabel1;
    private JCheckBox showConstantsCheckBox;
    private JCheckBox showFunctionsCheckBox;
    private JCheckBox suspendOnDebuggerKeywordCheckBox;
    private JCheckBox suspendOnErrorsCheckBox;
    private JCheckBox suspendOnExceptionsCheckBox;
    private JCheckBox suspendOnFirstLineCheckBox;

    public JSPreferencesPanel getPanel() {
        if (this.INSTANCE == null) {
            this.INSTANCE = new NbJSPreferencesPanelProvider();
        }
        return this.INSTANCE;
    }

    public NbJSPreferencesPanelProvider() {
        this.initComponents();
        this.showFunctionsCheckBox.addActionListener(this);
        this.showFunctionsCheckBox.addActionListener(this);
        this.suspendOnErrorsCheckBox.addActionListener(this);
        this.suspendOnExceptionsCheckBox.addActionListener(this);
        this.suspendOnFirstLineCheckBox.addActionListener(this);
    }

    public void load() {
        this.updateUIFromPreferences(preferences);
    }

    public void store() {
        this.updatePreferencesFromUI(preferences);
    }

    void updateUIFromPreferences(NbJSPreferences nbJSPreferences) {
        this.showConstantsCheckBox.setSelected(nbJSPreferences.getShowConstants());
        this.showFunctionsCheckBox.setSelected(nbJSPreferences.getShowFunctions());
        this.suspendOnDebuggerKeywordCheckBox.setSelected(nbJSPreferences.getSuspendOnDebuggerKeyword());
        this.suspendOnErrorsCheckBox.setSelected(nbJSPreferences.getSuspendOnErrors());
        this.suspendOnExceptionsCheckBox.setSelected(nbJSPreferences.getSuspendOnExceptions());
        this.suspendOnFirstLineCheckBox.setSelected(nbJSPreferences.getSuspendOnFirstLine());
    }

    void updatePreferencesFromUI(NbJSPreferences nbJSPreferences) {
        nbJSPreferences.setShowConstants(this.showConstantsCheckBox.isSelected());
        nbJSPreferences.setShowFunctions(this.showFunctionsCheckBox.isSelected());
        nbJSPreferences.setSuspendOnDebuggerKeyword(this.suspendOnDebuggerKeywordCheckBox.isSelected());
        nbJSPreferences.setSuspendOnErrors(this.suspendOnErrorsCheckBox.isSelected());
        nbJSPreferences.setSuspendOnExceptions(this.suspendOnExceptionsCheckBox.isSelected());
        nbJSPreferences.setSuspendOnFirstLine(this.suspendOnFirstLineCheckBox.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBox) {
            ChangeEvent changeEvent = new ChangeEvent(object);
            if (this.listeners != null) {
                for (ChangeListener changeListener : this.listeners) {
                    changeListener.stateChanged(changeEvent);
                }
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void initComponents() {
        this.showFunctionsCheckBox = new JCheckBox();
        this.showConstantsCheckBox = new JCheckBox();
        this.suspendOnFirstLineCheckBox = new JCheckBox();
        this.suspendOnExceptionsCheckBox = new JCheckBox();
        this.suspendOnErrorsCheckBox = new JCheckBox();
        this.suspendOnDebuggerKeywordCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.bypassConstructor = new JCheckBox();
        this.EnableStepFilters = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.showFunctionsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.showFunctionsCheckBox.text"));
        this.showFunctionsCheckBox.setMaximumSize(new Dimension(122, 22));
        this.showFunctionsCheckBox.setMinimumSize(new Dimension(122, 22));
        Mnemonics.setLocalizedText((AbstractButton)this.showConstantsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.showConstantsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnFirstLineCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnFirstLineCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnExceptionsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnExceptionsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnErrorsCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnErrorsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suspendOnDebuggerKeywordCheckBox, (String)NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.suspendOnDebuggerKeywordCheckBox.text"));
        this.jLabel1.setText(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.Debugging.text"));
        this.bypassConstructor.setText(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.bypassConstructor.text"));
        this.bypassConstructor.setEnabled(false);
        this.EnableStepFilters.setText(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSPreferencesPanelProvider.EnableStepFilters.text"));
        this.EnableStepFilters.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(57, 57, 57).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.showFunctionsCheckBox, -2, -1, -2).add((Component)this.showConstantsCheckBox).add((Component)this.bypassConstructor).add((Component)this.EnableStepFilters)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.suspendOnFirstLineCheckBox).add((Component)this.suspendOnExceptionsCheckBox).add((Component)this.suspendOnErrorsCheckBox).add((Component)this.suspendOnDebuggerKeywordCheckBox)).addContainerGap(127, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.suspendOnDebuggerKeywordCheckBox, this.suspendOnErrorsCheckBox, this.suspendOnExceptionsCheckBox, this.suspendOnFirstLineCheckBox}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.suspendOnFirstLineCheckBox).addPreferredGap(0).add((Component)this.suspendOnExceptionsCheckBox).addPreferredGap(0).add((Component)this.suspendOnErrorsCheckBox).addPreferredGap(0).add((Component)this.suspendOnDebuggerKeywordCheckBox)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.showFunctionsCheckBox, -2, -1, -2).addPreferredGap(0).add((Component)this.showConstantsCheckBox).addPreferredGap(0).add((Component)this.bypassConstructor).addPreferredGap(0).add((Component)this.EnableStepFilters)).add((Component)this.jLabel1)).addContainerGap(156, Short.MAX_VALUE)));
        this.showFunctionsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowFunctions"));
        this.showFunctionsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowFunctions"));
        this.showConstantsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowConstants"));
        this.showConstantsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowConstants"));
        this.suspendOnFirstLineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnFirstLine"));
        this.suspendOnFirstLineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnFirstLine"));
        this.suspendOnExceptionsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnExceptions"));
        this.suspendOnExceptionsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnExceptions"));
        this.suspendOnErrorsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_SuspendOnErrors"));
        this.suspendOnErrorsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"NbJSAdvancedOptionsPanel.suspendOnErrorsCheckBox.AccessibleContext.accessibleDescription"));
        this.suspendOnDebuggerKeywordCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowOnDebuggerKeyword"));
        this.suspendOnDebuggerKeywordCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSPreferencesPanelProvider.class, (String)"A11Y_CKBX_ShowOnDebuggerKeyword"));
    }
}

