/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core;

import java.io.IOException;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class BPELDataLoader
extends UniFileLoader {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE = "text/x-bpel+xml";
    public static final String ACTION_CONTEXT = "Loaders/text/x-bpel+xml/Actions";
    public static final String PRIMARY_EXTENSION = "bpel";
    static final String SECONDARY_EXTENSION = "vbpel";
    static final String LOADER_NAME = "LBL_loader_name";

    public BPELDataLoader() {
        super("org.netbeans.modules.bpel.core.BPELDataObject");
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(MIME_TYPE);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(BPELDataLoader.class, (String)LOADER_NAME);
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new BPELDataObject(fileObject, (MultiFileLoader)this);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2 = null;
        try {
            if (!fileObject.getFileSystem().isDefault()) {
                String string = fileObject.getExt();
                if (string.equals(PRIMARY_EXTENSION)) {
                    fileObject2 = fileObject;
                } else if (string.equals(SECONDARY_EXTENSION)) {
                    fileObject2 = FileUtil.findBrother((FileObject)fileObject, (String)PRIMARY_EXTENSION);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
        }
        return fileObject2;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    protected String actionsContext() {
        return ACTION_CONTEXT;
    }
}

