/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.annotations.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.netbeans.modules.bpel.core.annotations.AnnotationListener;
import org.netbeans.modules.bpel.core.annotations.AnnotationManagerCookie;
import org.netbeans.modules.bpel.core.annotations.DiagramAnnotation;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.support.UniqueId;

public class AnnotationManagerProvider
implements AnnotationManagerCookie {
    public static final String ANNOTATIONS_COOKIE_KEY = "annotations";
    private BPELDataObject myDataObject;
    private LinkedList<AnnotationListener> myListeners = new LinkedList();
    private HashMap<UniqueId, ArrayList<DiagramAnnotation>> myAnnotationById = new HashMap();

    public AnnotationManagerProvider(BPELDataObject bPELDataObject) {
        this.myDataObject = bPELDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAnnotation(DiagramAnnotation diagramAnnotation) {
        BpelModel bpelModel = (BpelModel)this.myDataObject.getLookup().lookup(BpelModel.class);
        UniqueId uniqueId = diagramAnnotation.getBpelEntityId();
        assert (uniqueId.getModel() == bpelModel);
        HashMap<UniqueId, ArrayList<DiagramAnnotation>> hashMap = this.myAnnotationById;
        synchronized (hashMap) {
            ArrayList<DiagramAnnotation> arrayList = this.myAnnotationById.get(uniqueId);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.myAnnotationById.put(uniqueId, arrayList);
            } else if (arrayList.contains(diagramAnnotation)) {
                return false;
            }
            arrayList.add(diagramAnnotation);
        }
        this.fireAnnotationAdded(diagramAnnotation);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeAnnotation(DiagramAnnotation diagramAnnotation) {
        BpelModel bpelModel = (BpelModel)this.myDataObject.getLookup().lookup(BpelModel.class);
        UniqueId uniqueId = diagramAnnotation.getBpelEntityId();
        assert (uniqueId.getModel() == bpelModel);
        HashMap<UniqueId, ArrayList<DiagramAnnotation>> hashMap = this.myAnnotationById;
        synchronized (hashMap) {
            ArrayList<DiagramAnnotation> arrayList = this.myAnnotationById.get(uniqueId);
            if (arrayList == null) {
                return false;
            }
            if (!arrayList.remove(diagramAnnotation)) {
                return false;
            }
            if (arrayList.size() == 0) {
                this.myAnnotationById.remove(uniqueId);
            }
        }
        this.fireAnnotationRemoved(diagramAnnotation);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramAnnotation[] getAnnotations(UniqueId uniqueId) {
        BpelModel bpelModel = (BpelModel)this.myDataObject.getLookup().lookup(BpelModel.class);
        assert (uniqueId.getModel() == bpelModel);
        HashMap<UniqueId, ArrayList<DiagramAnnotation>> hashMap = this.myAnnotationById;
        synchronized (hashMap) {
            ArrayList<DiagramAnnotation> arrayList = this.myAnnotationById.get(uniqueId);
            if (arrayList != null) {
                return arrayList.toArray(new DiagramAnnotation[arrayList.size()]);
            }
        }
        return new DiagramAnnotation[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationListener(AnnotationListener annotationListener) {
        LinkedList<AnnotationListener> linkedList = this.myListeners;
        synchronized (linkedList) {
            this.myListeners.add(annotationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationListener(AnnotationListener annotationListener) {
        LinkedList<AnnotationListener> linkedList = this.myListeners;
        synchronized (linkedList) {
            this.myListeners.remove(annotationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAnnotationAdded(DiagramAnnotation diagramAnnotation) {
        LinkedList linkedList = null;
        LinkedList<AnnotationListener> linkedList2 = this.myListeners;
        synchronized (linkedList2) {
            linkedList = (LinkedList)this.myListeners.clone();
        }
        for (AnnotationListener annotationListener : linkedList) {
            annotationListener.annotationAdded(diagramAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAnnotationRemoved(DiagramAnnotation diagramAnnotation) {
        LinkedList linkedList = null;
        LinkedList<AnnotationListener> linkedList2 = this.myListeners;
        synchronized (linkedList2) {
            linkedList = (LinkedList)this.myListeners.clone();
        }
        for (AnnotationListener annotationListener : linkedList) {
            annotationListener.annotationRemoved(diagramAnnotation);
        }
    }
}

