/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.core.multiview;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.netbeans.modules.bpel.core.multiview.SourceCookieProxyLookup;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.editors.api.nodes.FactoryAccess;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class BPELSourceMultiViewElement
extends CloneableEditor
implements MultiViewElement {
    private static final int CARET_CHANGE_TASK_DELAY = 500;
    private static final long serialVersionUID = 1L;
    static final String PREFERED_ID = "BpelSourceView";
    private transient MultiViewElementCallback myMultiViewObserver;
    private BPELDataObject myDataObject;
    private transient JToolBar myToolBar;
    private CaretListener myCaretPositionListener;
    private ChangeEventListener myBpelModelListener;
    private transient RequestProcessor.Task myPreviousTask;

    private BPELSourceMultiViewElement() {
    }

    public BPELSourceMultiViewElement(BPELDataObject bPELDataObject) {
        super((CloneableEditorSupport)bPELDataObject.getEditorSupport());
        this.myDataObject = bPELDataObject;
        this.getDataObject().getEditorSupport().initializeCloneableEditor(this);
        this.initialize();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.myDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof BPELDataObject) {
            this.myDataObject = (BPELDataObject)((Object)object);
        }
        this.initialize();
    }

    public int getPersistenceType() {
        return 1;
    }

    public CloseOperationState canCloseElement() {
        boolean bl = this.isLastView();
        if (!bl) {
            return CloseOperationState.STATE_OK;
        }
        boolean bl2 = this.cloneableEditorSupport().isModified();
        if (!bl2) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"Data Object Modified", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public Action[] getActions() {
        Action[] actionArray;
        if (this.myMultiViewObserver != null) {
            Action[] actionArray2 = this.myMultiViewObserver.createDefaultActions();
            Action[] actionArray3 = this.getNodeActions();
            if (actionArray3 != null && actionArray3.length > 0) {
                ArrayList<Action> arrayList = new ArrayList<Action>();
                arrayList.addAll(Arrays.asList(actionArray2));
                arrayList.addAll(Arrays.asList(actionArray3));
                actionArray = new Action[arrayList.size()];
                actionArray = arrayList.toArray(actionArray);
            } else {
                actionArray = actionArray2;
            }
        } else {
            actionArray = super.getActions();
        }
        return actionArray;
    }

    public void componentActivated() {
        super.componentActivated();
        this.setCaretAssocActiveNodes();
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        bPELDataEditorSupport.addUndoManagerToDocument();
    }

    public void componentClosed() {
        super.componentClosed();
        this.removeCaretPositionListener();
        this.setMultiViewCallback(null);
        if (this.getParent() != null) {
            this.getParent().remove((java.awt.Component)((Object)this));
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        bPELDataEditorSupport.syncModel();
        bPELDataEditorSupport.removeUndoManagerFromDocument();
    }

    public void componentHidden() {
        super.componentHidden();
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        bPELDataEditorSupport.syncModel();
        bPELDataEditorSupport.removeUndoManagerFromDocument();
    }

    public void componentOpened() {
        super.componentOpened();
        this.addCaretPositionListener();
    }

    public void componentShowing() {
        super.componentShowing();
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        bPELDataEditorSupport.addUndoManagerToDocument();
    }

    public JComponent getToolbarRepresentation() {
        Document document = this.getEditorPane().getDocument();
        if (document instanceof NbDocument.CustomToolbar) {
            if (this.myToolBar == null) {
                this.myToolBar = ((NbDocument.CustomToolbar)document).createToolbar(this.getEditorPane());
            }
            return this.myToolBar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.myMultiViewObserver = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    public UndoRedo getUndoRedo() {
        BPELDataEditorSupport bPELDataEditorSupport = this.myDataObject.getEditorSupport();
        return bPELDataEditorSupport.getUndoManager();
    }

    protected boolean closeLast() {
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        JEditorPane[] jEditorPaneArray = bPELDataEditorSupport.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return bPELDataEditorSupport.silentClose();
        }
        return false;
    }

    protected String preferredID() {
        return PREFERED_ID;
    }

    private BPELDataObject getDataObject() {
        return this.myDataObject;
    }

    private void initialize() {
        Node node = this.myDataObject.getNodeDelegate();
        SourceCookieProxyLookup sourceCookieProxyLookup = new SourceCookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this.getActionMap(), this.myDataObject}), this.getDataObject().getLookup()}, node);
        this.associateLookup((Lookup)sourceCookieProxyLookup);
        this.addPropertyChangeListener("activatedNodes", sourceCookieProxyLookup);
    }

    private void addUndoManager() {
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        QuietUndoManager quietUndoManager = bPELDataEditorSupport.getUndoManager();
        StyledDocument styledDocument = bPELDataEditorSupport.getDocument();
        if (styledDocument != null) {
            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.beginCompound();
        }
    }

    private void removeUndoManager() {
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        StyledDocument styledDocument = bPELDataEditorSupport.getDocument();
        if (styledDocument != null) {
            QuietUndoManager quietUndoManager = bPELDataEditorSupport.getUndoManager();
            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.endCompound();
        }
    }

    private boolean isLastView() {
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)this.myMultiViewObserver.getTopComponent()).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    private Action[] getNodeActions() {
        if (this.myMultiViewObserver == null) {
            return null;
        }
        Node[] nodeArray = this.myMultiViewObserver.getTopComponent().getActivatedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            return nodeArray[0].getActions(true);
        }
        return null;
    }

    private void addCaretPositionListener() {
        BpelModel bpelModel;
        JEditorPane jEditorPane = this.getEditorPane();
        if (this.myCaretPositionListener != null && jEditorPane != null) {
            jEditorPane.removeCaretListener(this.myCaretPositionListener);
        }
        if (this.myCaretPositionListener == null) {
            this.myCaretPositionListener = new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    BPELSourceMultiViewElement.this.selectElement();
                }
            };
        }
        jEditorPane.addCaretListener(this.myCaretPositionListener);
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        BpelModel bpelModel2 = bpelModel = bPELDataEditorSupport != null ? bPELDataEditorSupport.getBpelModel() : null;
        if (bpelModel != null) {
            if (this.myBpelModelListener != null) {
                bpelModel.removeEntityChangeListener(this.myBpelModelListener);
            }
            if (this.myBpelModelListener == null) {
                this.myBpelModelListener = new ChangeEventListener(){

                    private void handleEvent(ChangeEvent changeEvent) {
                        if (changeEvent == null) {
                            return;
                        }
                        if (changeEvent.isLastInAtomic()) {
                            if (!SwingUtilities.isEventDispatchThread()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        BPELSourceMultiViewElement.this.selectElement(0);
                                    }
                                });
                            } else {
                                BPELSourceMultiViewElement.this.selectElement(0);
                            }
                        }
                    }

                    public void notifyPropertyRemoved(PropertyRemoveEvent propertyRemoveEvent) {
                        this.handleEvent((ChangeEvent)propertyRemoveEvent);
                    }

                    public void notifyEntityInserted(EntityInsertEvent entityInsertEvent) {
                        this.handleEvent((ChangeEvent)entityInsertEvent);
                    }

                    public void notifyPropertyUpdated(PropertyUpdateEvent propertyUpdateEvent) {
                        this.handleEvent((ChangeEvent)propertyUpdateEvent);
                    }

                    public void notifyEntityRemoved(EntityRemoveEvent entityRemoveEvent) {
                        this.handleEvent((ChangeEvent)entityRemoveEvent);
                    }

                    public void notifyEntityUpdated(EntityUpdateEvent entityUpdateEvent) {
                        this.handleEvent((ChangeEvent)entityUpdateEvent);
                    }

                    public void notifyArrayUpdated(ArrayUpdateEvent arrayUpdateEvent) {
                        this.handleEvent((ChangeEvent)arrayUpdateEvent);
                    }
                };
            }
            bpelModel.addEntityChangeListener(this.myBpelModelListener);
        }
    }

    private void setCaretAssocActiveNodes() {
        this.selectElement();
    }

    private void setActivatedNodes(final int n) {
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        if (bPELDataEditorSupport == null) {
            return;
        }
        final BpelModel bpelModel = bPELDataEditorSupport.getBpelModel();
        if (bpelModel == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent;
                BpelEntity bpelEntity = bpelModel.findElement(n);
                if (bpelEntity == null) {
                    return;
                }
                NodeFactory nodeFactory = FactoryAccess.getPropertyNodeFactory();
                assert (nodeFactory != null);
                NodeType nodeType = EditorUtil.getBasicNodeType((Component)bpelEntity);
                if (nodeType == null) {
                    return;
                }
                Node node = nodeFactory.createNode((Object)(nodeType = NodeType.UNKNOWN_TYPE.equals((Object)nodeType) ? NodeType.DEFAULT_BPEL_ENTITY_NODE : nodeType), (Object)bpelEntity, BPELSourceMultiViewElement.this.getDataObject().getLookup());
                if (node == null) {
                    return;
                }
                TopComponent topComponent2 = topComponent = BPELSourceMultiViewElement.this.myMultiViewObserver == null ? null : BPELSourceMultiViewElement.this.myMultiViewObserver.getTopComponent();
                if (topComponent != null) {
                    BPELSourceMultiViewElement.this.setActivatedNodes(new Node[]{node});
                }
            }
        });
    }

    private void removeCaretPositionListener() {
        BpelModel bpelModel;
        JEditorPane jEditorPane = this.getEditorPane();
        if (jEditorPane != null && this.myCaretPositionListener != null) {
            jEditorPane.removeCaretListener(this.myCaretPositionListener);
        }
        this.myCaretPositionListener = null;
        BPELDataEditorSupport bPELDataEditorSupport = this.getDataObject().getEditorSupport();
        BpelModel bpelModel2 = bpelModel = bPELDataEditorSupport != null ? bPELDataEditorSupport.getBpelModel() : null;
        if (this.myBpelModelListener != null && bpelModel != null) {
            bpelModel.removeEntityChangeListener(this.myBpelModelListener);
        }
        this.myBpelModelListener = null;
    }

    private void selectElement(int n) {
        JEditorPane jEditorPane;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.myPreviousTask != null) {
            this.myPreviousTask.cancel();
        }
        if (this.myPreviousTask != null && !this.myPreviousTask.isFinished() && RequestProcessor.getDefault().isRequestProcessorThread()) {
            this.myPreviousTask.waitFinished();
            this.myPreviousTask = null;
        }
        if ((jEditorPane = this.getEditorPane()) != null && !jEditorPane.isShowing()) {
            return;
        }
        if (n <= 0) {
            this.setActivatedNodes(jEditorPane.getCaret().getDot());
        } else {
            this.myPreviousTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BPELSourceMultiViewElement.this.setActivatedNodes(jEditorPane.getCaret().getDot());
                }
            }, n);
        }
    }

    private void selectElement() {
        this.selectElement(500);
    }
}

