/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Threads;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPUSampledInstr
extends ProfilerRuntimeCPU {
    protected static int samplingInterval = 10;
    protected static SamplingThread st;

    public static void setSamplingInterval(int n) {
        samplingInterval = n;
    }

    public static void enableProfiling(boolean bl) {
        if (bl) {
            ProfilerRuntimeCPUSampledInstr.createNewDataStructures();
            ProfilerRuntimeCPU.enableProfiling(bl);
        } else {
            ProfilerRuntimeCPU.enableProfiling(bl);
            ProfilerRuntimeCPUSampledInstr.clearDataStructures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void markerMethodEntry(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!threadInfo.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0 || ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            threadInfo.initialize();
            threadInfo.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++threadInfo.inProfilingRuntimeMethod;
                threadInfo.inCallGraph = true;
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(threadInfo);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++threadInfo.inProfilingRuntimeMethod;
            threadInfo.inCallGraph = true;
        }
        {
            if (!instrMethodInvoked[c = (char)c]) {
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[c] = true;
            }
            ++threadInfo.stackDepth;
            if (threadInfo.stackDepth > 1) {
                if (!threadInfo.sampleDue) {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)18, threadInfo, c);
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, threadInfo, c);
                    threadInfo.sampleDue = false;
                }
            } else {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)3, threadInfo, c);
            }
            --threadInfo.inProfilingRuntimeMethod;
            return;
        }
    }

    public static void markerMethodExit(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            if (threadInfo.rootMethodStackDepth > 0) {
                ProfilerRuntimeCPUSampledInstr.methodExit(c);
            } else {
                ++threadInfo.inProfilingRuntimeMethod;
                --threadInfo.stackDepth;
                if (threadInfo.stackDepth < 1) {
                    threadInfo.inCallGraph = false;
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, threadInfo, c);
                } else if (!threadInfo.sampleDue) {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)19, threadInfo, c);
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)4, threadInfo, c);
                    threadInfo.sampleDue = false;
                }
                --threadInfo.inProfilingRuntimeMethod;
            }
        }
    }

    public static void methodEntry(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph && threadInfo.rootMethodStackDepth > 0) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            if (!instrMethodInvoked[c = (char)c]) {
                long l = Timers.getCurrentTimeInCounts();
                long l2 = Timers.getThreadCPUTimeInNanos();
                externalActionsHandler.handleFirstTimeMethodInvoke(c);
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[c] = true;
                ProfilerRuntimeCPUSampledInstr.writeAdjustTimeEvent(threadInfo, l, l2);
            }
            ++threadInfo.stackDepth;
            if (!threadInfo.sampleDue) {
                if (c <= '\u3fff') {
                    ProfilerRuntimeCPUSampledInstr.writeCompactEvent(threadInfo, (char)(0x8000 | c));
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)16, threadInfo, c);
                }
            } else {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)6, threadInfo, c);
                threadInfo.sampleDue = false;
            }
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    public static void methodExit(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.isInitialized() && threadInfo.inCallGraph && threadInfo.rootMethodStackDepth > 0) {
            if (threadInfo.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            if (threadInfo.rootMethodStackDepth == threadInfo.stackDepth) {
                threadInfo.rootMethodStackDepth = 0;
            }
            --threadInfo.stackDepth;
            if (threadInfo.stackDepth < 1) {
                threadInfo.inCallGraph = false;
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)2, threadInfo, c);
            } else if (!threadInfo.sampleDue) {
                if ((c = (char)c) <= '\u3fff') {
                    ProfilerRuntimeCPUSampledInstr.writeCompactEvent(threadInfo, (char)(0xC000 | c));
                } else {
                    ProfilerRuntimeCPUSampledInstr.writeUnstampedEvent((byte)17, threadInfo, c);
                }
            } else {
                ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)7, threadInfo, c);
                threadInfo.sampleDue = false;
            }
            --threadInfo.inProfilingRuntimeMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rootMethodEntry(char c) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ProfilerServer.notifyClientOnResultsAvailability();
        if (threadInfo.isInitialized() && !threadInfo.inCallGraph && threadInfo.stackDepth > 0) {
            threadInfo.inCallGraph = true;
            ProfilerRuntimeCPUSampledInstr.methodEntry(c);
            threadInfo.inCallGraph = false;
            return;
        }
        if (threadInfo != null && threadInfo.inCallGraph && threadInfo.rootMethodStackDepth > 0) {
            ProfilerRuntimeCPUSampledInstr.methodEntry(c);
            return;
        }
        if (!threadInfo.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0) return;
            if (ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            threadInfo.initialize();
            threadInfo.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++threadInfo.inProfilingRuntimeMethod;
                if (!ProfilerServer.startProfilingPointsActive()) {
                    threadInfo.inCallGraph = true;
                }
                ProfilerRuntimeCPUSampledInstr.writeThreadCreationEvent(threadInfo);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            if (threadInfo.stackDepth > 0) {
                threadInfo.rootMethodStackDepth = threadInfo.stackDepth + 1;
                ProfilerRuntimeCPUSampledInstr.methodEntry(c);
                return;
            }
            ++threadInfo.inProfilingRuntimeMethod;
            if (!ProfilerServer.startProfilingPointsActive()) {
                threadInfo.inCallGraph = true;
            }
        }
        {
            c = c;
            if (!instrMethodInvoked[c]) {
                externalActionsHandler.handleFirstTimeMethodInvoke(c);
                ProfilerRuntimeCPUSampledInstr.instrMethodInvoked[c] = true;
            }
            ++threadInfo.stackDepth;
            ProfilerRuntimeCPUSampledInstr.writeTimeStampedEvent((byte)1, threadInfo, c);
            threadInfo.rootMethodStackDepth = threadInfo.stackDepth;
            --threadInfo.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeCPU.clearDataStructures();
        if (st != null) {
            st.terminate();
        }
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeCPU.createNewDataStructures();
        st = new SamplingThread();
        st.setPriority(10);
        Threads.recordAdditionalProfilerOwnThread(st);
        st.start();
    }

    static void writeCompactEvent(ThreadInfo threadInfo, char c) {
        threadInfo.evBuf[threadInfo.evBufPos++] = (byte)(c >> 8 & 0xFF);
        threadInfo.evBuf[threadInfo.evBufPos++] = (byte)(c & 0xFF);
        if (threadInfo.evBufPos > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(threadInfo);
        }
    }

    static void writeUnstampedEvent(byte by, ThreadInfo threadInfo, char c) {
        byte[] byArray = threadInfo.evBuf;
        int n = threadInfo.evBufPos;
        byArray[n++] = by;
        byArray[n++] = (byte)(c >> 8 & 0xFF);
        byArray[n++] = (byte)(c & 0xFF);
        threadInfo.evBufPos = n;
        if (n > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPUSampledInstr.copyLocalBuffer(threadInfo);
        }
    }

    static class SamplingThread
    extends Thread {
        private static final boolean isSolaris = System.getProperty("os.name").startsWith("Sun");
        private static final boolean isLinux = System.getProperty("os.name").startsWith("Linux");
        private static final boolean isUnix = isSolaris || isLinux;
        private static final int VIOLATION_THRESHOLD = 10;
        private static final boolean DEBUG = false;
        private boolean terminated;
        private int count;

        SamplingThread() {
        }

        public void run() {
            if (isSolaris) {
                samplingInterval *= 1000000;
            } else if (isLinux) {
                samplingInterval *= 1000;
            }
            int n = samplingInterval;
            int n2 = samplingInterval * 5 / 4;
            int n3 = samplingInterval / 10;
            int n4 = 10;
            long l = Timers.getCurrentTimeInCounts();
            while (!this.terminated) {
                if (!isUnix) {
                    try {
                        Thread.sleep(samplingInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    long l2 = Timers.getCurrentTimeInCounts();
                    Timers.osSleep((int)n);
                    l2 = Timers.getCurrentTimeInCounts() - l2;
                    if (l2 > (long)n2 && n > n3) {
                        if (n4 > 0) {
                            --n4;
                        } else {
                            n = n * 95 / 100;
                            n4 = 10;
                        }
                    }
                }
                ThreadInfo.setSampleDueForAllThreads();
            }
        }

        public void terminate() {
            this.terminated = true;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

