/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionService;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTaskReader;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.FilterNode;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RakeSupport {
    private static final Logger LOGGER = Logger.getLogger(RakeSupport.class.getName());
    static final String RAKE_D_OUTPUT = "nbproject/private/rake-d.txt";
    static final String[] RAKEFILE_NAMES = new String[]{"rakefile", "Rakefile", "rakefile.rb", "Rakefile.rb"};
    private final Project project;

    public RakeSupport(Project project) {
        this.project = project;
    }

    public static FileObject findRakeFile(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        for (String string : RAKEFILE_NAMES) {
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("ruby");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject3 = sourceGroup.getRootFolder();
                for (String string : RAKEFILE_NAMES) {
                    FileObject fileObject4 = fileObject3.getFileObject(string);
                    if (fileObject4 == null) continue;
                    return fileObject4;
                }
            }
        }
        return null;
    }

    public static boolean isRakeFile(FileObject fileObject) {
        if (!fileObject.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        String string = fileObject.getName().toLowerCase();
        if (string.equals("rakefile")) {
            return true;
        }
        String string2 = fileObject.getExt().toLowerCase();
        return string2.equals("rake");
    }

    public static void refreshTasks(Project project) {
        Object object;
        try {
            object = project.getProjectDirectory().getFileObject(RAKE_D_OUTPUT);
            if (object != null && object.isData()) {
                object.delete();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (!RubyPlatform.hasValidRake((Project)project, (boolean)true)) {
            return;
        }
        object = RakeSupport.readRakeTasksOutput(project);
        if (object != null) {
            RakeSupport.writeRakeTasks(project, (String)object);
        }
    }

    private static String readRakeTasksOutput(Project project) {
        FileObject fileObject = RakeSupport.findRakeFile(project);
        File file = fileObject == null ? FileUtil.toFile((FileObject)project.getProjectDirectory()) : FileUtil.toFile((FileObject)fileObject.getParent());
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        return RakeSupport.dumpRakeTasksInfo(rubyPlatform, file);
    }

    public static Set<RakeTask> getRakeTaskTree(Project project) {
        return RakeSupport.getRakeTaskTree(project, true);
    }

    public static Set<RakeTask> getRakeTaskTree(Project project, boolean bl) {
        RakeTaskReader rakeTaskReader = new RakeTaskReader(project);
        return rakeTaskReader.getRakeTaskTree(bl);
    }

    static Set<RakeTask> getRakeTasks(Project project) {
        return RakeSupport.getRakeTasks(project, true);
    }

    static Set<RakeTask> getRakeTasks(Project project, boolean bl) {
        Set<RakeTask> set = RakeSupport.getRakeTaskTree(project, bl);
        TreeSet<RakeTask> treeSet = new TreeSet<RakeTask>();
        RakeSupport.addTasks(treeSet, set);
        return treeSet;
    }

    private static void addTasks(Set<RakeTask> set, Set<RakeTask> set2) {
        for (RakeTask rakeTask : set2) {
            if (rakeTask.isNameSpace()) {
                RakeSupport.addTasks(set, rakeTask.getChildren());
                continue;
            }
            set.add(rakeTask);
        }
    }

    public static RakeTask getRakeTask(Project project, String string) {
        Set<RakeTask> set = RakeSupport.getRakeTasks(project, false);
        for (RakeTask rakeTask : set) {
            if (!rakeTask.getTask().equals(string)) continue;
            return rakeTask;
        }
        return null;
    }

    private static String dumpRakeTasksInfo(RubyPlatform rubyPlatform, File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = rubyPlatform.getInterpreterFile();
        if (!file2.getName().startsWith("jruby") || RubyExecution.LAUNCH_JRUBY_SCRIPT) {
            arrayList.add(file2.getPath());
        }
        arrayList.addAll(RubyExecution.getRubyArgs((RubyPlatform)rubyPlatform));
        File file3 = InstalledFileLocator.getDefault().locate("rake_tasks_info.rb", "org.netbeans.modules.ruby.project", false);
        if (file3 == null) {
            throw new IllegalStateException("Cannot locate rake_tasks_info.rb script");
        }
        arrayList.add(file3.getAbsolutePath());
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.directory(file);
        processBuilder.redirectErrorStream(false);
        RubyExecution.setupProcessEnvironment(processBuilder.environment(), (String)file2.getParent(), (boolean)false);
        GemManager.adjustEnvironment((RubyPlatform)rubyPlatform, processBuilder.environment());
        int n = -1;
        String string = null;
        try {
            ExecutionService.logProcess((ProcessBuilder)processBuilder);
            Process process = processBuilder.start();
            string = RakeSupport.readInputStream(process.getInputStream());
            String string2 = RakeSupport.readInputStream(process.getErrorStream());
            n = process.waitFor();
            if (n != 0) {
                LOGGER.severe("rake process failed (workdir: " + file + "):\nstdout:\n\n" + string + "stderr:\n" + string2);
                Util.notifyLocalized(RakeSupport.class, (String)"RakeSupport.rake.task.fetching.fails", (int)0, (Object[])new Object[]{file, string2});
                return null;
            }
            if (string2.length() > 0) {
                LOGGER.warning("rake process warnings:\n\n" + string2);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        return string;
    }

    private static String readInputStream(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringBuilder.toString();
    }

    static void writeRakeTasks(Project project, final String string) {
        final FileObject fileObject = project.getProjectDirectory();
        try {
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject2 = fileObject.getFileObject(RakeSupport.RAKE_D_OUTPUT);
                    if (fileObject2 != null) {
                        fileObject2.delete();
                    }
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)RakeSupport.RAKE_D_OUTPUT);
                    OutputStream outputStream = fileObject2.getOutputStream();
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                    bufferedWriter.write(string);
                    ((Writer)bufferedWriter).close();
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static final class RakeNode
    extends FilterNode {
        private Action[] actions;

        public RakeNode(FileObject fileObject) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)fileObject).getNodeDelegate());
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                this.actions = new Action[]{SystemAction.get(OpenAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return this.actions;
        }
    }
}

