/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class RakeTaskChooser
extends JPanel {
    private static final Object NO_TASK_ITEM = RakeTaskChooser.getMessage("RakeTaskChooser.no.matching.task", new String[0]);
    private static boolean debug;
    private static String lastTask;
    private static Map<String, Map<RakeTask, String>> prjToTask;
    private final RubyBaseProject project;
    private final List<RakeTask> allTasks;
    private boolean paramsEdited;
    private JButton runButton;
    private JCheckBox debugCheckbox;
    private JLabel matchingTaskLabel;
    private JList matchingTaskList;
    private JScrollPane matchingTaskSP;
    private JTextField rakeTaskField;
    private JPanel rakeTaskFieldPanel;
    private JLabel rakeTaskHint;
    private JLabel rakeTaskLabel;
    private JCheckBox showAllCheckbox;
    private JLabel taskParamLabel;
    private JTextField taskParamsField;

    static TaskDescriptor select(RubyBaseProject rubyBaseProject) {
        assert (EventQueue.isDispatchThread()) : "must be called from EDT";
        final JButton jButton = new JButton(RakeTaskChooser.getMessage("RakeTaskChooser.runButton", new String[0]));
        final RakeTaskChooser rakeTaskChooser = new RakeTaskChooser(rubyBaseProject, jButton);
        String string = RakeTaskChooser.getMessage("RakeTaskChooser.title", ProjectUtils.getInformation((Project)rubyBaseProject).getDisplayName());
        jButton.getAccessibleContext().setAccessibleDescription(RakeTaskChooser.getMessage("RakeTaskChooser.runButton.accessibleDescription", new String[0]));
        RakeTaskChooser.setRunButtonState(jButton, rakeTaskChooser);
        rakeTaskChooser.matchingTaskList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RakeTaskChooser.setRunButtonState(jButton, rakeTaskChooser);
                rakeTaskChooser.updateParameters();
            }
        });
        final JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)RakeTaskChooser.getMessage("RakeTaskChooser.refreshButton", new String[0]));
        jButton2.getAccessibleContext().setAccessibleDescription(RakeTaskChooser.getMessage("RakeTaskChooser.refreshButton.accessibleDescription", new String[0]));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.setEnabled(false);
                jButton.setEnabled(false);
                rakeTaskChooser.reloadTasks(new Runnable(){

                    public void run() {
                        assert (EventQueue.isDispatchThread()) : "is EDT";
                        jButton2.setEnabled(true);
                        RakeTaskChooser.setRunButtonState(jButton, rakeTaskChooser);
                    }
                });
            }
        });
        Object[] objectArray = new Object[]{jButton2, jButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rakeTaskChooser, string, true, objectArray, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{jButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleName(RakeTaskChooser.getMessage("RakeTaskChooser.accessibleName", new String[0]));
        dialog.getAccessibleContext().setAccessibleDescription(RakeTaskChooser.getMessage("RakeTaskChooser.accessibleDescription", new String[0]));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            RakeTask rakeTask = rakeTaskChooser.getSelectedTask();
            debug = rakeTaskChooser.debugCheckbox.isSelected();
            lastTask = rakeTask.getTask();
            rakeTaskChooser.storeParameters();
            return new TaskDescriptor(rakeTask, rakeTaskChooser.getParameters(), debug);
        }
        return null;
    }

    private String getParameters() {
        return this.taskParamsField.getText().trim();
    }

    private static void setRunButtonState(JButton jButton, RakeTaskChooser rakeTaskChooser) {
        jButton.setEnabled(rakeTaskChooser.getSelectedTask() != null);
    }

    private RakeTaskChooser(RubyBaseProject rubyBaseProject, JButton jButton) {
        this.runButton = jButton;
        this.allTasks = new ArrayList<RakeTask>();
        this.project = rubyBaseProject;
        this.initComponents();
        this.matchingTaskList.setCellRenderer(new RakeTaskRenderer());
        this.debugCheckbox.setSelected(debug);
        this.reloadAllTasks();
        this.refreshTaskList();
        this.rakeTaskField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                RakeTaskChooser.this.refreshTaskList();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                RakeTaskChooser.this.refreshTaskList();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RakeTaskChooser.this.refreshTaskList();
            }
        });
        this.taskParamsField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                RakeTaskChooser.this.paramsEdited = true;
            }

            public void keyPressed(KeyEvent keyEvent) {
                RakeTaskChooser.this.paramsEdited = true;
            }

            public void keyReleased(KeyEvent keyEvent) {
                RakeTaskChooser.this.paramsEdited = true;
            }
        });
        this.preselectLastlySelected();
        this.updateParameters();
    }

    private void initPrjToTask() {
        if (prjToTask == null) {
            prjToTask = new HashMap<String, Map<RakeTask, String>>();
        }
    }

    private void storeParameters() {
        this.initPrjToTask();
        String string = this.project.getProjectDirectory().getPath();
        Map<RakeTask, String> map = prjToTask.get(string);
        if (map == null) {
            map = new HashMap<RakeTask, String>();
            prjToTask.put(string, map);
        }
        map.put(this.getSelectedTask(), this.getParameters());
    }

    private void updateParameters() {
        if (this.paramsEdited) {
            return;
        }
        this.initPrjToTask();
        String string = this.project.getProjectDirectory().getPath();
        Map<RakeTask, String> map = prjToTask.get(string);
        if (map == null) {
            return;
        }
        String string2 = map.get(this.getSelectedTask());
        this.taskParamsField.setText(string2 == null ? "" : string2);
    }

    private void preselectLastlySelected() {
        if (lastTask == null) {
            return;
        }
        for (RakeTask rakeTask : this.allTasks) {
            if (!lastTask.equals(rakeTask.getTask())) continue;
            this.matchingTaskList.setSelectedValue(rakeTask, true);
            break;
        }
    }

    private void reloadAllTasks() {
        this.allTasks.clear();
        this.allTasks.addAll(RakeSupport.getRakeTasks(this.project, false));
    }

    private void refreshTaskList() {
        String string = this.rakeTaskField.getText().trim();
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        List<RakeTask> list = Filter.getFilteredTasks(this.allTasks, string, this.showAllCheckbox.isSelected());
        for (RakeTask rakeTask : list) {
            defaultListModel.addElement(rakeTask);
        }
        this.matchingTaskList.setModel(defaultListModel);
        if (defaultListModel.isEmpty()) {
            defaultListModel.addElement(NO_TASK_ITEM);
        }
        this.matchingTaskList.setSelectedIndex(0);
    }

    private void reloadTasks(final Runnable runnable) {
        final Object e = this.matchingTaskList.getSelectedValue();
        final JComponent[] jComponentArray = new JComponent[]{this.matchingTaskSP, this.matchingTaskLabel, this.matchingTaskLabel, this.matchingTaskList, this.rakeTaskLabel, this.rakeTaskField, this.debugCheckbox, this.taskParamLabel, this.taskParamsField, this.showAllCheckbox, this.rakeTaskHint};
        this.setEnabled(jComponentArray, false);
        this.matchingTaskList.setListData(new Object[]{RakeTaskChooser.getMessage("RakeTaskChooser.reloading.tasks", new String[0])});
        new Thread(new Runnable(){

            public void run() {
                RakeSupport.refreshTasks(RakeTaskChooser.this.project);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        RakeTaskChooser.this.reloadAllTasks();
                        RakeTaskChooser.this.refreshTaskList();
                        RakeTaskChooser.this.matchingTaskList.setSelectedValue(e, true);
                        runnable.run();
                        RakeTaskChooser.this.setEnabled(jComponentArray, true);
                        RakeTaskChooser.this.rakeTaskField.requestFocus();
                    }
                });
            }
        }, "Rake Tasks Refresher").start();
    }

    private void setEnabled(JComponent[] jComponentArray, boolean bl) {
        for (JComponent jComponent : jComponentArray) {
            jComponent.setEnabled(bl);
        }
    }

    private RakeTask getSelectedTask() {
        Object e = this.matchingTaskList.getSelectedValue();
        if (e != null && !NO_TASK_ITEM.equals(e)) {
            return (RakeTask)e;
        }
        return null;
    }

    private static String getMessage(String string, String ... stringArray) {
        return NbBundle.getMessage(RakeTaskChooser.class, (String)string, (Object[])stringArray);
    }

    private void initComponents() {
        this.rakeTaskLabel = new JLabel();
        this.taskParamLabel = new JLabel();
        this.taskParamsField = new JTextField();
        this.matchingTaskLabel = new JLabel();
        this.matchingTaskSP = new JScrollPane();
        this.matchingTaskList = new JList();
        this.debugCheckbox = new JCheckBox();
        this.showAllCheckbox = new JCheckBox();
        this.rakeTaskFieldPanel = new JPanel();
        this.rakeTaskField = new JTextField();
        this.rakeTaskHint = new JLabel();
        this.rakeTaskLabel.setLabelFor(this.rakeTaskField);
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskLabel, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.rakeTaskLabel.text"));
        this.taskParamLabel.setLabelFor(this.taskParamsField);
        Mnemonics.setLocalizedText((JLabel)this.taskParamLabel, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.taskParamLabel.text"));
        this.taskParamsField.setText(NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.taskParamsField.text"));
        this.taskParamsField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RakeTaskChooser.this.taskParamsFieldKeyPressed(keyEvent);
            }
        });
        this.matchingTaskLabel.setLabelFor(this.matchingTaskList);
        Mnemonics.setLocalizedText((JLabel)this.matchingTaskLabel, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.matchingTaskLabel.text"));
        this.matchingTaskList.setFont(new Font("Monospaced", 0, 12));
        this.matchingTaskList.setSelectionMode(0);
        this.matchingTaskList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                RakeTaskChooser.this.matchingTaskListMouseClicked(mouseEvent);
            }
        });
        this.matchingTaskSP.setViewportView(this.matchingTaskList);
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckbox, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.debugCheckbox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.showAllCheckbox, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.showAllCheckbox.text"));
        this.showAllCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RakeTaskChooser.this.showAllCheckboxActionPerformed(actionEvent);
            }
        });
        this.rakeTaskFieldPanel.setLayout(new BorderLayout());
        this.rakeTaskField.setText(NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.rakeTaskField.text"));
        this.rakeTaskField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                RakeTaskChooser.this.rakeTaskFieldKeyPressed(keyEvent);
            }
        });
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskField, "North");
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskHint, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.rakeTaskHint.text"));
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskHint, "South");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rakeTaskLabel).add((Component)this.taskParamLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rakeTaskFieldPanel, -1, 558, Short.MAX_VALUE).add((Component)this.taskParamsField, -1, 558, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.matchingTaskLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.debugCheckbox).addPreferredGap(0).add((Component)this.showAllCheckbox)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.matchingTaskSP, -1, 659, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rakeTaskLabel).add((Component)this.rakeTaskFieldPanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.taskParamsField, -2, -1, -2).add((Component)this.taskParamLabel)).addPreferredGap(1).add((Component)this.matchingTaskLabel).addPreferredGap(0).add((Component)this.matchingTaskSP, -1, 346, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.debugCheckbox).add((Component)this.showAllCheckbox)).addContainerGap()));
    }

    private void handleNavigationKeys(KeyEvent keyEvent) {
        Object object = this.matchingTaskList.getInputMap().get(KeyStroke.getKeyStrokeForEvent(keyEvent));
        boolean bl = "selectPreviousRow".equals(object) || "selectPreviousRowExtendSelection".equals(object) || "selectNextRow".equals(object) || "selectNextRowExtendSelection".equals(object) || "scrollUp".equals(object) || "scrollUpExtendSelection".equals(object) || "scrollDown".equals(object) || "scrollDownExtendSelection".equals(object);
        int n = this.matchingTaskList.getSelectedIndex();
        ListModel listModel = this.matchingTaskList.getModel();
        int n2 = listModel.getSize();
        if ("selectNextRow".equals(object) && n == n2 - 1) {
            this.matchingTaskList.setSelectedIndex(0);
            this.matchingTaskList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(object) && n == 0) {
            int n3 = n2 - 1;
            this.matchingTaskList.setSelectedIndex(n3);
            this.matchingTaskList.ensureIndexIsVisible(n3);
            return;
        }
        if (bl) {
            Action action = this.matchingTaskList.getActionMap().get(object);
            action.actionPerformed(new ActionEvent(this.matchingTaskList, 0, (String)object));
            keyEvent.consume();
        }
    }

    private void rakeTaskFieldKeyPressed(KeyEvent keyEvent) {
        this.handleNavigationKeys(keyEvent);
    }

    private void showAllCheckboxActionPerformed(ActionEvent actionEvent) {
        this.refreshTaskList();
    }

    private void taskParamsFieldKeyPressed(KeyEvent keyEvent) {
        this.handleNavigationKeys(keyEvent);
    }

    private void matchingTaskListMouseClicked(MouseEvent mouseEvent) {
        if (this.runButton.isEnabled() && mouseEvent.getClickCount() == 2) {
            this.runButton.doClick();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Filter {
        private final String filter;
        private final List<RakeTask> tasks;
        private final boolean showAll;

        private Filter(List<RakeTask> list, String string, boolean bl) {
            this.tasks = list;
            this.filter = string;
            this.showAll = bl;
        }

        static List<RakeTask> getFilteredTasks(List<RakeTask> list, String string, boolean bl) {
            Filter filter = new Filter(list, string, bl);
            return filter.filter();
        }

        private List<RakeTask> filter() {
            ArrayList<RakeTask> arrayList = new ArrayList<RakeTask>();
            Pattern pattern = this.getPattern();
            if (pattern != null) {
                for (RakeTask rakeTask : this.tasks) {
                    Matcher matcher;
                    if (!this.showAll && rakeTask.getDescription() == null || !(matcher = pattern.matcher(rakeTask.getTask())).matches()) continue;
                    arrayList.add(rakeTask);
                }
            } else {
                ArrayList<RakeTask> arrayList2 = new ArrayList<RakeTask>();
                for (RakeTask rakeTask : this.tasks) {
                    String string;
                    if (!this.showAll && rakeTask.getDescription() == null) continue;
                    String string2 = rakeTask.getTask().toLowerCase(Locale.US);
                    if (string2.startsWith(string = this.filter.toLowerCase(Locale.US))) {
                        arrayList2.add(rakeTask);
                        continue;
                    }
                    if (!string2.contains(string)) continue;
                    arrayList.add(rakeTask);
                }
                arrayList.addAll(0, arrayList2);
            }
            return arrayList;
        }

        private Pattern getPattern() {
            if (this.filter.contains("?") || this.filter.contains("*")) {
                String string = Filter.removeRegexpEscapes(this.filter);
                string = string.replace(".", "\\.");
                string = string.replace("?", ".");
                string = string.replace("*", ".*");
                return Pattern.compile(".*" + string + ".*", 2);
            }
            return null;
        }

        private static String removeRegexpEscapes(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            block3: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\\': {
                        continue block3;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
    }

    private static class RakeTaskRenderer
    extends JLabel
    implements ListCellRenderer {
        public RakeTaskRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            Object object3;
            this.setName("ComboBox.listRenderer");
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                object3 = jList.getBackground();
                object2 = new Color(Math.abs(((Color)object3).getRed() - 10), Math.abs(((Color)object3).getGreen() - 10), Math.abs(((Color)object3).getBlue() - 10));
                this.setBackground((Color)(n % 2 == 0 ? object3 : object2));
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            if (object instanceof RakeTask) {
                object3 = (RakeTask)object;
                object2 = ((RakeTask)object3).getDescription();
                if (object2 == null) {
                    this.setForeground(Color.GRAY);
                }
                StringBuilder stringBuilder = new StringBuilder("<html>");
                stringBuilder.append("<b>").append(((RakeTask)object3).getTask()).append("</b>");
                if (object2 != null) {
                    stringBuilder.append(" : ").append((String)object2);
                }
                stringBuilder.append("</html>");
                this.setText(stringBuilder.toString());
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    static class TaskDescriptor {
        private final RakeTask task;
        private final String params;
        private final boolean debug;

        TaskDescriptor(RakeTask rakeTask, String string, boolean bl) {
            this.task = rakeTask;
            this.params = string.length() == 0 ? null : string;
            this.debug = bl;
        }

        RakeTask getRakeTask() {
            return this.task;
        }

        String getTaskParams() {
            return this.params;
        }

        boolean isDebug() {
            return this.debug;
        }
    }
}

