/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.rubyproject.ui.FoldersListSettings;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private final PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculatePF;
    private JButton browseButton;
    private JLabel description;
    private JPanel projectInfoPanel;
    private JTextField projectLocation;
    private JLabel projectLocationLabel;
    private JTextField projectName;
    private JLabel projectNameLabel;

    public PanelProjectLocationExtSrc(PanelConfigureProject panelConfigureProject) {
        this.firer = panelConfigureProject;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
        this.projectLocation.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectFolder() {
        if (this.calculatePF) {
            File file = ProjectChooser.getProjectsFolder();
            this.projectLocation.setText(file.getAbsolutePath() + File.separator + this.projectName.getText());
            this.calculatePF = true;
        }
    }

    private synchronized void setCalculateProjectFolder(boolean bl) {
        this.calculatePF = bl;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        String string = null;
        File file = (File)wizardDescriptor.getProperty("projdir");
        if (file == null) {
            File file2;
            file = ProjectChooser.getProjectsFolder();
            int n = FoldersListSettings.getDefault().getNewProjectCount();
            String string2 = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_JavaProject");
            while ((file2 = new File(file, string = MessageFormat.format(string2, ++n))).exists()) {
            }
            wizardDescriptor.putProperty("nameIndex", (Object)n);
            this.projectLocation.setText(file.getAbsolutePath());
            this.setCalculateProjectFolder(true);
        } else {
            string = (String)wizardDescriptor.getProperty("name");
            boolean bl = this.calculatePF;
            this.projectLocation.setText(file.getAbsolutePath());
            this.setCalculateProjectFolder(bl);
        }
        this.projectName.setText(string);
        this.projectName.selectAll();
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("name", (Object)this.projectName.getText());
        File file = new File(this.projectLocation.getText());
        wizardDescriptor.putProperty("projdir", (Object)file);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String string = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText(), this.projectLocation.getText());
        if (string == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            File file = new File(this.projectLocation.getText(), "config" + File.separator + "environment.rb");
            if (file.exists()) {
                String string2 = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ProbablyRails");
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
            }
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return false;
    }

    static String checkValidity(String string, String string2) {
        int n;
        Object object;
        if (string.length() == 0 || string.indexOf(47) > 0 || string.indexOf(92) > 0 || string.indexOf(58) > 0) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectName");
        }
        File file = new File(string2).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file) == null) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_IllegalProjectLocation");
        }
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        if (file == null || !file.canWrite()) {
            return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderReadOnly");
        }
        File file2 = FileUtil.normalizeFile((File)new File(string2));
        File[] fileArray = file2.listFiles();
        if (file2.exists() && fileArray != null && fileArray.length > 0) {
            object = null;
            for (n = 0; n < fileArray.length; ++n) {
                String string3 = fileArray[n].getName();
                if ("nbproject".equals(string3)) {
                    object = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"TXT_NetBeansProject");
                }
                if (object == null) continue;
                String string4 = NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(string4, object);
            }
        }
        if (file2.isDirectory()) {
            object = FileUtil.toFileObject((File)file2);
            assert (object != null) : "No FileObject for " + file2;
            n = 0;
            try {
                n = ProjectManager.getDefault().findProject(object) == null ? 1 : 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n == 0) {
                return NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"MSG_ProjectFolderHasDeletedProject");
            }
        }
        return null;
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private void initComponents() {
        this.projectInfoPanel = new JPanel();
        this.description = new JLabel();
        this.projectNameLabel = new JLabel();
        this.projectName = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocation = new JTextField();
        this.browseButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.projectInfoPanel.setLayout(new GridBagLayout());
        this.description.setLabelFor(this.projectInfoPanel);
        Mnemonics.setLocalizedText((JLabel)this.description, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_ProjectNameAndLocationLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.projectInfoPanel.add((Component)this.description, gridBagConstraints);
        this.description.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.description.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.projectNameLabel.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.projectInfoPanel.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.projectInfoPanel.add((Component)this.projectName, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.projectInfoPanel.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.projectInfoPanel.add((Component)this.projectLocation, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_BrowseLocation_Button3"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.projectInfoPanel.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.projectInfoPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void browseProjectLocation(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_SelectProjectLocation"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocation.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }
}

