/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActiveDocumentSupport {
    private static final DesignEventFilter FILTER_SELECTION = new DesignEventFilter(new DesignEventFilter[0]).setSelection(true);
    private static final ActiveDocumentSupport support = new ActiveDocumentSupport();
    private final WeakSet<Listener> listeners = new WeakSet();
    private DesignDocument activeDocument = null;
    private DesignListener selectionListener = null;
    private Collection<DesignComponent> activeComponents = Collections.emptySet();

    private ActiveDocumentSupport() {
    }

    public static ActiveDocumentSupport getDefault() {
        return support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveDocumentListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveDocumentListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.remove((Object)listener);
        }
    }

    public DesignDocument getActiveDocument() {
        return this.activeDocument;
    }

    public Collection<DesignComponent> getActiveComponents() {
        return this.activeComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActiveDocumentChanged(DesignDocument designDocument, final DesignDocument designDocument2) {
        Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Listener[] listenerArray2 = (Listener[])this.listeners.toArray((Object[])new Listener[this.listeners.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (Listener listener : listenerArray2) {
                if (listener == null) continue;
                listener.activeDocumentChanged(designDocument, designDocument2);
            }
            if (designDocument != designDocument2) {
                if (designDocument != null) {
                    if (this.selectionListener == null) {
                        Debug.warning("SelectionListener does not exist but it should");
                    } else {
                        designDocument.getListenerManager().removeDesignListener(this.selectionListener);
                    }
                }
                if (designDocument2 != null) {
                    designDocument2.getTransactionManager().readAccess(new Runnable(){

                        public void run() {
                            designDocument2.getListenerManager().addDesignListener(ActiveDocumentSupport.this.selectionListener = new SelectionDesignListener(designDocument2), FILTER_SELECTION);
                            ActiveDocumentSupport.this.fireActiveComponentsChanged(designDocument2.getSelectedComponents());
                        }
                    });
                } else {
                    this.fireActiveComponentsChanged(Collections.<DesignComponent>emptyList());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActiveComponentsChanged(Collection<DesignComponent> collection) {
        this.activeComponents = collection;
        Listener[] listenerArray = this.listeners;
        synchronized (this.listeners) {
            Listener[] listenerArray2 = (Listener[])this.listeners.toArray((Object[])new Listener[this.listeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Listener listener : listenerArray2) {
                if (listener == null) continue;
                listener.activeComponentsChanged(collection);
            }
            return;
        }
    }

    public void setActiveDocument(DesignDocument designDocument) {
        if (this.activeDocument == designDocument) {
            return;
        }
        DesignDocument designDocument2 = this.activeDocument;
        this.activeDocument = designDocument;
        this.fireActiveDocumentChanged(designDocument2, this.activeDocument);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DocumentObserver
    implements Listener {
        private DocumentObserver() {
        }

        @Override
        public void activeDocumentChanged(DesignDocument designDocument, DesignDocument designDocument2) {
        }

        @Override
        public void activeComponentsChanged(Collection<DesignComponent> collection) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void activeDocumentChanged(DesignDocument var1, DesignDocument var2);

        public void activeComponentsChanged(Collection<DesignComponent> var1);
    }

    private class SelectionDesignListener
    implements DesignListener {
        private DesignDocument document;

        public SelectionDesignListener(DesignDocument designDocument) {
            this.document = designDocument;
        }

        public void designChanged(DesignEvent designEvent) {
            ActiveDocumentSupport.this.fireActiveComponentsChanged(this.document.getSelectedComponents());
        }
    }
}

