/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.httpfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.netbeans.modules.javadoc.httpfs.HTTPFileObject;
import org.netbeans.modules.javadoc.httpfs.HTTPFileSystem;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class HTTPRootFileObject
extends HTTPFileObject
implements Runnable {
    private static final String IDE_SETTINGS_NAME = "Services/org-netbeans-core-IDESettings.settings";
    private Thread refreshThread;
    private Date lastRefreshDate;
    private boolean threadIsRunning;
    private boolean refreshPending;
    private static boolean proxyInit;

    HTTPRootFileObject(HTTPFileSystem hTTPFileSystem) {
        super("/", hTTPFileSystem);
        this.refreshThread = new Thread(this);
        this.threadIsRunning = true;
        this.refreshPending = false;
        this.refreshThread.start();
    }

    protected HTTPRootFileObject() {
    }

    void triggerRefresh() {
        this.refreshPending = true;
        this.refreshThread.interrupt();
    }

    public void run() {
        this.refreshRootContents();
        this.refreshThread.setPriority(1);
        while (this.threadIsRunning) {
            boolean bl = false;
            int n = this.parentFileSystem.getRefreshRate();
            if (n > 0) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(this.lastRefreshDate);
                ((Calendar)gregorianCalendar).add(12, n);
                if (gregorianCalendar.before(new GregorianCalendar())) {
                    bl = this.hasDocumentationChanged();
                }
            }
            if (bl || this.refreshPending) {
                this.refreshPending = false;
                this.refreshRootContents();
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean hasDocumentationChanged() {
        boolean bl;
        HTTPFileObject hTTPFileObject = this.child("package-list", false);
        if (hTTPFileObject != null) {
            try {
                Date date = hTTPFileObject.lastModified();
                HttpURLConnection httpURLConnection = (HttpURLConnection)hTTPFileObject.fileURL.openConnection();
                httpURLConnection.setRequestMethod("HEAD");
                bl = date.before(new Date(httpURLConnection.getLastModified()));
                httpURLConnection.disconnect();
            }
            catch (IOException iOException) {
                bl = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void refreshRootContents() {
        HTTPRootFileObject.initHTTPProxyHack();
        this.parentFileSystem.setState(1);
        this.removeAllChildren();
        if (this.addOptionalChild("/package-list")) {
            HTTPFileObject hTTPFileObject = this.child("package-list", false);
            this.addChild("/allclasses-frame.html");
            this.addOptionalChild("/deprecated-list.html");
            this.addOptionalChild("/help-doc.html");
            this.addOptionalChild("/index.html");
            this.addChild("/overview-frame.html");
            this.addChild("/overview-summary.html");
            this.addOptionalChild("/overview-tree.html");
            this.addChild("/packages.html");
            this.addChild("/serialized-form.html");
            this.addChild("/stylesheet.css");
            if (!this.addOptionalChild("/index-all.html")) {
                int n = 1;
                while (this.addOptionalChild("/index-" + n + ".html")) {
                    ++n;
                }
                if (n == 1) {
                    HTTPFileObject hTTPFileObject2 = new HTTPFileObject("/index-files/", this.parentFileSystem);
                    if (!hTTPFileObject2.addOptionalChild("/index-files/index-all.html")) {
                        n = 1;
                        while (hTTPFileObject2.addOptionalChild("/index-files/index-" + n + ".html")) {
                            ++n;
                        }
                        if (n != 1) {
                            this.addChild(hTTPFileObject2);
                        }
                    } else {
                        this.addChild(hTTPFileObject2);
                    }
                }
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(hTTPFileObject.getInputStream()));
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.addPackage(string);
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lastRefreshDate = new Date();
        this.parentFileSystem.setState(2);
    }

    private void addPackage(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        HTTPFileObject hTTPFileObject = this;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (hTTPFileObject.child(string2, false) == null) {
                hTTPFileObject.addChild(hTTPFileObject.uriStem + string2 + "/");
            }
            hTTPFileObject = hTTPFileObject.child(string2, false);
        }
        hTTPFileObject.makePackage();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.threadIsRunning = false;
        this.refreshThread.interrupt();
    }

    static void initHTTPProxyHack() {
        if (proxyInit) {
            return;
        }
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(IDE_SETTINGS_NAME);
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            if (instanceCookie != null) {
                Object object = instanceCookie.instanceCreate();
                proxyInit = true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IOException iOException) {
            proxyInit = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            proxyInit = true;
        }
    }
}

