/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ImportCDCProjectPanel
extends JPanel
implements DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    static final String PROJECT_LOCATION = "ImportProjectLocation";
    private static String prjType;
    private static String location;
    private JButton bBrowse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JTextField tLocation;

    private ImportCDCProjectPanel(String string) {
        prjType = string;
        this.initComponents();
        this.initAccessibility();
    }

    public synchronized void addListener(DocumentListener documentListener) {
        this.tLocation.getDocument().addDocumentListener(documentListener);
    }

    public synchronized void removeListener(DocumentListener documentListener) {
        this.tLocation.getDocument().removeDocumentListener(documentListener);
    }

    public synchronized void readData(TemplateWizard templateWizard) {
        Object object = templateWizard.getProperty(PROJECT_LOCATION);
        if (object != null) {
            this.tLocation.setText((String)object);
        } else {
            FileObject fileObject = Templates.getExistingSourcesFolder((WizardDescriptor)templateWizard);
            File file = fileObject == null ? null : FileUtil.toFile((FileObject)fileObject);
            this.tLocation.setText(file == null ? "" : file.getAbsolutePath());
        }
    }

    public synchronized void storeData(TemplateWizard templateWizard) {
        String string = this.tLocation.getText();
        templateWizard.putProperty(PROJECT_LOCATION, (Object)string);
        String string2 = new File(string).getName();
        templateWizard.putProperty("ProjectName", (Object)("Imported Project" + (string2 != null ? " - " + string2 + '1' : "1")));
        String string3 = null;
        String string4 = null;
        HashMap hashMap = new HashMap();
        string3 = (String)hashMap.get("MicroEdition-Configuration");
        string4 = (String)hashMap.get("MicroEdition-Profile");
        templateWizard.putProperty("RequiredConfiguration", (Object)string3);
        templateWizard.putProperty("RequiredProfile", (Object)string4);
    }

    public String getLocationText() {
        return this.tLocation.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowse = new JButton();
        this.jPanel2 = new JPanel();
        this.setName(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"TITLE_Project", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"LBL_Import_Info", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.jLabel1.setVerticalAlignment(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ASCD_Import_Info", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.jLabel2.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"LBL_Project_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSD_Project_Location", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"LBL_Project_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImportCDCProjectPanel.this.bBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSD_Project_Browse1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSN_Project", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ACSD_Project", (Object)(prjType.equals("org.netbeans.modules.j2me.cdc.nbproject") ? "CDC Pack 5.5" : "CDC Toolkit")));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseActionPerformed(ActionEvent actionEvent) {
        String string;
        if (location == null) {
            location = this.tLocation.getText();
        }
        if (location == null || "".equals(location)) {
            location = System.getProperty("user.home", "");
        }
        File file = ProjectChooser.getProjectsFolder();
        ProjectChooser.setProjectsFolder((File)new File(location));
        JFileChooser jFileChooser = ImportCDCProjectPanel.createProjectChooser();
        if (0 == jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) && (string = jFileChooser.getSelectedFile().getAbsolutePath()) != null) {
            this.tLocation.setText(string);
            location = new File(string).getParent();
        }
        ProjectChooser.setProjectsFolder((File)file);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private static boolean isOldProject(FileObject fileObject, String string) {
        FileObject fileObject2 = fileObject.getFileObject("nbproject/project.xml");
        FileObject fileObject3 = fileObject.getFileObject("nbproject/project.properties");
        if (fileObject2 != null && fileObject3 != null) {
            File file = FileUtil.toFile((FileObject)fileObject2);
            try {
                Document document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
                NodeList nodeList = document.getElementsByTagNameNS("http://www.netbeans.org/ns/project/1", "type");
                return nodeList.item(0).getTextContent().equals(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static JFileChooser createProjectChooser() {
        ProjectManager.getDefault().clearNonProjectCache();
        ProjectFileChooser projectFileChooser = new ProjectFileChooser();
        projectFileChooser.setFileSelectionMode(1);
        if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            projectFileChooser.putClientProperty("GTKFileChooser.showDirectoryIcons", Boolean.TRUE);
        }
        projectFileChooser.setAcceptAllFileFilterUsed(false);
        projectFileChooser.setFileFilter(ProjectDirFilter.INSTANCE);
        File file = ProjectChooser.getProjectsFolder();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)projectFileChooser, (File)file);
        projectFileChooser.setFileView(new ProjectFileView(projectFileChooser.getFileSystemView()));
        return projectFileChooser;
    }

    private static class ProjectDirFilter
    extends FileFilter {
        private static final FileFilter INSTANCE = new ProjectDirFilter();

        private ProjectDirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return "";
        }
    }

    private static class ProjectFileChooser
    extends JFileChooser {
        private ProjectFileChooser() {
        }

        public void approveSelection() {
            File file = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (file != null && ImportCDCProjectPanel.isOldProject(FileUtil.toFileObject((File)file), prjType)) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(file);
            }
        }
    }

    private static class MergedIcon
    implements Icon {
        private Icon icon1;
        private Icon icon2;
        private int xMerge;
        private int yMerge;

        MergedIcon(Icon icon, Icon icon2, int n, int n2) {
            this.icon1 = icon;
            this.icon2 = icon2;
            if (n == -1) {
                n = icon.getIconWidth() - icon2.getIconWidth();
            }
            if (n2 == -1) {
                n2 = icon.getIconHeight() - icon2.getIconHeight();
            }
            this.xMerge = n;
            this.yMerge = n2;
        }

        public int getIconHeight() {
            return Math.max(this.icon1.getIconHeight(), this.yMerge + this.icon2.getIconHeight());
        }

        public int getIconWidth() {
            return Math.max(this.icon1.getIconWidth(), this.yMerge + this.icon2.getIconWidth());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon1.paintIcon(component, graphics, n, n2);
            this.icon2.paintIcon(component, graphics, n + this.xMerge, n2 + this.yMerge);
        }
    }

    private static class ProjectFileView
    extends FileView {
        private final FileSystemView fsv;
        private static final Icon BADGE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/j2me/cdc/project/resources/projectBadge.gif"));
        private static final Icon EMPTY = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/empty.gif"));
        private Icon lastOriginal;
        private Icon lastMerged;

        public ProjectFileView(FileSystemView fileSystemView) {
            this.fsv = fileSystemView;
        }

        public Icon getIcon(File file) {
            FileObject fileObject;
            if (!file.exists()) {
                return null;
            }
            File file2 = FileUtil.normalizeFile((File)file);
            Icon icon = this.fsv.getSystemIcon(file2);
            if (icon == null) {
                icon = EMPTY;
            }
            if ((fileObject = FileUtil.toFileObject((File)file2)) != null && ImportCDCProjectPanel.isOldProject(fileObject, prjType)) {
                if (icon.equals(this.lastOriginal)) {
                    return this.lastMerged;
                }
                this.lastOriginal = icon;
                this.lastMerged = new MergedIcon(icon, BADGE, -1, -1);
                return this.lastMerged;
            }
            return icon;
        }
    }

    static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener {
        ImportCDCProjectPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;
        final String prjType;

        public WizardPanel(String string) {
            this.prjType = string;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new ImportCDCProjectPanel(this.prjType);
                this.component.addListener(this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(ImportCDCProjectPanel.class);
        }

        public boolean isFinishPanel() {
            return false;
        }

        public void showError(String string) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }

        public boolean isValid() {
            boolean bl;
            File file = FileUtil.normalizeFile((File)new File(this.component.getLocationText()).getAbsoluteFile());
            boolean bl2 = bl = this.component.getLocationText().length() > 0 && file != null && file.exists() && file.isDirectory() && ImportCDCProjectPanel.isOldProject(FileUtil.toFileObject((File)file), prjType);
            if (!bl) {
                this.showError(NbBundle.getMessage(ImportCDCProjectPanel.class, (String)"ERR_Project_InvalidLocation"));
                return false;
            }
            this.showError(null);
            return true;
        }

        public void readSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((ImportCDCProjectPanel)this.getComponent()).readData(this.wizard);
            Component component = this.getComponent();
            Object object2 = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.wizard.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((ImportCDCProjectPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.checkValid();
        }
    }
}

