/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.faces.data;

import com.sun.rave.faces.data.DataCache;
import com.sun.rave.faces.util.ComponentBundle;
import java.beans.Beans;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.model.SelectItem;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class ResultSetPropertyResolver
extends PropertyResolver {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(ResultSetPropertyResolver.class);
    public static final String CURRENT_ROW_KEY = "currentRow";
    public static final String SELECT_ITEMS_KEY = "selectItems";
    protected PropertyResolver nested;

    public ResultSetPropertyResolver(PropertyResolver nested) {
        this.nested = nested;
    }

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        Object o;
        if (base instanceof ResultSet) {
            if (CURRENT_ROW_KEY.equals(property)) {
                return new RowData((ResultSet)base);
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                return new ColumnData((ResultSet)base);
            }
        } else {
            if (base instanceof RowData) {
                return ((RowData)base).getData(property.toString());
            }
            if (base instanceof ColumnData) {
                return ((ColumnData)base).getSelectItems(property.toString());
            }
        }
        if ((o = this.nested.getValue(base, property)) instanceof ResultSet) {
            ResultSetPropertyResolver.initResultSet((ResultSet)o);
        }
        return o;
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        Object o = this.nested.getValue(base, index);
        if (o instanceof ResultSet) {
            ResultSetPropertyResolver.initResultSet((ResultSet)o);
        }
        return o;
    }

    public void setValue(Object base, Object property, Object value) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof RowData) {
            ((RowData)base).setData(property.toString(), value);
            return;
        }
        this.nested.setValue(base, property, value);
    }

    public void setValue(Object base, int index, Object value) throws EvaluationException, PropertyNotFoundException {
        this.nested.setValue(base, index, value);
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof ResultSet && (CURRENT_ROW_KEY.equals(property) || SELECT_ITEMS_KEY.equals(property))) {
            return true;
        }
        if (base instanceof RowData) {
            return false;
        }
        if (base instanceof ColumnData) {
            return true;
        }
        return this.nested.isReadOnly(base, property);
    }

    public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        return this.nested.isReadOnly(base, index);
    }

    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof ResultSet) {
            if (CURRENT_ROW_KEY.equals(property)) {
                return RowData.class;
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                return ColumnData.class;
            }
        } else {
            if (base instanceof RowData) {
                return ((RowData)base).getDataType(property.toString());
            }
            if (base instanceof ColumnData) {
                return ArrayList.class;
            }
            if (base instanceof DataCache.Row && property instanceof String) {
                Class typeAccordingToNested = this.nested.getType(base, property);
                if (typeAccordingToNested != null) {
                    return typeAccordingToNested;
                }
                DataCache.Row row = (DataCache.Row)base;
                DataCache.Column[] columns = row.getColumns();
                for (int i = 0; columns != null && i < columns.length; ++i) {
                    if (!((String)property).equalsIgnoreCase(columns[i].getColumnName())) continue;
                    return columns[i].getJavaType();
                }
                return null;
            }
        }
        return this.nested.getType(base, property);
    }

    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        return this.nested.getType(base, index);
    }

    public static void initResultSet(ResultSet resultSet) {
    }

    private static Object getFakeData(ResultSetMetaData rsmd, String colName) throws SQLException {
        int colIndex = -1;
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (!rsmd.getColumnName(i).equals(colName)) continue;
            colIndex = i;
            break;
        }
        switch (rsmd.getColumnType(colIndex)) {
            case 2003: {
                return new Array(){

                    public Object getArray() {
                        return null;
                    }

                    public Object getArray(long index, int count) {
                        return null;
                    }

                    public Object getArray(long index, int count, Map map) {
                        return null;
                    }

                    public Object getArray(Map map) {
                        return null;
                    }

                    public int getBaseType() {
                        return 1;
                    }

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public ResultSet getResultSet() {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count) {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count, Map map) {
                        return null;
                    }

                    public ResultSet getResultSet(Map map) {
                        return null;
                    }

                    public void free() {
                    }
                };
            }
            case -5: {
                return new Long(123L);
            }
            case -2: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -7: {
                return new Boolean(true);
            }
            case 2004: {
                return new SerialBlob(new byte[]{1, 2, 3, 4, 5});
            }
            case 16: {
                return new Boolean(true);
            }
            case 1: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case 2005: {
                return new SerialClob(bundle.getMessage("arbitraryClobData").toCharArray());
            }
            case 70: {
                try {
                    return new URL("http://www.sun.com");
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            case 91: {
                return new Date(new java.util.Date().getTime());
            }
            case 3: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 2001: {
                return null;
            }
            case 8: {
                return new Double(123.0);
            }
            case 6: {
                return new Double(123.0);
            }
            case 4: {
                return new Integer(123);
            }
            case 2000: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case -4: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -1: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
            case 0: {
                return null;
            }
            case 2: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 1111: {
                return null;
            }
            case 7: {
                return new Float(123.0f);
            }
            case 2006: {
                return new Ref(){
                    private Object data = new String(ResultSetPropertyResolver.access$100().getMessage("arbitraryCharData"));

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public Object getObject() {
                        return this.data;
                    }

                    public Object getObject(Map map) {
                        return this.data;
                    }

                    public void setObject(Object value) {
                        this.data = value;
                    }
                };
            }
            case 5: {
                return new Short(123);
            }
            case 2002: {
                return new Struct(){
                    private String[] data = new String[]{ResultSetPropertyResolver.access$100().getMessage("arbitraryCharData"), ResultSetPropertyResolver.access$100().getMessage("arbitraryCharData2"), ResultSetPropertyResolver.access$100().getMessage("arbitraryCharData3")};

                    public Object[] getAttributes() {
                        return this.data;
                    }

                    public Object[] getAttributes(Map map) {
                        return this.data;
                    }

                    public String getSQLTypeName() {
                        return "CHAR";
                    }
                };
            }
            case 92: {
                return new Time(new java.util.Date().getTime());
            }
            case 93: {
                return new Timestamp(new java.util.Date().getTime());
            }
            case -6: {
                return new Byte(123);
            }
            case -3: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case 12: {
                return new String(bundle.getMessage("arbitraryCharData"));
            }
        }
        return null;
    }

    static /* synthetic */ ComponentBundle access$100() {
        return bundle;
    }

    public class ColumnData {
        protected ResultSet resultSet;
        protected ResultSetMetaData metadata;

        public ColumnData(ResultSet resultSet) {
            this.resultSet = resultSet;
            try {
                this.metadata = resultSet.getMetaData();
            }
            catch (SQLException x) {
                throw new FacesException((Throwable)x);
            }
        }

        public Object getSelectItems(String columns) {
            ArrayList<SelectItem> list;
            block22: {
                String[] args;
                String col;
                String itemValueName = null;
                String itemLabelName = null;
                String itemDescriptionName = null;
                ArrayList<String> cols = new ArrayList<String>();
                boolean quoteOpen = false;
                int currStart = 0;
                for (int i = 0; i < columns.length(); ++i) {
                    char c = columns.charAt(i);
                    if (c == '\'') {
                        quoteOpen = !quoteOpen;
                        continue;
                    }
                    if (c != ',' || quoteOpen) continue;
                    col = columns.substring(currStart, i);
                    if (col.length() > 0) {
                        cols.add(col);
                    }
                    currStart = i + 1;
                }
                if (currStart < columns.length()) {
                    col = columns.substring(currStart);
                    cols.add(col);
                }
                if ((args = cols.toArray(new String[cols.size()])).length < 1) {
                    throw new IllegalArgumentException();
                }
                itemValueName = args[0];
                if (args.length > 1) {
                    itemLabelName = args[1];
                }
                if (args.length > 2) {
                    itemDescriptionName = args[2];
                }
                list = new ArrayList<SelectItem>();
                if (!Beans.isDesignTime()) {
                    try {
                        ResultSetPropertyResolver.initResultSet(this.resultSet);
                        int resultSetIndexSave = this.resultSet.getRow();
                        this.resultSet.first();
                        while (!this.resultSet.isAfterLast()) {
                            if (itemLabelName == null) {
                                list.add(new SelectItem(this.resultSet.getObject(itemValueName)));
                            } else if (itemDescriptionName == null) {
                                list.add(new SelectItem(this.resultSet.getObject(itemValueName), this.resultSet.getObject(itemLabelName).toString()));
                            } else {
                                list.add(new SelectItem(this.resultSet.getObject(itemValueName), this.resultSet.getObject(itemLabelName).toString(), this.resultSet.getObject(itemDescriptionName).toString()));
                            }
                            this.resultSet.next();
                        }
                        if (resultSetIndexSave > 0) {
                            this.resultSet.absolute(resultSetIndexSave);
                            break block22;
                        }
                        this.resultSet.first();
                    }
                    catch (SQLException x) {
                        x.printStackTrace();
                    }
                } else {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            if (itemLabelName == null) {
                                list.add(new SelectItem(ResultSetPropertyResolver.getFakeData(this.metadata, itemValueName)));
                                continue;
                            }
                            if (itemDescriptionName == null) {
                                list.add(new SelectItem(ResultSetPropertyResolver.getFakeData(this.metadata, itemValueName), ResultSetPropertyResolver.getFakeData(this.metadata, itemLabelName).toString()));
                                continue;
                            }
                            list.add(new SelectItem(ResultSetPropertyResolver.getFakeData(this.metadata, itemValueName), ResultSetPropertyResolver.getFakeData(this.metadata, itemLabelName).toString(), ResultSetPropertyResolver.getFakeData(this.metadata, itemDescriptionName).toString()));
                            continue;
                        }
                        catch (SQLException x) {
                            // empty catch block
                        }
                    }
                }
            }
            return list;
        }
    }

    public class RowData {
        protected ResultSet resultSet;
        protected ResultSetMetaData metadata;
        protected ArrayList columnNameList;

        public RowData(ResultSet resultSet) {
            this.resultSet = resultSet;
            try {
                this.metadata = resultSet.getMetaData();
                this.columnNameList = new ArrayList();
                int cols = this.metadata.getColumnCount();
                for (int i = 1; i <= cols; ++i) {
                    this.columnNameList.add(this.metadata.getColumnName(i));
                }
            }
            catch (SQLException x) {
                throw new FacesException((Throwable)x);
            }
        }

        public Class getDataType(String column) throws PropertyNotFoundException {
            if (!this.columnNameList.contains(column)) {
                throw new PropertyNotFoundException("Invalid column name: " + column);
            }
            try {
                return Class.forName(this.metadata.getColumnClassName(this.columnNameList.indexOf(column) + 1));
            }
            catch (Exception x) {
                return null;
            }
        }

        public Object getData(String column) throws PropertyNotFoundException {
            if (!this.columnNameList.contains(column)) {
                throw new PropertyNotFoundException("Invalid column name: " + column);
            }
            try {
                if (Beans.isDesignTime()) {
                    return ResultSetPropertyResolver.getFakeData(this.metadata, column);
                }
                ResultSetPropertyResolver.initResultSet(this.resultSet);
                return this.resultSet.getObject(column);
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }

        public Object setData(String column, Object value) throws PropertyNotFoundException {
            if (!this.columnNameList.contains(column)) {
                throw new PropertyNotFoundException("Invalid column name: " + column);
            }
            try {
                if (!Beans.isDesignTime()) {
                    ResultSetPropertyResolver.initResultSet(this.resultSet);
                    Object previous = this.resultSet.getObject(column);
                    if (previous == null && value == null) {
                        return previous;
                    }
                    if (previous != null && value != null && previous.equals(value)) {
                        return previous;
                    }
                    this.resultSet.updateObject(column, value);
                    return previous;
                }
                Object previous = ResultSetPropertyResolver.getFakeData(this.metadata, column);
                return previous;
            }
            catch (SQLException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }
}

