/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.Mercurial;
import org.openide.awt.HtmlBrowser;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputLogger {
    private InputOutput log;
    private boolean ignoreCommand = false;
    private String repositoryRootString;
    private static final RequestProcessor rp = new RequestProcessor("MercurialOutput", 1);
    public static final int MAX_LINES_TO_PRINT = 500;
    private static final String MSG_TOO_MANY_LINES = "The number of output lines is greater than 500; see message log for complete output";

    public static OutputLogger getLogger(String string) {
        if (string != null) {
            return new OutputLogger(string);
        }
        return new NullLogger();
    }

    private OutputLogger(String string) {
        this.repositoryRootString = string;
        this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
    }

    private OutputLogger() {
    }

    public void closeLog() {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.log.getOut().flush();
                OutputLogger.this.log.getErr().flush();
            }
        });
    }

    public void flushLog() {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.log.getOut().flush();
                OutputLogger.this.log.getErr().flush();
            }
        });
    }

    public void output(final List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.log.select();
                OutputWriter outputWriter = OutputLogger.this.log.getOut();
                int n = list.size();
                if (n > 500) {
                    outputWriter.println((String)list.get(1));
                    outputWriter.println((String)list.get(2));
                    outputWriter.println((String)list.get(3));
                    outputWriter.println("...");
                    outputWriter.println((String)list.get(list.size() - 1));
                    outputWriter.println(OutputLogger.MSG_TOO_MANY_LINES);
                    for (String string : list) {
                        Mercurial.LOG.log(Level.WARNING, string);
                    }
                } else {
                    for (String string : list) {
                        outputWriter.println(string);
                    }
                }
                outputWriter.flush();
            }
        });
    }

    public void output(final String string) {
        if (string == null) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.log.select();
                OutputLogger.this.log.getOut().println(string);
                OutputLogger.this.log.getOut().flush();
            }
        });
    }

    public void outputInRed(final String string) {
        if (string == null) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.log.select();
                OutputLogger.this.log.getErr().println(string);
                OutputLogger.this.log.getErr().flush();
            }
        });
    }

    public void outputLink(final String string) {
        if (string == null) {
            return;
        }
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.log.select();
                try {
                    OutputWriter outputWriter = OutputLogger.this.log.getOut();
                    OutputListener outputListener = new OutputListener(){

                        public void outputLineAction(OutputEvent outputEvent) {
                            try {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(string));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }

                        public void outputLineSelected(OutputEvent outputEvent) {
                        }

                        public void outputLineCleared(OutputEvent outputEvent) {
                        }
                    };
                    outputWriter.println(string, outputListener, true);
                    outputWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void clearOutput() {
        rp.post(new Runnable(){

            public void run() {
                OutputLogger.this.log.select();
                OutputWriter outputWriter = OutputLogger.this.log.getOut();
                try {
                    outputWriter.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                outputWriter.flush();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        @Override
        public void closeLog() {
        }

        @Override
        public void flushLog() {
        }

        @Override
        public void output(List<String> list) {
        }

        @Override
        public void output(String string) {
        }

        @Override
        public void outputInRed(String string) {
        }

        @Override
        public void outputLink(String string) {
        }

        @Override
        public void clearOutput() {
        }
    }
}

