/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.clone;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ClonePanel
extends JPanel
implements ActionListener {
    private File repository;
    private JButton browseButton;
    private JLabel destinationLabel;
    private JLabel fromLabel;
    private JTextField fromTextField;
    private JCheckBox setMainCheckBox;
    private JTextField toCloneField;
    private JLabel toLabel;
    private JLabel toNameLabel;
    final JTextField toTextField = new JTextField();

    public ClonePanel(File file, File file2) {
        this.repository = file;
        this.initComponents();
        this.browseButton.addActionListener(this);
        this.setMainCheckBox.addActionListener(this);
        this.fromTextField.setText(file.getAbsolutePath());
        this.toTextField.setText(file2.getParent());
        this.toCloneField.setText(file2.getName());
        this.setMainCheckBox.setSelected(HgModuleConfig.getDefault().getSetMainProject());
    }

    public String getOutputFileName() {
        File file = new File(this.toTextField.getText(), this.toCloneField.getText());
        return file.getAbsolutePath();
    }

    private void initComponents() {
        this.fromLabel = new JLabel();
        this.toLabel = new JLabel();
        this.browseButton = new JButton();
        this.fromTextField = new JTextField();
        this.toNameLabel = new JLabel();
        this.toCloneField = new JTextField();
        this.destinationLabel = new JLabel();
        this.setMainCheckBox = new JCheckBox();
        this.fromLabel.setLabelFor(this.fromTextField);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.fromLabel.text"));
        this.toLabel.setLabelFor(this.toTextField);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.toLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.browseButton.text"));
        this.fromTextField.setEditable(false);
        this.toNameLabel.setLabelFor(this.toCloneField);
        Mnemonics.setLocalizedText((JLabel)this.toNameLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"ClonePanel.toName.text"));
        Mnemonics.setLocalizedText((JLabel)this.destinationLabel, (String)NbBundle.getMessage(ClonePanel.class, (String)"destinationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.setMainCheckBox, (String)NbBundle.getMessage(ClonePanel.class, (String)"openCheckbox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.destinationLabel).add((Component)this.fromLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.toNameLabel).add((Component)this.setMainCheckBox))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.toLabel))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fromTextField, -1, 258, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.toCloneField, -1, 165, Short.MAX_VALUE).add((Component)this.toTextField, -1, 165, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fromLabel).add((Component)this.fromTextField, -2, -1, -2)).add(18, 18, 18).add((Component)this.destinationLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.toTextField, -2, -1, -2).add((Component)this.toLabel)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.toCloneField, -2, -1, -2).add((Component)this.toNameLabel)).addPreferredGap(0).add((Component)this.setMainCheckBox, -2, 21, -2).addContainerGap()));
        this.toTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_toTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_Browse"));
        this.fromTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_fromTextField"));
        this.toCloneField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_toCloneField"));
        this.setMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_setMainCheckBox"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseButton) {
            this.onBrowseClick();
        } else if (actionEvent.getSource() == this.setMainCheckBox) {
            HgModuleConfig.getDefault().setSetMainProject(this.setMainCheckBox.isSelected());
        }
    }

    private void onBrowseClick() {
        File file = this.defaultWorkingDirectory();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(ClonePanel.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(ClonePanel.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
        }
        accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(ClonePanel.class, (String)"Folders");
            }
        });
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this, NbBundle.getMessage(ClonePanel.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.toTextField.setText(file2.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File file;
        File file2 = null;
        String string = this.toTextField.getText();
        if (string != null && !string.trim().equals("")) {
            for (file = new File(string); file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file != null) {
                file2 = file.isFile() ? file.getParentFile() : file;
            }
        }
        if (file2 == null && (file = ProjectChooser.getProjectsFolder()).exists() && file.isDirectory()) {
            file2 = file;
        }
        if (file2 == null) {
            file2 = new File(System.getProperty("user.home"));
        }
        return file2;
    }
}

