/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.mercurial.ui.diff.MultiDiffPanel;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

class DiffFileTable
implements MouseListener,
ListSelectionListener,
AncestorListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private Node[] nodes = new Node[0];
    private String[] tableColumns;
    private TableSorter sorter;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            Node.Property property = (Node.Property)object;
            Node.Property property2 = (Node.Property)object2;
            String string = (String)property.getValue("sortkey");
            if (string != null) {
                String string2 = (String)property2.getValue("sortkey");
                return string.compareToIgnoreCase(string2);
            }
            try {
                String string3 = (String)property.getValue();
                String string4 = (String)property2.getValue();
                return string3.compareToIgnoreCase(string4);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
                return 0;
            }
        }
    };
    private final MultiDiffPanel master;

    public DiffFileTable(MultiDiffPanel multiDiffPanel) {
        Object object = NbBundle.getBundle(DiffFileTable.class);
        columnLabels.put("name", new String[]{((ResourceBundle)object).getString("CTL_DiffTable_Column_Name_Title"), ((ResourceBundle)object).getString("CTL_DiffTable_Column_Name_Desc")});
        columnLabels.put("property", new String[]{((ResourceBundle)object).getString("CTL_DiffTable_Column_Property_Title"), ((ResourceBundle)object).getString("CTL_DiffTable_Column_Property_Desc")});
        columnLabels.put("status", new String[]{((ResourceBundle)object).getString("CTL_DiffTable_Column_Status_Title"), ((ResourceBundle)object).getString("CTL_DiffTable_Column_Status_Desc")});
        columnLabels.put("location", new String[]{((ResourceBundle)object).getString("CTL_DiffTable_Column_Location_Title"), ((ResourceBundle)object).getString("CTL_DiffTable_Column_Location_Desc")});
        this.master = multiDiffPanel;
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable((TableModel)this.sorter);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setSelectionMode(0);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        object = UIManager.getColor("scrollpane_border");
        if (object == null) {
            object = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)object));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new DiffTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffFileTable.class, (String)"ACSN_DiffTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffFileTable.class, (String)"ACSD_DiffTable"));
        this.setColumns(new String[]{"name", "property", "status", "location"});
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiffFileTable.this.showPopup(Utils.getPositionForPopup((JTable)DiffFileTable.this.table));
            }
        });
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                block5: {
                    int n;
                    block4: {
                        n = DiffFileTable.this.table.getWidth();
                        if (DiffFileTable.this.tableColumns.length != 3) break block4;
                        for (int i = 0; i < DiffFileTable.this.tableColumns.length; ++i) {
                            if ("location".equals(DiffFileTable.this.tableColumns[i])) {
                                DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 60 / 100);
                                continue;
                            }
                            DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 20 / 100);
                        }
                        break block5;
                    }
                    if (DiffFileTable.this.tableColumns.length != 4) break block5;
                    for (int i = 0; i < DiffFileTable.this.tableColumns.length; ++i) {
                        if ("location".equals(DiffFileTable.this.tableColumns[i])) {
                            DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 55 / 100);
                            continue;
                        }
                        DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n * 15 / 100);
                    }
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.tableColumns)) {
            return;
        }
        this.setModelProperties(stringArray);
        this.tableColumns = stringArray;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
        this.setDefaultColumnSizes();
    }

    private void setModelProperties(String[] stringArray) {
        Node.Property[] propertyArray = new Node.Property[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = columnLabels.get(string);
            propertyArray[i] = new ColumnDescriptor(string, String.class, stringArray2[0], stringArray2[1]);
        }
        this.tableModel.setProperties(propertyArray);
    }

    void setTableModel(Node[] nodeArray) {
        this.nodes = nodeArray;
        this.tableModel.setNodes(nodeArray);
    }

    void focus() {
        this.table.requestFocus();
    }

    void setSelectedIndex(int n) {
        if (n == this.table.getSelectedRow()) {
            return;
        }
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
    }

    public int getSelectedIndex() {
        return this.table.getSelectedRow();
    }

    public int getSelectedModelIndex() {
        return this.getModelIndex(this.table.getSelectedRow());
    }

    public int getModelIndex(int n) {
        return n != -1 ? this.sorter.modelIndex(n) : -1;
    }

    public JTable getTable() {
        return this.table;
    }

    private void showPopup(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            boolean bl = true;
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    private void showPopup(Point point) {
    }

    private JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopup(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (topComponent == null) {
            return;
        }
        this.master.setSelectedIndex(this.table.getSelectedRow());
    }

    private class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private DiffTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component;
            Object object2;
            int n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                object2 = DiffFileTable.this.nodes[DiffFileTable.this.sorter.modelIndex(n)];
                if (!bl) {
                    object = "<html>" + object2.getHtmlDisplayName();
                }
            }
            if ((component = n3 == 2 ? this.pathRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JComponent) {
                object2 = (File)DiffFileTable.this.nodes[DiffFileTable.this.sorter.modelIndex(n)].getLookup().lookup(File.class);
                String string = object2 != null ? ((File)object2).getAbsolutePath() : null;
                ((JComponent)component).setToolTipText(string);
            }
            return component;
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

