/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.DiffStreamSource;
import org.netbeans.modules.mercurial.ui.log.DiffTreeTable;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.RevisionNode;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiffResultsView
implements AncestorListener,
PropertyChangeListener,
DiffSetupSource {
    private final SearchHistoryPanel parent;
    private DiffTreeTable treeView;
    private JSplitPane diffView;
    private ShowDiffTask currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    private DiffView currentDiff;
    private int currentDifferenceIndex;
    private int currentIndex;
    private boolean dividerSet;
    private List<RepositoryRevision> results;
    private static final RequestProcessor rp = new RequestProcessor("MercurialDiff", 1, true);
    private static String HgNoRev = "-1";
    private boolean onSelectionshowLastDifference;

    public DiffResultsView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
        this.parent = searchHistoryPanel;
        this.results = list;
        this.treeView = new DiffTreeTable(searchHistoryPanel);
        this.treeView.setResults(list);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this.treeView));
        explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.dividerSet) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this.treeView));
        explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            final Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            this.currentDifferenceIndex = 0;
            if (nodeArray.length == 0) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (nodeArray.length > 2) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    RepositoryRevision repositoryRevision = (RepositoryRevision)nodeArray[0].getLookup().lookup(RepositoryRevision.class);
                    RepositoryRevision.Event event = (RepositoryRevision.Event)nodeArray[0].getLookup().lookup(RepositoryRevision.Event.class);
                    try {
                        DiffResultsView.this.currentIndex = DiffResultsView.this.treeView.getSelection()[0];
                        if (nodeArray.length == 1) {
                            if (repositoryRevision != null) {
                                DiffResultsView.this.showContainerDiff(repositoryRevision, DiffResultsView.this.onSelectionshowLastDifference);
                            } else if (event != null) {
                                DiffResultsView.this.showRevisionDiff(event, DiffResultsView.this.onSelectionshowLastDifference);
                            }
                        } else if (nodeArray.length == 2) {
                            RepositoryRevision.Event event2 = (RepositoryRevision.Event)nodeArray[1].getLookup().lookup(RepositoryRevision.Event.class);
                            if (event2.getFile() == null || !event2.getFile().equals(event.getFile())) {
                                throw new Exception();
                            }
                            DiffResultsView.this.showDiff(event, event.getLogInfoHeader().getLog().getRevision(), event2.getLogInfoHeader().getLog().getRevision(), false);
                        }
                    }
                    catch (Exception exception) {
                        DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        DiffResultsView.this.parent.refreshComponents(false);
                        return;
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public Collection getSetups() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length == 0) {
            return this.parent.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
        for (Node node : nodeArray) {
            RevisionNode revisionNode = (RevisionNode)node;
            if (revisionNode.getEvent() != null) {
                hashSet.add(revisionNode.getEvent());
                continue;
            }
            hashSet2.add(revisionNode.getContainer());
        }
        return this.parent.getSetups(hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    private void showDiffError(String string) {
        this.setBottomComponent((Component)new NoContentPanel(string));
    }

    private void setBottomComponent(Component component) {
        int n = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDiff(RepositoryRevision.Event event, String string, String string2, boolean bl) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            char c = event.getChangedPath().getAction();
            if (c == HgLogMessage.HgModStatus) {
                this.currentTask = new ShowDiffTask(event, string, string2, bl);
            } else if (c == HgLogMessage.HgAddStatus) {
                this.currentTask = new ShowDiffTask(event, HgNoRev, string2, bl);
            } else if (c == HgLogMessage.HgDelStatus) {
                this.currentTask = new ShowDiffTask(event, string, HgNoRev, bl);
            } else if (c == HgLogMessage.HgCopyStatus) {
                this.currentTask = new ShowDiffTask(event, HgNoRev, string2, bl);
            }
            this.currentShowDiffTask = rp.create((Runnable)this.currentTask);
            this.currentShowDiffTask.schedule(0);
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    private void setDiffIndex(int n, boolean bl) {
        this.currentIndex = n;
        this.onSelectionshowLastDifference = bl;
        this.treeView.setSelection(n);
    }

    private void showRevisionDiff(RepositoryRevision.Event event, boolean bl) {
        if (event.getFile() == null) {
            return;
        }
        long l = Long.parseLong(event.getLogInfoHeader().getLog().getRevision());
        String string = event.getLogInfoHeader().getLog().getAncestor();
        this.showDiff(event, string != null ? string : Long.toString(l - 1L), Long.toString(l), bl);
    }

    private void showContainerDiff(RepositoryRevision repositoryRevision, boolean bl) {
        File[] fileArray;
        List<RepositoryRevision.Event> list = repositoryRevision.getEvents();
        RepositoryRevision.Event event = null;
        for (File file : fileArray = this.parent.getRoots()) {
            for (RepositoryRevision.Event event2 : list) {
                if (!file.equals(event2.getFile())) continue;
                event = event2;
            }
        }
        if (event == null) {
            event = list.get(0);
        }
        if (event.getFile() == null) {
            return;
        }
        long l = Long.parseLong(event.getLogInfoHeader().getLog().getRevision());
        String string = event.getLogInfoHeader().getLog().getAncestor();
        this.showDiff(event, string != null ? string : Long.toString(l - 1L), Long.toString(l), bl);
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else {
                this.currentDiff.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(RepositoryRevision.Event event) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(event);
    }

    void select(RepositoryRevision repositoryRevision) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(repositoryRevision);
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    implements Runnable,
    Cancellable {
        private final RepositoryRevision.Event header;
        private final String revision1;
        private final String revision2;
        private boolean showLastDifference;
        private volatile boolean cancelled;

        public ShowDiffTask(RepositoryRevision.Event event, String string, String string2, boolean bl) {
            this.header = event;
            this.revision1 = string;
            this.revision2 = string2;
            this.showLastDifference = bl;
        }

        public void run() {
            final Diff diff = Diff.getDefault();
            final DiffStreamSource diffStreamSource = new DiffStreamSource(this.header.getFile(), this.revision1, this.revision1);
            final DiffStreamSource diffStreamSource2 = new DiffStreamSource(this.header.getFile(), this.revision2, this.revision2);
            diffStreamSource.getMIMEType();
            if (this.cancelled) {
                return;
            }
            diffStreamSource2.getMIMEType();
            if (this.cancelled) {
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (ShowDiffTask.this.cancelled) {
                            return;
                        }
                        DiffView diffView = diff.createDiff((StreamSource)diffStreamSource, (StreamSource)diffStreamSource2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = diffView;
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getComponent());
                            if (DiffResultsView.this.currentDiff.getDifferenceCount() > 0) {
                                DiffResultsView.this.currentDifferenceIndex = ShowDiffTask.this.showLastDifference ? DiffResultsView.this.currentDiff.getDifferenceCount() - 1 : 0;
                                DiffResultsView.this.currentDiff.setCurrentDifference(DiffResultsView.this.currentDifferenceIndex);
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
            });
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

