/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessageChangedPath;
import org.netbeans.modules.mercurial.util.HgCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgLogMessage {
    public static char HgModStatus = (char)77;
    public static char HgAddStatus = (char)65;
    public static char HgDelStatus = (char)82;
    public static char HgCopyStatus = (char)67;
    private List<HgLogMessageChangedPath> mpaths;
    private List<HgLogMessageChangedPath> apaths;
    private List<HgLogMessageChangedPath> dpaths;
    private List<HgLogMessageChangedPath> cpaths;
    private String rev;
    private String author;
    private String desc;
    private Date date;
    private String id;
    private String timeZoneOffset;
    private String parentOneRev;
    private String parentTwoRev;
    private boolean bMerged;
    private String rootURL;
    private OutputLogger logger;

    public HgLogMessage(String string) {
    }

    private void updatePaths(List<HgLogMessageChangedPath> list, List<String> list2, String string, List<String> list3, char c) {
        block2: {
            block1: {
                if (!list3.isEmpty()) break block1;
                list.add(new HgLogMessageChangedPath(string, c));
                if (list2 == null) break block2;
                list2.add(string);
                break block2;
            }
            for (String string2 : list3) {
                if (!string.equals(string2) && !string.startsWith(string2)) continue;
                list.add(new HgLogMessageChangedPath(string, c));
                if (list2 == null) break;
                list2.add(string);
                break;
            }
        }
    }

    public HgLogMessage(String string, List<String> list, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        Object object;
        Object object2;
        String[] stringArray;
        this.rootURL = string;
        this.rev = string2;
        this.author = string3;
        this.desc = string4;
        String[] stringArray2 = stringArray = string7 != null ? string7.split(" ") : null;
        if (stringArray != null && stringArray.length == 2) {
            object2 = stringArray[0].split(":");
            this.parentOneRev = object2 != null && ((String[])object2).length >= 1 ? object2[0] : null;
            object = stringArray[1].split(":");
            this.parentTwoRev = object != null && ((String[])object).length >= 1 ? object[0] : null;
        }
        this.bMerged = this.parentOneRev != null && this.parentTwoRev != null && !this.parentOneRev.equals("-1") && !this.parentTwoRev.equals("-1");
        String[] stringArray3 = string5.split(" ");
        this.date = new Date(Long.parseLong(stringArray3[0]) * 1000L);
        this.id = string6;
        this.mpaths = new ArrayList<HgLogMessageChangedPath>();
        this.apaths = new ArrayList<HgLogMessageChangedPath>();
        this.dpaths = new ArrayList<HgLogMessageChangedPath>();
        this.cpaths = new ArrayList<HgLogMessageChangedPath>();
        object2 = new ArrayList();
        object = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string11 != null && !string11.equals("")) {
            for (String string12 : stringArray3 = string11.split(" ")) {
                this.updatePaths(this.cpaths, arrayList, string12, list, HgCopyStatus);
            }
        }
        if (string9 != null && !string9.equals("")) {
            for (String string12 : stringArray3 = string9.split(" ")) {
                if (arrayList.contains(string12)) continue;
                this.updatePaths(this.apaths, (List<String>)object2, string12, list, HgAddStatus);
            }
        }
        if (string10 != null && !string10.equals("")) {
            for (String string12 : stringArray3 = string10.split(" ")) {
                this.updatePaths(this.dpaths, (List<String>)object, string12, list, HgDelStatus);
            }
        }
        if (string8 != null && !string8.equals("")) {
            for (String string12 : stringArray3 = string8.split(" ")) {
                if (object2.contains(string12) || object.contains(string12) || arrayList.contains(string12)) continue;
                this.updatePaths(this.mpaths, null, string12, list, HgModStatus);
            }
        }
    }

    private void debugLogCopied(String string) {
        FileStatus fileStatus;
        File file = new File(string);
        FileInformation fileInformation = Mercurial.getInstance().getFileStatusCache().getStatus(file);
        FileStatus fileStatus2 = fileStatus = fileInformation != null ? fileInformation.getStatus(file) : null;
        if (fileStatus != null && fileStatus.isCopied()) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed("*** Copied: " + string + " : " + fileStatus.getFile() != null ? fileStatus.getFile().getAbsolutePath() : "no filepath");
            outputLogger.closeLog();
        }
    }

    public HgLogMessageChangedPath[] getChangedPaths() {
        ArrayList<HgLogMessageChangedPath> arrayList = new ArrayList<HgLogMessageChangedPath>();
        if (!this.mpaths.isEmpty()) {
            arrayList.addAll(this.mpaths);
        }
        if (!this.apaths.isEmpty()) {
            arrayList.addAll(this.apaths);
        }
        if (!this.dpaths.isEmpty()) {
            arrayList.addAll(this.dpaths);
        }
        if (!this.cpaths.isEmpty()) {
            arrayList.addAll(this.cpaths);
        }
        return arrayList.toArray(new HgLogMessageChangedPath[0]);
    }

    public String getRevision() {
        return this.rev;
    }

    public long getRevisionAsLong() {
        long l;
        try {
            l = Long.parseLong(this.rev);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        return l;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCSetShortID() {
        return this.id;
    }

    public String getAncestor() {
        if (this.bMerged) {
            try {
                return HgCommand.getCommonAncestor(this.rootURL, this.parentOneRev, this.parentTwoRev, this.getLogger());
            }
            catch (HgException hgException) {
                return null;
            }
        }
        int n = -1;
        try {
            n = Integer.parseInt(this.rev);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n = n > -1 ? n - 1 : -1;
        return Integer.toString(n);
    }

    private OutputLogger getLogger() {
        if (this.logger == null) {
            this.logger = Mercurial.getInstance().getLogger(this.rootURL);
        }
        return this.logger;
    }

    public String getMessage() {
        return this.desc;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(String string) {
        this.timeZoneOffset = string;
    }

    public String toString() {
        String string = null;
        string = "rev: " + this.rev + "\nauthor: " + this.author + "\ndesc: " + this.desc + "\ndate: " + this.date + "\nid: " + this.id + "\nfm: " + this.mpaths + "\nfa: " + this.apaths + "\nfd: " + this.dpaths + "\nfc: " + this.cpaths;
        return string;
    }
}

