/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.SearchCriteriaPanel;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchExecutor
implements Runnable {
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat fullDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    static final DateFormat[] dateFormats = new DateFormat[]{fullDateFormat, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), simpleDateFormat, new SimpleDateFormat("yyyy-MM-dd")};
    private final SearchHistoryPanel master;
    private Map<String, Set<File>> workFiles;
    private Map<String, File> pathToRoot;
    private final SearchCriteriaPanel criteria;
    private boolean filterUsername;
    private boolean filterMessage;
    private int completedSearches;
    private boolean searchCanceled;
    private List<RepositoryRevision> results = new ArrayList<RepositoryRevision>();

    public SearchExecutor(SearchHistoryPanel searchHistoryPanel) {
        this.master = searchHistoryPanel;
        this.criteria = searchHistoryPanel.getCriteria();
        this.filterUsername = this.criteria.getUsername() != null;
        this.filterMessage = this.criteria.getCommitMessage() != null;
        this.pathToRoot = new HashMap<String, File>();
        if (this.searchingUrl()) {
            String string = Mercurial.getInstance().getTopmostManagedParent(searchHistoryPanel.getRoots()[0]).toString();
            this.pathToRoot.put(string, searchHistoryPanel.getRoots()[0]);
        } else {
            this.workFiles = new HashMap<String, Set<File>>();
            for (File file : searchHistoryPanel.getRoots()) {
                String string = Mercurial.getInstance().getTopmostManagedParent(file).toString();
                Set<File> set = this.workFiles.get(string);
                if (set == null) {
                    set = new HashSet<File>(2);
                    this.workFiles.put(string, set);
                }
                set.add(file);
            }
        }
    }

    @Override
    public void run() {
        final String string = this.criteria.getFrom();
        final String string2 = this.criteria.getTo();
        this.completedSearches = 0;
        if (this.searchingUrl()) {
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(this.master.getRepositoryUrl());
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    OutputLogger outputLogger = this.getLogger();
                    SearchExecutor.this.search(SearchExecutor.this.master.getRepositoryUrl(), null, string, string2, this, outputLogger);
                }
            };
            hgProgressSupport.start(requestProcessor, this.master.getRepositoryUrl(), NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
        } else {
            for (final String string3 : this.workFiles.keySet()) {
                final Set<File> set = this.workFiles.get(string3);
                RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string3);
                HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                    public void perform() {
                        OutputLogger outputLogger = this.getLogger();
                        SearchExecutor.this.search(string3, set, string, string2, this, outputLogger);
                    }
                };
                hgProgressSupport.start(requestProcessor, string3, NbBundle.getMessage(SearchExecutor.class, (String)"MSG_Search_Progress"));
            }
        }
    }

    private void search(String string, Set<File> set, String string2, String string3, HgProgressSupport hgProgressSupport, OutputLogger outputLogger) {
        if (hgProgressSupport.isCanceled()) {
            this.searchCanceled = true;
            return;
        }
        HgLogMessage[] hgLogMessageArray = this.master.isIncomingSearch() ? HgCommand.getIncomingMessages(string, string3, this.master.isShowMerges(), outputLogger) : (this.master.isOutSearch() ? HgCommand.getOutMessages(string, string3, this.master.isShowMerges(), outputLogger) : HgCommand.getLogMessages(string, set, string2, string3, this.master.isShowMerges(), outputLogger));
        this.appendResults(string, hgLogMessageArray);
    }

    private synchronized void appendResults(String string, HgLogMessage[] hgLogMessageArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = hgLogMessageArray.length - 1; i >= 0; --i) {
            HgLogMessage hgLogMessage = hgLogMessageArray[i];
            if (this.filterUsername && hgLogMessage.getAuthor().indexOf(this.criteria.getUsername()) == -1 || this.filterMessage && hgLogMessage.getMessage().indexOf(this.criteria.getCommitMessage()) == -1) continue;
            RepositoryRevision repositoryRevision = new RepositoryRevision(hgLogMessage, string);
            for (RepositoryRevision.Event event : repositoryRevision.getEvents()) {
                String string2;
                if (event.getChangedPath().getAction() == 'A' && event.getChangedPath().getCopySrcPath() != null) {
                    string2 = (String)hashMap.get(event.getChangedPath().getPath());
                    if (string2 == null) {
                        string2 = event.getChangedPath().getPath();
                    }
                    hashMap.put(event.getChangedPath().getCopySrcPath(), string2);
                }
                string2 = event.getChangedPath().getPath();
                for (String string3 : hashMap.keySet()) {
                    if (!string2.startsWith(string3) || string2.length() != string3.length() && string2.charAt(string3.length()) != '/') continue;
                    string2 = (String)hashMap.get(string3) + string2.substring(string3.length());
                    break;
                }
                File file = new File(string + File.separator + string2);
                event.setFile(file);
            }
            this.results.add(repositoryRevision);
        }
        if (this.results.isEmpty()) {
            this.results = null;
        }
        this.checkFinished();
    }

    private boolean searchingUrl() {
        return this.master.getRepositoryUrl() != null;
    }

    private void checkFinished() {
        ++this.completedSearches;
        if (this.searchingUrl() && this.completedSearches >= 1 || this.workFiles.size() == this.completedSearches) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchExecutor.this.master.setResults(SearchExecutor.this.results);
                }
            });
        }
    }
}

