/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.net.MalformedURLException;
import org.netbeans.modules.mercurial.ui.repository.HgURL;

public class RepositoryConnection {
    private static final String RC_DELIMITER = "~=~";
    private String url;
    private String username;
    private String password;
    private String externalCommand;
    private boolean savePassword;
    private HgURL hgUrl;

    public RepositoryConnection(RepositoryConnection repositoryConnection) {
        this(repositoryConnection.url, repositoryConnection.username, repositoryConnection.password, repositoryConnection.externalCommand, repositoryConnection.savePassword);
    }

    public RepositoryConnection(String string) {
        this(string, null, null, null, false);
    }

    public RepositoryConnection(String string, String string2, String string3, String string4, boolean bl) {
        this.setUrl(string);
        this.setUsername(string2);
        this.setPassword(string3);
        this.setExternalCommand(string4);
        this.savePassword = bl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username == null ? "" : this.username;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public String getExternalCommand() {
        return this.externalCommand == null ? "" : this.externalCommand;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public HgURL getHgUrl() throws MalformedURLException {
        if (this.hgUrl == null) {
            this.parseUrlString(this.url);
        }
        return this.hgUrl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RepositoryConnection repositoryConnection = (RepositoryConnection)object;
        return this.url == repositoryConnection.url || this.url == null || this.url.equals(repositoryConnection.url);
    }

    public int hashCode() {
        int n = 3;
        n = 61 * n + (this.url != null ? this.url.hashCode() : 0);
        return n;
    }

    void setUrl(String string) {
        this.url = string;
        this.hgUrl = null;
    }

    void setUsername(String string) {
        this.username = string;
    }

    void setPassword(String string) {
        this.password = string;
    }

    void setExternalCommand(String string) {
        this.externalCommand = string;
    }

    void setSavePassword(boolean bl) {
        this.savePassword = bl;
    }

    public String toString() {
        return this.url;
    }

    private void parseUrlString(String string) throws MalformedURLException {
        int n = string.indexOf("://");
        this.hgUrl = new HgURL(string);
    }

    public static String getString(RepositoryConnection repositoryConnection) {
        String string = repositoryConnection.getUrl();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(repositoryConnection.getUsername());
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(repositoryConnection.getExternalCommand());
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(RC_DELIMITER);
        return stringBuffer.toString();
    }

    public static RepositoryConnection parse(String string) {
        String[] stringArray = string.split(RC_DELIMITER);
        int n = stringArray.length;
        String string2 = stringArray[0];
        String string3 = n > 1 && !stringArray[1].equals("") ? stringArray[1] : null;
        String string4 = null;
        String string5 = n > 3 && !stringArray[3].equals("") ? stringArray[3] : null;
        boolean bl = n > 4 && !stringArray[4].equals("") ? Boolean.parseBoolean(stringArray[4]) : true;
        return new RepositoryConnection(string2, string3, string4, string5, bl);
    }
}

