/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileSelector
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    private static final String PROPERTIES_EXT = ".properties";
    private static final String DEFAULT_BUNDLE_NAME = "Bundle";
    private DataObject template;
    private ExplorerManager manager;
    private DataObject selectedDataObject;
    private DataFolder selectedFolder;
    private boolean confirmed;
    private JButton newButton;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField fileNameTextField;

    public FileSelector(FileObject fileObject, DataObject dataObject) {
        this(SelectorUtils.bundlesNode(null, fileObject, dataObject == null), dataObject);
    }

    private FileSelector(Node node, DataObject dataObject) {
        this.template = dataObject;
        this.manager = new ExplorerManager();
        this.manager.setRootContext(node);
        try {
            this.manager.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
        }
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        if (dataObject != null) {
            this.newButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)FileSelector.getLocMessage("CTL_CreateNewButton"));
            this.newButton.getAccessibleContext().setAccessibleName(FileSelector.getLocMessage("ACSN_CreateNewBundle"));
            this.newButton.getAccessibleContext().setAccessibleDescription(FileSelector.getLocMessage("ACSD_CreateNewBundle"));
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    block7: {
                        if (FileSelector.this.selectedFolder == null) {
                            return;
                        }
                        String string = FileSelector.this.fileNameTextField.getText();
                        try {
                            if (string.equals("")) {
                                string = FileSelector.DEFAULT_BUNDLE_NAME;
                            } else if (string.toLowerCase().endsWith(FileSelector.PROPERTIES_EXT)) {
                                string = string.substring(0, string.length() - FileSelector.PROPERTIES_EXT.length());
                            }
                            FileSelector.this.selectedDataObject = FileSelector.this.template.createFromTemplate(FileSelector.this.selectedFolder, string);
                            Node[] nodeArray = FileSelector.this.manager.getSelectedNodes();
                            if (nodeArray == null || nodeArray.length != 1 || nodeArray[0].getCookie(DataObject.class) != FileSelector.this.selectedFolder) break block7;
                            Node[] nodeArray2 = nodeArray[0].getChildren().getNodes(true);
                            for (int i = 0; i < nodeArray2.length; ++i) {
                                if (nodeArray2[i].getCookie(DataObject.class) != FileSelector.this.selectedDataObject) continue;
                                FileSelector.this.manager.setSelectedNodes(new Node[]{nodeArray2[i]});
                                break;
                            }
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify(1, (Throwable)exception);
                        }
                    }
                }
            });
            this.newButton.setEnabled(false);
        }
        this.okButton = new JButton(NbBundle.getMessage(FileSelector.class, (String)"CTL_OKButton"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSelector.this.confirmed = true;
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(FileSelector.getLocMessage("CTL_CancelButton"));
        this.cancelButton.getAccessibleContext().setAccessibleName(FileSelector.getLocMessage("ACSN_CancelSelection"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(FileSelector.getLocMessage("ACSD_CancelSelection"));
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setPopupAllowed(false);
        beanTreeView.setDefaultActionAllowed(false);
        beanTreeView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        beanTreeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSelector.class, (String)"ACSN_FileSelectorTreeView"));
        beanTreeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSelector.class, (String)"ACSD_FileSelectorPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)FileSelector.getLocMessage("LBL_ExistingBundles"));
        jLabel.setLabelFor(beanTreeView.getViewport());
        JLabel jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)FileSelector.getLocMessage("LBL_FileName"));
        jLabel2.getAccessibleContext().setAccessibleName(FileSelector.getLocMessage("ACSN_FileName"));
        jLabel2.getAccessibleContext().setAccessibleDescription(FileSelector.getLocMessage("ACSD_FileName"));
        this.fileNameTextField = new JTextField();
        this.fileNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                FileSelector.this.checkFileName();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FileSelector.this.checkFileName();
            }
        });
        jLabel2.setLabelFor(this.fileNameTextField);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setAutocreateGaps(true);
        groupLayout.setAutocreateContainerGaps(true);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)jLabel).add((Component)beanTreeView, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel2).add((Component)this.fileNameTextField)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel).add((Component)beanTreeView, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.fileNameTextField)));
    }

    private static String getLocMessage(String string) {
        return NbBundle.getMessage(FileSelector.class, (String)string);
    }

    public Dialog getDialog(String string, ActionListener actionListener) {
        Object[] objectArray;
        if (this.newButton != null) {
            JButton[] jButtonArray = new JButton[3];
            jButtonArray[0] = this.newButton;
            jButtonArray[1] = this.okButton;
            objectArray = jButtonArray;
            jButtonArray[2] = this.cancelButton;
        } else {
            Object[] objectArray2 = new JButton[2];
            objectArray2[0] = this.okButton;
            objectArray = objectArray2;
            objectArray2[1] = this.cancelButton;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, string, true, objectArray, (Object)this.okButton, 0, HelpCtx.DEFAULT_HELP, null);
        dialogDescriptor.setClosingOptions((Object[])new JButton[]{this.okButton, this.cancelButton});
        if (actionListener != null) {
            this.okButton.addActionListener(actionListener);
        }
        return DialogDisplayer.getDefault().createDialog(dialogDescriptor);
    }

    public void addNotify() {
        this.confirmed = false;
        super.addNotify();
    }

    boolean isConfirmed() {
        return this.confirmed;
    }

    public DataObject getSelectedDataObject() {
        return this.selectedDataObject;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            DataObject dataObject;
            Node[] nodeArray = this.manager.getSelectedNodes();
            this.selectedDataObject = null;
            this.selectedFolder = null;
            if (nodeArray != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) != null) {
                if (dataObject instanceof PropertiesDataObject) {
                    this.fileNameTextField.setText(dataObject.getName());
                    this.selectedDataObject = dataObject;
                    this.selectedFolder = dataObject.getFolder();
                } else if (dataObject instanceof DataFolder) {
                    this.fileNameTextField.setText("");
                    this.selectedFolder = (DataFolder)dataObject;
                } else {
                    this.selectedFolder = dataObject.getFolder();
                }
            }
            this.okButton.setEnabled(this.selectedDataObject != null);
            if (this.newButton != null) {
                this.newButton.setEnabled(this.selectedFolder != null && this.selectedDataObject == null && !this.checkForDefaultBundle());
            }
        }
    }

    private boolean checkForDefaultBundle() {
        if (this.selectedFolder != null) {
            return this.selectedFolder.getPrimaryFile().getFileObject("Bundle.properties") != null;
        }
        return false;
    }

    private void checkFileName() {
        if (this.selectedFolder == null) {
            return;
        }
        this.selectedDataObject = null;
        String string = this.fileNameTextField.getText();
        if ("".equals(string)) {
            this.okButton.setEnabled(false);
            if (this.newButton != null) {
                this.newButton.setEnabled(!this.checkForDefaultBundle());
            }
        } else {
            FileObject fileObject;
            if (!string.toLowerCase().endsWith(PROPERTIES_EXT)) {
                string = string + PROPERTIES_EXT;
            }
            if ((fileObject = this.selectedFolder.getPrimaryFile().getFileObject(string)) != null) {
                try {
                    this.selectedDataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                }
            }
            this.okButton.setEnabled(this.selectedDataObject != null);
            if (this.newButton != null) {
                this.newButton.setEnabled(this.selectedDataObject == null);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }
}

